/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.gates;

import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.fpga.designrulecheck.Netlist;
import com.cburch.logisim.fpga.hdlgenerator.AbstractHdlGeneratorFactory;
import com.cburch.logisim.fpga.hdlgenerator.Hdl;
import com.cburch.logisim.std.gates.Pla;
import com.cburch.logisim.std.gates.PlaTable;
import com.cburch.logisim.util.LineBuffer;

public class PlaHdlGeneratorFactory
extends AbstractHdlGeneratorFactory {
    public PlaHdlGeneratorFactory() {
        this.myPorts.add("input", "index", 0, 0, Pla.ATTR_IN_WIDTH).add("output", "result", 0, 1, Pla.ATTR_OUT_WIDTH);
    }

    private static String bits(char[] b) {
        StringBuilder s = new StringBuilder();
        for (int n : b) {
            s.insert(0, (char)(n == 48 || n == 49 ? n : 45));
        }
        if (b.length == 1) {
            return "'" + s + "'";
        }
        return "\"" + s + "\"";
    }

    private static String zeros(int sz) {
        StringBuilder s = new StringBuilder();
        s.append("0".repeat(sz));
        if (sz == 1) {
            return "'" + s + "'";
        }
        return "\"" + s + "\"";
    }

    @Override
    public LineBuffer getModuleFunctionality(Netlist nets, AttributeSet attrs) {
        LineBuffer contents = LineBuffer.getHdlBuffer().addVhdlKeywords().empty();
        PlaTable tt = attrs.getValue(Pla.ATTR_TABLE);
        int outSz = attrs.getValue(Pla.ATTR_OUT_WIDTH).getWidth();
        if (Hdl.isVhdl()) {
            String leader = "result <= ";
            if (tt.rows().isEmpty()) {
                contents.add("{{1}}{{2}};", leader, PlaHdlGeneratorFactory.zeros(outSz));
            } else {
                for (PlaTable.Row r : tt.rows()) {
                    contents.add("{{1}}{{2}} {{when}} std_match(Index, {{3}}) {{else}}", leader, PlaHdlGeneratorFactory.bits(r.outBits), PlaHdlGeneratorFactory.bits(r.inBits));
                    leader = " ".repeat(leader.length());
                }
                contents.add("{{1}}{{2}};", leader, PlaHdlGeneratorFactory.zeros(outSz));
            }
        }
        return contents.empty();
    }

    @Override
    public boolean isHdlSupportedTarget(AttributeSet attrs) {
        return Hdl.isVhdl();
    }
}

