/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.hdl;

import com.cburch.hdl.HdlModel;
import com.cburch.logisim.gui.generic.OptionPane;
import com.cburch.logisim.instance.Port;
import com.cburch.logisim.std.hdl.HdlContent;
import com.cburch.logisim.std.hdl.VhdlParser;
import com.cburch.logisim.util.Softwares;
import com.cburch.logisim.vhdl.Strings;
import java.awt.Dimension;
import java.awt.Insets;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class VhdlContentComponent
extends HdlContent {
    private static final String RESOURCE = "/resources/logisim/hdl/vhdl.templ";
    private static final String TEMPLATE = VhdlContentComponent.loadTemplate();
    protected StringBuilder content;
    protected Port[] inputs;
    protected Port[] outputs;
    protected String name;
    protected String libraries;
    protected String architecture;

    public static VhdlContentComponent create() {
        return new VhdlContentComponent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String loadTemplate() {
        InputStream input = VhdlContentComponent.class.getResourceAsStream(RESOURCE);
        BufferedReader in = new BufferedReader(new InputStreamReader(input));
        StringBuilder tmp = new StringBuilder();
        try {
            String line;
            while ((line = in.readLine()) != null) {
                tmp.append(line);
                tmp.append(System.getProperty("line.separator"));
            }
        }
        catch (IOException ex) {
            String string = "";
            return string;
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException ex) {
                Logger.getLogger(VhdlContentComponent.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return tmp.toString();
    }

    protected VhdlContentComponent() {
        this.parseContent(TEMPLATE);
    }

    @Override
    public VhdlContentComponent clone() {
        try {
            VhdlContentComponent ret = (VhdlContentComponent)super.clone();
            ret.content = new StringBuilder(this.content);
            return ret;
        }
        catch (CloneNotSupportedException ex) {
            return this;
        }
    }

    @Override
    public boolean compare(HdlModel model) {
        return this.compare(model.getContent());
    }

    @Override
    public boolean compare(String value) {
        return this.content.toString().replaceAll("\\r\\n|\\r|\\n", " ").equals(value.replaceAll("\\r\\n|\\r|\\n", " "));
    }

    public String getArchitecture() {
        if (this.architecture == null) {
            return "";
        }
        return this.architecture;
    }

    @Override
    public String getContent() {
        return this.content.toString();
    }

    public Port[] getInputs() {
        if (this.inputs == null) {
            return new Port[0];
        }
        return this.inputs;
    }

    public int getInputsNumber() {
        if (this.inputs == null) {
            return 0;
        }
        return this.inputs.length;
    }

    public String getLibraries() {
        if (this.libraries == null) {
            return "";
        }
        return this.libraries;
    }

    @Override
    public String getName() {
        if (this.name == null) {
            return "";
        }
        return this.name;
    }

    public Port[] getOutputs() {
        if (this.outputs == null) {
            return new Port[0];
        }
        return this.outputs;
    }

    public int getOutputsNumber() {
        if (this.outputs == null) {
            return 0;
        }
        return this.outputs.length;
    }

    public Port[] getPorts() {
        if (this.inputs == null || this.outputs == null) {
            return new Port[0];
        }
        return VhdlContentComponent.concat(this.inputs, this.outputs);
    }

    public int getPortsNumber() {
        if (this.inputs == null || this.outputs == null) {
            return 0;
        }
        return this.inputs.length + this.outputs.length;
    }

    public boolean parseContent(String content) {
        VhdlParser.PortDescription desc;
        int i;
        VhdlParser parser = new VhdlParser(content);
        try {
            parser.parse();
        }
        catch (Exception ex) {
            OptionPane.showMessageDialog(null, ex.getMessage(), Strings.S.get("validationParseError"), 0);
            return false;
        }
        this.name = parser.getName();
        this.libraries = parser.getLibraries();
        this.architecture = parser.getArchitecture();
        List<VhdlParser.PortDescription> inputsDesc = parser.getInputs();
        List<VhdlParser.PortDescription> outputsDesc = parser.getOutputs();
        this.inputs = new Port[inputsDesc.size()];
        this.outputs = new Port[outputsDesc.size()];
        for (i = 0; i < inputsDesc.size(); ++i) {
            desc = inputsDesc.get(i);
            this.inputs[i] = new Port(0, i * 10 + 40, desc.getType(), desc.getWidth());
            this.inputs[i].setToolTip(Strings.S.getter(desc.getName()));
        }
        for (i = 0; i < outputsDesc.size(); ++i) {
            desc = outputsDesc.get(i);
            this.outputs[i] = new Port(140, i * 10 + 40, desc.getType(), desc.getWidth());
            this.outputs[i].setToolTip(Strings.S.getter(desc.getName()));
        }
        this.content = new StringBuilder(content);
        this.fireContentSet();
        return true;
    }

    @Override
    public boolean setContent(String content) {
        StringBuilder title = new StringBuilder();
        StringBuilder result = new StringBuilder();
        switch (Softwares.validateVhdl(content, title, result)) {
            case 1: {
                JTextArea message = new JTextArea();
                message.setText(result.toString());
                message.setEditable(false);
                message.setLineWrap(false);
                message.setMargin(new Insets(5, 5, 5, 5));
                JScrollPane sp = new JScrollPane(message);
                sp.setPreferredSize(new Dimension(700, 400));
                OptionPane.showOptionDialog(null, sp, title.toString(), 0, 0, null, new String[]{Strings.S.get("validationErrorButton")}, Strings.S.get("validationErrorButton"));
                return false;
            }
            case 2: {
                OptionPane.showMessageDialog(null, result.toString(), title.toString(), 1);
                return false;
            }
            case 0: {
                return this.parseContent(content);
            }
        }
        return false;
    }
}

