/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.hdl;

import com.cburch.hdl.HdlModel;
import com.cburch.logisim.data.AbstractAttributeSet;
import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.proj.Project;
import com.cburch.logisim.std.hdl.HdlContent;
import com.cburch.logisim.std.hdl.HdlContentEditor;
import com.cburch.logisim.std.hdl.VhdlContentComponent;
import com.cburch.logisim.std.hdl.VhdlEntityComponent;
import com.cburch.logisim.vhdl.base.VhdlSimConstants;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Window;
import java.util.Arrays;
import java.util.List;
import java.util.WeakHashMap;

public class VhdlEntityAttributes
extends AbstractAttributeSet {
    private static final List<Attribute<?>> attributes = Arrays.asList(VhdlEntityComponent.CONTENT_ATTR, StdAttr.LABEL, StdAttr.LABEL_FONT, StdAttr.LABEL_VISIBILITY, VhdlSimConstants.SIM_NAME_ATTR);
    private static final WeakHashMap<HdlContent, HdlContentEditor> windowRegistry = new WeakHashMap();
    private VhdlContentComponent content;
    private String label = "";
    private Font labelFont = StdAttr.DEFAULT_LABEL_FONT;
    private Boolean labelVisible = false;
    private String simName = "";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HdlContentEditor getContentEditor(Window source, HdlContent value, Project proj) {
        WeakHashMap<HdlContent, HdlContentEditor> weakHashMap = windowRegistry;
        synchronized (weakHashMap) {
            HdlContentEditor ret = windowRegistry.get(value);
            if (ret == null) {
                if (source instanceof Frame) {
                    Frame frame = (Frame)source;
                    ret = new HdlContentEditor(frame, proj, (HdlModel)value);
                } else {
                    ret = new HdlContentEditor((Dialog)source, proj, (HdlModel)value);
                }
                windowRegistry.put(value, ret);
            }
            return ret;
        }
    }

    VhdlEntityAttributes() {
        this.content = VhdlContentComponent.create();
    }

    @Override
    protected void copyInto(AbstractAttributeSet dest) {
        VhdlEntityAttributes attr = (VhdlEntityAttributes)dest;
        attr.labelFont = this.labelFont;
        attr.content = this.content.clone();
    }

    @Override
    public List<Attribute<?>> getAttributes() {
        return attributes;
    }

    @Override
    public <V> V getValue(Attribute<V> attr) {
        if (attr == VhdlEntityComponent.CONTENT_ATTR) {
            return (V)this.content;
        }
        if (attr == StdAttr.LABEL) {
            return (V)this.label;
        }
        if (attr == StdAttr.LABEL_FONT) {
            return (V)this.labelFont;
        }
        if (attr == StdAttr.LABEL_VISIBILITY) {
            return (V)this.labelVisible;
        }
        if (attr == VhdlSimConstants.SIM_NAME_ATTR) {
            return (V)this.simName;
        }
        return null;
    }

    @Override
    public <V> void setValue(Attribute<V> attr, V value) {
        if (attr == VhdlEntityComponent.CONTENT_ATTR) {
            VhdlContentComponent newContent = (VhdlContentComponent)value;
            if (!this.content.equals(newContent)) {
                this.content = newContent;
            }
            this.fireAttributeValueChanged(attr, value, null);
        }
        if (attr == StdAttr.LABEL && value instanceof String) {
            String newLabel = (String)value;
            String oldlabel = this.label;
            if (this.label.equals(newLabel)) {
                return;
            }
            this.label = newLabel;
            this.fireAttributeValueChanged(attr, value, oldlabel);
        }
        if (attr == StdAttr.LABEL_FONT && value instanceof Font) {
            Font newFont = (Font)value;
            if (this.labelFont.equals(newFont)) {
                return;
            }
            this.labelFont = newFont;
            this.fireAttributeValueChanged(attr, value, null);
        }
        if (attr == StdAttr.LABEL_VISIBILITY) {
            Boolean newVis = (Boolean)value;
            if (this.labelVisible.equals(newVis)) {
                return;
            }
            this.labelVisible = newVis;
            this.fireAttributeValueChanged(attr, value, null);
        }
        if (attr == VhdlSimConstants.SIM_NAME_ATTR) {
            String name = (String)value;
            if (value.equals(this.simName)) {
                return;
            }
            this.simName = name;
            this.fireAttributeValueChanged(attr, value, null);
        }
    }

    @Override
    public boolean isToSave(Attribute<?> attr) {
        return attr.isToSave() && attr != VhdlSimConstants.SIM_NAME_ATTR;
    }
}

