/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.hdl;

import com.cburch.hdl.HdlModel;
import com.cburch.hdl.HdlModelListener;
import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.gui.icons.ArithmeticIcon;
import com.cburch.logisim.gui.main.Frame;
import com.cburch.logisim.instance.Instance;
import com.cburch.logisim.instance.InstanceFactory;
import com.cburch.logisim.instance.InstancePainter;
import com.cburch.logisim.instance.InstanceState;
import com.cburch.logisim.instance.Port;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.proj.Project;
import com.cburch.logisim.std.hdl.VhdlContentComponent;
import com.cburch.logisim.std.hdl.VhdlEntityAttributes;
import com.cburch.logisim.std.hdl.VhdlHdlGeneratorFactory;
import com.cburch.logisim.util.GraphicsUtil;
import com.cburch.logisim.util.StringUtil;
import com.cburch.logisim.vhdl.Strings;
import com.cburch.logisim.vhdl.base.VhdlSimConstants;
import com.cburch.logisim.vhdl.sim.VhdlSimulatorTop;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Window;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.WeakHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VhdlEntityComponent
extends InstanceFactory {
    public static final String _ID = "VHDL Entity";
    static final Logger logger = LoggerFactory.getLogger(VhdlEntityComponent.class);
    public static final Attribute<VhdlContentComponent> CONTENT_ATTR = new ContentAttribute();
    static final int WIDTH = 140;
    static final int HEIGHT = 40;
    static final int PORT_GAP = 10;
    static final int X_PADDING = 5;
    private final WeakHashMap<Instance, VhdlEntityListener> contentListeners = new WeakHashMap();

    public VhdlEntityComponent() {
        super(_ID, Strings.S.getter("vhdlComponent"), new VhdlHdlGeneratorFactory(), true);
        this.setIcon(new ArithmeticIcon("VHDL"));
    }

    public void setSimName(AttributeSet attrs, String SName) {
        String label;
        if (attrs == null) {
            return;
        }
        VhdlEntityAttributes atrs = (VhdlEntityAttributes)attrs;
        String string = label = !attrs.getValue(StdAttr.LABEL).equals("") ? this.getHDLTopName(attrs) : SName;
        if (atrs.containsAttribute(VhdlSimConstants.SIM_NAME_ATTR)) {
            atrs.setValue(VhdlSimConstants.SIM_NAME_ATTR, label);
        }
    }

    public String getSimName(AttributeSet attrs) {
        if (attrs == null) {
            return null;
        }
        VhdlEntityAttributes atrs = (VhdlEntityAttributes)attrs;
        return atrs.getValue(VhdlSimConstants.SIM_NAME_ATTR);
    }

    @Override
    protected void configureNewInstance(Instance instance) {
        VhdlContentComponent content = instance.getAttributeValue(CONTENT_ATTR);
        VhdlEntityListener listener = new VhdlEntityListener(instance);
        this.contentListeners.put(instance, listener);
        content.addHdlModelListener(listener);
        instance.addAttributeListener();
        this.updatePorts(instance);
    }

    @Override
    public AttributeSet createAttributeSet() {
        return new VhdlEntityAttributes();
    }

    @Override
    public String getHDLName(AttributeSet attrs) {
        return attrs.getValue(CONTENT_ATTR).getName().toLowerCase();
    }

    @Override
    public String getHDLTopName(AttributeSet attrs) {
        Object label = "";
        if (!attrs.getValue(StdAttr.LABEL).equals("")) {
            label = "_" + attrs.getValue(StdAttr.LABEL).toLowerCase();
        }
        return this.getHDLName(attrs) + (String)label;
    }

    @Override
    public Bounds getOffsetBounds(AttributeSet attrs) {
        VhdlContentComponent content = attrs.getValue(CONTENT_ATTR);
        int nbInputs = content.getInputsNumber();
        int nbOutputs = content.getOutputsNumber();
        return Bounds.create(0, 0, 140, Math.max(nbInputs, nbOutputs) * 10 + 40);
    }

    @Override
    protected void instanceAttributeChanged(Instance instance, Attribute<?> attr) {
        if (attr == CONTENT_ATTR) {
            this.updatePorts(instance);
            instance.recomputeBounds();
        }
    }

    @Override
    public void paintInstance(InstancePainter painter) {
        int i;
        Graphics g = painter.getGraphics();
        VhdlContentComponent content = painter.getAttributeValue(CONTENT_ATTR);
        FontMetrics metric = g.getFontMetrics();
        Bounds bds = painter.getBounds();
        int x0 = bds.getX() + bds.getWidth() / 2;
        int y0 = bds.getY() + metric.getHeight() + 12;
        GraphicsUtil.drawText(g, StringUtil.resizeString(content.getName(), metric, 140), x0, y0, 0, 2);
        String glbLabel = painter.getAttributeValue(StdAttr.LABEL);
        if (glbLabel != null) {
            Font font = g.getFont();
            g.setFont(painter.getAttributeValue(StdAttr.LABEL_FONT));
            GraphicsUtil.drawCenteredText(g, glbLabel, bds.getX() + bds.getWidth() / 2, bds.getY() - g.getFont().getSize());
            g.setFont(font);
        }
        g.setColor(Color.GRAY);
        g.setFont(g.getFont().deriveFont(10.0f));
        metric = g.getFontMetrics();
        Port[] inputs = content.getInputs();
        Port[] outputs = content.getOutputs();
        for (i = 0; i < inputs.length; ++i) {
            GraphicsUtil.drawText(g, StringUtil.resizeString(inputs[i].getToolTip(), metric, 65), bds.getX() + 5, bds.getY() + 40 - 2 + i * 10, -1, 0);
        }
        for (i = 0; i < outputs.length; ++i) {
            GraphicsUtil.drawText(g, StringUtil.resizeString(outputs[i].getToolTip(), metric, 65), bds.getX() + 140 - 5, bds.getY() + 40 - 2 + i * 10, 1, 0);
        }
        painter.drawBounds();
        painter.drawPorts();
    }

    @Override
    public void propagate(InstanceState state) {
        if (state.getProject().getVhdlSimulator().isEnabled() && state.getProject().getVhdlSimulator().isRunning()) {
            String server_response;
            VhdlSimulatorTop vhdlSimulator = state.getProject().getVhdlSimulator();
            for (Port p : state.getInstance().getPorts()) {
                int index = state.getPortIndex(p);
                Value val = state.getPortValue(index);
                String vhdlEntityName = this.getSimName(state.getAttributeSet());
                String message = p.getType() + ":" + vhdlEntityName + "_" + p.getToolTip() + ":" + val.toBinaryString() + ":" + index;
                vhdlSimulator.send(message);
            }
            vhdlSimulator.send("sync");
            while ((server_response = vhdlSimulator.receive()) != null && server_response.length() > 0 && !server_response.equals("sync")) {
                String[] parameters = server_response.split(":");
                String busValue = parameters[1];
                Value[] vector_values = new Value[busValue.length()];
                int k = busValue.length() - 1;
                for (char bit : busValue.toCharArray()) {
                    try {
                        switch (Character.getNumericValue(bit)) {
                            case 0: {
                                vector_values[k] = Value.FALSE;
                                break;
                            }
                            case 1: {
                                vector_values[k] = Value.TRUE;
                                break;
                            }
                            default: {
                                vector_values[k] = Value.UNKNOWN;
                                break;
                            }
                        }
                    }
                    catch (NumberFormatException e) {
                        vector_values[k] = Value.UNKNOWN;
                    }
                    --k;
                }
                state.setPort(Integer.parseInt(parameters[2]), Value.create(vector_values), 1);
            }
        } else {
            for (Port p : state.getInstance().getPorts()) {
                int index = state.getPortIndex(p);
                if (p.getType() != 2) continue;
                Value[] vector_values = new Value[p.getFixedBitWidth().getWidth()];
                for (int k = 0; k < p.getFixedBitWidth().getWidth(); ++k) {
                    vector_values[k] = Value.UNKNOWN;
                }
                state.setPort(index, Value.create(vector_values), 1);
            }
            throw new UnsupportedOperationException("VHDL component simulation is not supported. This could be because there is no Questasim/Modelsim simulation server running.");
        }
    }

    public void saveFile(AttributeSet attrs) {
        try {
            PrintWriter writer = new PrintWriter(VhdlSimConstants.SIM_SRC_PATH + this.getSimName(attrs) + ".vhdl", StandardCharsets.UTF_8);
            String content = attrs.getValue(CONTENT_ATTR).getContent().replaceAll("(?i)" + this.getHDLName(attrs), this.getSimName(attrs));
            writer.print(content);
            writer.close();
        }
        catch (IOException e) {
            logger.error("Could not create vhdl file: {}", (Object)e.getMessage());
            e.printStackTrace();
        }
    }

    void updatePorts(Instance instance) {
        VhdlContentComponent content = instance.getAttributeValue(CONTENT_ATTR);
        instance.setPorts(content.getPorts());
    }

    static class VhdlEntityListener
    implements HdlModelListener {
        final Instance instance;

        VhdlEntityListener(Instance instance) {
            this.instance = instance;
        }

        @Override
        public void contentSet(HdlModel source) {
            this.instance.fireInvalidated();
            this.instance.recomputeBounds();
        }
    }

    static class ContentAttribute
    extends Attribute<VhdlContentComponent> {
        public ContentAttribute() {
            super("content", Strings.S.getter("vhdlContentAttr"));
        }

        @Override
        public Component getCellEditor(Window source, VhdlContentComponent value) {
            Project project;
            if (source instanceof Frame) {
                Frame frame = (Frame)source;
                project = frame.getProject();
            } else {
                project = null;
            }
            Project proj = project;
            return VhdlEntityAttributes.getContentEditor(source, value, proj);
        }

        @Override
        public VhdlContentComponent parse(String value) {
            VhdlContentComponent content = VhdlContentComponent.create();
            if (!content.compare(value)) {
                content.setContent(value);
            }
            return content;
        }

        @Override
        public String toDisplayString(VhdlContentComponent value) {
            return Strings.S.get("vhdlContentValue");
        }

        @Override
        public String toStandardString(VhdlContentComponent value) {
            return value.getContent();
        }
    }
}

