/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.hdl;

import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.fpga.designrulecheck.Netlist;
import com.cburch.logisim.fpga.file.FileWriter;
import com.cburch.logisim.fpga.hdlgenerator.AbstractHdlGeneratorFactory;
import com.cburch.logisim.fpga.hdlgenerator.Hdl;
import com.cburch.logisim.instance.Port;
import com.cburch.logisim.std.hdl.VhdlContentComponent;
import com.cburch.logisim.std.hdl.VhdlEntityComponent;
import java.util.ArrayList;

public class VhdlHdlGeneratorFactory
extends AbstractHdlGeneratorFactory {
    public static final String HDL_DIRECTORY = "circuit";

    public VhdlHdlGeneratorFactory() {
        super(HDL_DIRECTORY);
        this.getWiresPortsDuringHDLWriting = true;
    }

    @Override
    public void getGenerationTimeWiresPorts(Netlist theNetlist, AttributeSet attrs) {
        VhdlContentComponent contents = attrs.getValue(VhdlEntityComponent.CONTENT_ATTR);
        Port[] inputs = contents.getInputs();
        Port[] outputs = contents.getOutputs();
        int portId = 0;
        for (Port input : inputs) {
            this.myPorts.add("input", input.getToolTip(), input.getFixedBitWidth().getWidth(), portId++);
        }
        for (Port output : outputs) {
            this.myPorts.add("output", output.getToolTip(), output.getFixedBitWidth().getWidth(), portId++);
        }
    }

    public ArrayList<String> getArchitecture(Netlist theNetlist, AttributeSet attrs, String componentName) {
        ArrayList<String> contents = new ArrayList<String>(FileWriter.getGenerateRemark(componentName, theNetlist.projName()));
        VhdlContentComponent content = attrs.getValue(VhdlEntityComponent.CONTENT_ATTR);
        contents.add(content.getLibraries());
        contents.add(content.getArchitecture());
        return contents;
    }

    @Override
    public boolean isHdlSupportedTarget(AttributeSet attrs) {
        return Hdl.isVhdl();
    }
}

