/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.io;

import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.AttributeOption;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.data.Attributes;
import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Direction;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.fpga.data.ComponentMapInformationContainer;
import com.cburch.logisim.fpga.hdlgenerator.HdlGeneratorFactory;
import com.cburch.logisim.gui.icons.LedMatrixIcon;
import com.cburch.logisim.instance.Instance;
import com.cburch.logisim.instance.InstanceData;
import com.cburch.logisim.instance.InstanceFactory;
import com.cburch.logisim.instance.InstancePainter;
import com.cburch.logisim.instance.InstanceState;
import com.cburch.logisim.instance.Port;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.std.Strings;
import com.cburch.logisim.std.io.IoLibrary;
import com.cburch.logisim.std.wiring.DurationAttribute;
import com.cburch.logisim.util.GraphicsUtil;
import com.cburch.logisim.util.StringGetter;
import java.awt.Color;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public abstract class DotMatrixBase
extends InstanceFactory {
    protected static final AttributeOption INPUT_SELECT = new AttributeOption("select", Strings.S.getter("ioInputSelect"));
    protected static final AttributeOption INPUT_COLUMN = new AttributeOption("column", Strings.S.getter("ioInputColumn"));
    protected static final AttributeOption INPUT_ROW = new AttributeOption("row", Strings.S.getter("ioInputRow"));
    protected static final AttributeOption SHAPE_CIRCLE = new AttributeOption("circle", Strings.S.getter("ioShapeCircle"));
    protected static final AttributeOption SHAPE_SQUARE = new AttributeOption("square", Strings.S.getter("ioShapeSquare"));
    protected static final AttributeOption SHAPE_PADDED_SQUARE = new AttributeOption("clusterSegment", Strings.S.getter("ioShapePaddedSquare"));
    protected static final Attribute<AttributeOption> ATTR_INPUT_TYPE = Attributes.forOption("inputtype", Strings.S.getter("ioMatrixInput"), new AttributeOption[]{INPUT_COLUMN, INPUT_ROW, INPUT_SELECT});
    protected static final Attribute<AttributeOption> ATTR_DOT_SHAPE = Attributes.forOption("dotshape", Strings.S.getter("ioMatrixShape"), new AttributeOption[]{SHAPE_CIRCLE, SHAPE_SQUARE, SHAPE_PADDED_SQUARE});
    protected static final Attribute<Integer> ATTR_PERSIST = new DurationAttribute("persist", Strings.S.getter("ioMatrixPersistenceAttr"), 0, Integer.MAX_VALUE, true);
    protected boolean drawBorder = true;
    protected int scaleX = 1;
    protected int scaleY = 1;

    protected static List<String> getLabels(int rows, int cols) {
        ArrayList<String> result = new ArrayList<String>();
        for (int r = 0; r < rows; ++r) {
            for (int c = 0; c < cols; ++c) {
                result.add("Row" + r + "Col" + c);
            }
        }
        return result;
    }

    public void setDrawBorder(boolean val) {
        this.drawBorder = val;
    }

    public void setScaleX(int val) {
        this.scaleX = val;
    }

    public void setScaleY(int val) {
        this.scaleY = val;
    }

    public DotMatrixBase(String name, StringGetter displayName, int cols, int rows, HdlGeneratorFactory generator) {
        super(name, displayName, generator, true);
        this.setAttributes(new Attribute[]{this.getAttributeInputType(), this.getAttributeColumns(), this.getAttributeRows(), StdAttr.SELECT_LOC, IoLibrary.ATTR_ON_COLOR, IoLibrary.ATTR_OFF_COLOR, ATTR_PERSIST, this.getAttributeShape(), StdAttr.LABEL, StdAttr.LABEL_LOC, StdAttr.LABEL_FONT, StdAttr.LABEL_COLOR, StdAttr.LABEL_VISIBILITY, StdAttr.MAPINFO}, new Object[]{this.getAttributeItemColumn(), BitWidth.create(cols), BitWidth.create(rows), StdAttr.SELECT_BOTTOM_LEFT, Color.GREEN, Color.gray, 0, this.getDefaultShape(), "", Direction.NORTH, StdAttr.DEFAULT_LABEL_FONT, StdAttr.DEFAULT_LABEL_COLOR, true, new ComponentMapInformationContainer(0, cols * rows, 0, null, DotMatrixBase.getLabels(rows, cols), null)});
        this.setIcon(new LedMatrixIcon());
    }

    public abstract Attribute<BitWidth> getAttributeRows();

    public abstract Attribute<BitWidth> getAttributeColumns();

    public abstract Attribute<AttributeOption> getAttributeShape();

    public abstract AttributeOption getDefaultShape();

    public abstract Attribute<AttributeOption> getAttributeInputType();

    public abstract AttributeOption getAttributeItemColumn();

    public abstract AttributeOption getAttributeItemRow();

    public abstract AttributeOption getAttributeItemSelect();

    @Override
    protected void configureNewInstance(Instance instance) {
        instance.computeLabelTextField(8);
        instance.addAttributeListener();
        this.updatePorts(instance);
        int rows = instance.getAttributeValue(this.getAttributeRows()).getWidth();
        int cols = instance.getAttributeValue(this.getAttributeColumns()).getWidth();
        instance.getAttributeSet().setValue(StdAttr.MAPINFO, new ComponentMapInformationContainer(0, rows * cols, 0, null, DotMatrixBase.getLabels(rows, cols), null));
    }

    @Override
    public Bounds getOffsetBounds(AttributeSet attrs) {
        AttributeOption input = attrs.getValue(this.getAttributeInputType());
        int cols = attrs.getValue(this.getAttributeColumns()).getWidth();
        int rows = attrs.getValue(this.getAttributeRows()).getWidth();
        if (input.equals(this.getAttributeItemColumn())) {
            return Bounds.create(-5 * this.scaleX, -10 * this.scaleY * rows, 10 * this.scaleX * cols, 10 * this.scaleY * rows);
        }
        if (input.equals(this.getAttributeItemRow())) {
            return Bounds.create(0, -5 * this.scaleY, 10 * this.scaleX * cols, 10 * this.scaleY * rows);
        }
        if (rows == 1) {
            return Bounds.create(0, -5 * this.scaleY, 10 * this.scaleX * cols, 10 * this.scaleY * rows);
        }
        return Bounds.create(0, -5 * this.scaleY * rows + 5, 10 * this.scaleX * cols, 10 * this.scaleY * rows);
    }

    protected State getState(InstanceState state) {
        int rows = state.getAttributeValue(this.getAttributeRows()).getWidth();
        int cols = state.getAttributeValue(this.getAttributeColumns()).getWidth();
        int clock = state.getTickCount();
        State data = (State)state.getData();
        if (data == null) {
            data = new State(rows, cols, clock);
            state.setData(data);
        } else {
            data.updateSize(rows, cols, clock);
        }
        return data;
    }

    @Override
    protected void instanceAttributeChanged(Instance instance, Attribute<?> attr) {
        if (attr == StdAttr.LABEL_LOC) {
            instance.computeLabelTextField(8);
        } else if (attr == StdAttr.SELECT_LOC) {
            this.updatePorts(instance);
        } else if (attr == this.getAttributeRows() || attr == this.getAttributeColumns() || attr == this.getAttributeInputType()) {
            instance.recomputeBounds();
            instance.computeLabelTextField(8);
            this.updatePorts(instance);
            if (attr == this.getAttributeRows() || attr == this.getAttributeColumns()) {
                int rows = instance.getAttributeValue(this.getAttributeRows()).getWidth();
                int cols = instance.getAttributeValue(this.getAttributeColumns()).getWidth();
                ComponentMapInformationContainer cm = instance.getAttributeValue(StdAttr.MAPINFO);
                cm.setNrOfOutports(rows * cols, DotMatrixBase.getLabels(rows, cols));
            }
        }
    }

    protected void drawCircle(Graphics g, int x, int y) {
        g.fillOval((x + 1) * this.scaleX, (y + 1) * this.scaleY, 8 * this.scaleX, 8 * this.scaleY);
    }

    protected void drawSquare(Graphics g, int x, int y) {
        g.fillRect(x, y, 10 * this.scaleX, 10 * this.scaleY);
    }

    protected void drawPaddedSquare(Graphics g, int x, int y) {
        int paddingY = 2;
        int paddingX = 2;
        g.fillRect(x + 2 * this.scaleX, y + 2 * this.scaleY, 6 * this.scaleX, 6 * this.scaleY);
    }

    @Override
    public void paintInstance(InstancePainter painter) {
        Color onColor = painter.getAttributeValue(IoLibrary.ATTR_ON_COLOR);
        Color offColor = painter.getAttributeValue(IoLibrary.ATTR_OFF_COLOR);
        AttributeOption shape = painter.getAttributeValue(this.getAttributeShape());
        State data = this.getState(painter);
        int ticks = painter.getTickCount();
        Bounds bounds = painter.getBounds();
        boolean showState = painter.getShowState();
        Graphics g = painter.getGraphics();
        int rows = data.rows;
        int cols = data.cols;
        painter.drawPorts();
        g.setColor(Color.DARK_GRAY);
        g.fillRect(bounds.getX(), bounds.getY(), cols * 10 * this.scaleX, rows * 10 * this.scaleY);
        for (int j = 0; j < rows; ++j) {
            for (int i = 0; i < cols; ++i) {
                int x = bounds.getX() + 10 * i * this.scaleX;
                int y = bounds.getY() + 10 * j * this.scaleY;
                if (!showState) {
                    g.setColor(Color.GRAY);
                    this.drawCircle(g, x, y);
                    continue;
                }
                Value val = data.get(j, i, ticks);
                Color c = val == Value.TRUE ? onColor : (val == Value.FALSE ? offColor : Value.errorColor);
                g.setColor(c);
                if (SHAPE_SQUARE.equals(shape)) {
                    this.drawSquare(g, x, y);
                    continue;
                }
                if (SHAPE_PADDED_SQUARE.equals(shape)) {
                    this.drawPaddedSquare(g, x, y);
                    continue;
                }
                this.drawCircle(g, x, y);
            }
        }
        if (this.drawBorder) {
            g.setColor(Color.DARK_GRAY);
            GraphicsUtil.switchToWidth(g, 2);
            g.drawRect(bounds.getX(), bounds.getY(), bounds.getWidth(), bounds.getHeight());
            GraphicsUtil.switchToWidth(g, 1);
        }
        painter.drawLabel();
    }

    @Override
    public void propagate(InstanceState state) {
        AttributeOption type = state.getAttributeValue(this.getAttributeInputType());
        int rows = state.getAttributeValue(this.getAttributeRows()).getWidth();
        int cols = state.getAttributeValue(this.getAttributeColumns()).getWidth();
        long clock = state.getTickCount();
        long persist = clock + (long)state.getAttributeValue(ATTR_PERSIST).intValue();
        State data = this.getState(state);
        if (this.getAttributeItemRow().equals(type)) {
            for (int i = 0; i < rows; ++i) {
                data.setRow(i, state.getPortValue(i), persist);
            }
        } else if (this.getAttributeItemColumn().equals(type)) {
            for (int i = 0; i < cols; ++i) {
                data.setColumn(i, state.getPortValue(i), persist);
            }
        } else if (this.getAttributeItemSelect().equals(type)) {
            data.setSelect(state.getPortValue(1), state.getPortValue(0), persist);
        } else {
            throw new RuntimeException("Unexpected matrix type: " + type);
        }
    }

    protected void updatePorts(Instance instance) {
        Port[] ps;
        AttributeOption input = instance.getAttributeValue(this.getAttributeInputType());
        int rows = instance.getAttributeValue(this.getAttributeRows()).getWidth();
        int cols = instance.getAttributeValue(this.getAttributeColumns()).getWidth();
        AttributeOption selectLoc = instance.getAttributeValue(StdAttr.SELECT_LOC);
        if (input == this.getAttributeItemColumn()) {
            ps = new Port[cols];
            for (int i = 0; i < cols; ++i) {
                ps[i] = new Port(10 * i, selectLoc == StdAttr.SELECT_BOTTOM_LEFT ? 0 : rows * -10 * this.scaleY, "input", rows);
            }
        } else if (input == this.getAttributeItemRow()) {
            ps = new Port[rows];
            for (int i = 0; i < rows; ++i) {
                ps[i] = new Port(selectLoc == StdAttr.SELECT_BOTTOM_LEFT ? 0 : cols * 10, 10 * i, "input", cols);
            }
        } else if (rows <= 1) {
            ps = new Port[]{new Port(0, 0, "input", cols), new Port(10 * cols, 0, "input", rows)};
        } else {
            int dx = selectLoc == StdAttr.SELECT_BOTTOM_LEFT ? 0 : cols * 10;
            ps = new Port[]{new Port(dx, 0, "input", cols), new Port(dx, 10, "input", rows)};
        }
        instance.setPorts(ps);
    }

    protected static class State
    implements InstanceData,
    Cloneable {
        protected int rows = -1;
        protected int cols = -1;
        protected Value[] grid;
        protected long[] persistTo;

        public State(int rows, int cols, long curClock) {
            this.updateSize(rows, cols, curClock);
        }

        @Override
        public Object clone() {
            try {
                State ret = (State)super.clone();
                ret.grid = (Value[])this.grid.clone();
                ret.persistTo = (long[])this.persistTo.clone();
                return ret;
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
        }

        protected Value get(int row, int col, long curTick) {
            int index = row * this.cols + col;
            Value ret = this.grid[index];
            if (ret == Value.FALSE && this.persistTo[index] - curTick >= 0L) {
                ret = Value.TRUE;
            }
            return ret;
        }

        protected void setColumn(int index, Value colVector, long persist) {
            int gridloc = (this.rows - 1) * this.cols + index;
            int stride = -this.cols;
            Value[] vals = colVector.getAll();
            int i = 0;
            while (i < vals.length) {
                Value val = vals[i];
                if (this.grid[gridloc] == Value.TRUE) {
                    this.persistTo[gridloc] = persist - 1L;
                }
                this.grid[gridloc] = val;
                if (val == Value.TRUE) {
                    this.persistTo[gridloc] = persist;
                }
                ++i;
                gridloc += stride;
            }
        }

        protected void setRow(int index, Value rowVector, long persist) {
            int gridloc = (index + 1) * this.cols - 1;
            int stride = -1;
            Value[] vals = rowVector.getAll();
            int i = 0;
            while (i < vals.length) {
                Value val = vals[i];
                if (this.grid[gridloc] == Value.TRUE) {
                    this.persistTo[gridloc] = persist - 1L;
                }
                this.grid[gridloc] = vals[i];
                if (val == Value.TRUE) {
                    this.persistTo[gridloc] = persist;
                }
                ++i;
                --gridloc;
            }
        }

        protected void setSelect(Value rowVector, Value colVector, long persist) {
            Value[] rowVals = rowVector.getAll();
            Value[] colVals = colVector.getAll();
            int gridloc = 0;
            for (int i = rowVals.length - 1; i >= 0; --i) {
                int j;
                Value wholeRow = rowVals[i];
                if (wholeRow == Value.TRUE) {
                    j = colVals.length - 1;
                    while (j >= 0) {
                        Value val = colVals[colVals.length - 1 - j];
                        if (this.grid[gridloc] == Value.TRUE) {
                            this.persistTo[gridloc] = persist - 1L;
                        }
                        this.grid[gridloc] = val;
                        if (val == Value.TRUE) {
                            this.persistTo[gridloc] = persist;
                        }
                        --j;
                        ++gridloc;
                    }
                    continue;
                }
                if (wholeRow != Value.FALSE) {
                    wholeRow = Value.ERROR;
                }
                j = colVals.length - 1;
                while (j >= 0) {
                    if (this.grid[gridloc] == Value.TRUE) {
                        this.persistTo[gridloc] = persist - 1L;
                    }
                    this.grid[gridloc] = wholeRow;
                    --j;
                    ++gridloc;
                }
            }
        }

        protected void updateSize(int rows, int cols, long curClock) {
            if (this.rows != rows || this.cols != cols) {
                this.rows = rows;
                this.cols = cols;
                int length = rows * cols;
                this.grid = new Value[length];
                this.persistTo = new long[length];
                Arrays.fill(this.grid, Value.UNKNOWN);
                Arrays.fill(this.persistTo, curClock - 1L);
            }
        }
    }
}

