/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.io;

import com.cburch.logisim.data.Value;
import com.cburch.logisim.instance.InstanceData;
import java.awt.FontMetrics;

class KeyboardData
implements InstanceData,
Cloneable {
    private Value lastClock = Value.UNKNOWN;
    private char[] buffer;
    private String str;
    private int bufferLength;
    private int cursorPos;
    private boolean dispValid;
    private int dispStart;
    private int dispEnd;

    public KeyboardData(int capacity) {
        this.buffer = new char[capacity];
        this.clear();
    }

    public void clear() {
        this.bufferLength = 0;
        this.cursorPos = 0;
        this.str = "";
        this.dispValid = false;
        this.dispStart = 0;
        this.dispEnd = 0;
    }

    @Override
    public Object clone() {
        try {
            KeyboardData ret = (KeyboardData)super.clone();
            ret.buffer = (char[])this.buffer.clone();
            return ret;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public boolean delete() {
        char[] buf = this.buffer;
        int pos = this.cursorPos;
        int len = this.bufferLength;
        if (pos >= len) {
            return false;
        }
        if (len >= pos + 1) {
            System.arraycopy(buf, pos + 1, buf, pos, len - (pos + 1));
        }
        this.bufferLength = len - 1;
        this.str = null;
        this.dispValid = false;
        return true;
    }

    public char dequeue() {
        char[] buf = this.buffer;
        int len = this.bufferLength;
        if (len == 0) {
            return '\u0000';
        }
        char ret = buf[0];
        if (len >= 1) {
            System.arraycopy(buf, 1, buf, 0, len - 1);
        }
        this.bufferLength = len - 1;
        int pos = this.cursorPos;
        if (pos > 0) {
            this.cursorPos = pos - 1;
        }
        this.str = null;
        this.dispValid = false;
        return ret;
    }

    private boolean fits(FontMetrics fm, String str, int w0, int w1, int i0, int i1, int max) {
        if (i0 >= i1) {
            return true;
        }
        int len = str.length();
        if (i0 < 0 || i1 > len) {
            return false;
        }
        int w = fm.stringWidth(str.substring(i0, i1));
        if (i0 > 0) {
            w += w0;
        }
        if (i1 < str.length()) {
            w += w1;
        }
        return w <= max;
    }

    public char getChar(int pos) {
        return pos >= 0 && pos < this.bufferLength ? this.buffer[pos] : (char)'\u0000';
    }

    public int getCursorPosition() {
        return this.cursorPos;
    }

    public int getDisplayEnd() {
        return this.dispEnd;
    }

    public int getDisplayStart() {
        return this.dispStart;
    }

    public int getNextSpecial(int pos) {
        char[] buf = this.buffer;
        int len = this.bufferLength;
        for (int i = pos; i < len; ++i) {
            char c = buf[i];
            if (!Character.isISOControl(c)) continue;
            return i;
        }
        return -1;
    }

    public boolean insert(char value) {
        int len = this.bufferLength;
        char[] buf = this.buffer;
        if (len >= buf.length) {
            return false;
        }
        int pos = this.cursorPos;
        if (len >= pos) {
            System.arraycopy(buf, pos, buf, pos + 1, len - pos);
        }
        buf[pos] = value;
        this.bufferLength = len + 1;
        this.cursorPos = pos + 1;
        this.str = null;
        this.dispValid = false;
        return true;
    }

    public boolean isDisplayValid() {
        return this.dispValid;
    }

    public boolean moveCursorBy(int delta) {
        int len = this.bufferLength;
        int pos = this.cursorPos;
        int newPos = pos + delta;
        if (newPos < 0 || newPos > len) {
            return false;
        }
        this.cursorPos = newPos;
        this.dispValid = false;
        return true;
    }

    public boolean setCursor(int value) {
        int pos;
        int len = this.bufferLength;
        if (value > len) {
            value = len;
        }
        if ((pos = this.cursorPos) == value) {
            return false;
        }
        this.cursorPos = value;
        this.dispValid = false;
        return true;
    }

    public Value setLastClock(Value newClock) {
        Value ret = this.lastClock;
        this.lastClock = newClock;
        return ret;
    }

    public String toString() {
        String s = this.str;
        if (s != null) {
            return s;
        }
        StringBuilder build = new StringBuilder();
        char[] buf = this.buffer;
        int len = this.bufferLength;
        for (int i = 0; i < len; ++i) {
            char c = buf[i];
            build.append(Character.isISOControl(c) ? (char)' ' : c);
        }
        this.str = build.toString();
        return this.str;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateBufferLength(int len) {
        KeyboardData keyboardData = this;
        synchronized (keyboardData) {
            char[] buf = this.buffer;
            int oldLen = buf.length;
            if (oldLen != len) {
                char[] newBuf = new char[len];
                System.arraycopy(buf, 0, newBuf, 0, Math.min(len, oldLen));
                if (len < oldLen) {
                    if (this.bufferLength > len) {
                        this.bufferLength = len;
                    }
                    if (this.cursorPos > len) {
                        this.cursorPos = len;
                    }
                }
                this.buffer = newBuf;
                this.str = null;
                this.dispValid = false;
            }
        }
    }

    public void updateDisplay(FontMetrics fm) {
        if (this.dispValid) {
            return;
        }
        int pos = this.cursorPos;
        int i0 = this.dispStart;
        int i1 = this.dispEnd;
        String str = this.toString();
        int len = str.length();
        int max = 133;
        if (str.equals("") || fm.stringWidth(str) <= 133) {
            i0 = 0;
            i1 = len;
        } else {
            int w;
            int w0 = fm.stringWidth(str.charAt(0) + "m");
            int w1 = fm.stringWidth("m");
            int n = w = i0 == 0 ? fm.stringWidth(str) : w0 + fm.stringWidth(str.substring(i0));
            if (w <= 133) {
                i1 = len;
            }
            if (pos <= i0) {
                if (pos < i0) {
                    i1 += pos - i0;
                    i0 = pos;
                }
                if (pos == i0 && i0 > 0) {
                    --i0;
                    --i1;
                }
            }
            if (pos >= i1) {
                if (pos > i1) {
                    i0 += pos - i1;
                    i1 = pos;
                }
                if (pos == i1 && i1 < len) {
                    ++i0;
                    ++i1;
                }
            }
            if (i0 <= 2) {
                i0 = 0;
            }
            if (this.fits(fm, str, w0, w1, i0, i1, 133)) {
                while (this.fits(fm, str, w0, w1, i0, i1 + 1, 133)) {
                    ++i1;
                }
                while (this.fits(fm, str, w0, w1, i0 - 1, i1, 133)) {
                    --i0;
                }
            } else if (pos < (i0 + i1) / 2) {
                --i1;
                while (!this.fits(fm, str, w0, w1, i0, i1, 133)) {
                    --i1;
                }
            } else {
                ++i0;
                while (!this.fits(fm, str, w0, w1, i0, i1, 133)) {
                    ++i0;
                }
            }
            if (i0 == 1) {
                i0 = 0;
            }
        }
        this.dispStart = i0;
        this.dispEnd = i1;
        this.dispValid = true;
    }
}

