/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.io;

import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.fpga.designrulecheck.Netlist;
import com.cburch.logisim.fpga.hdlgenerator.AbstractHdlGeneratorFactory;
import com.cburch.logisim.fpga.hdlgenerator.Hdl;
import com.cburch.logisim.std.io.LedArrayGenericHdlGeneratorFactory;
import com.cburch.logisim.util.LineBuffer;
import java.util.HashMap;
import java.util.List;

public class LedArrayRowScanningHdlGeneratorFactory
extends AbstractHdlGeneratorFactory {
    public static final int NR_OF_LEDS_ID = -1;
    public static final int NR_OF_ROWS_ID = -2;
    public static final int NR_OF_COLUMS_ID = -3;
    public static final int NR_OF_ROW_ADDRESS_BITS_ID = -4;
    public static final int ACTIVE_LOW_ID = -5;
    public static final int SCANNING_COUNTER_BITS_ID = -6;
    public static final int MAX_NR_LEDS_ID = -7;
    public static final int SCANNING_COUNTER_VALUE_ID = -8;
    public static final String NR_OF_ROWS_STRING = "nrOfRows";
    public static final String NR_OF_COLUMS_STRING = "nrOfColumns";
    public static final String NR_OF_LEDS_STRING = "nrOfLeds";
    public static final String NR_OF_ROW_ADDRESS_BITS_STRING = "nrOfRowAddressBits";
    public static final String ACTIVE_LOW_STRING = "activeLow";
    public static final String SCANNING_COUNTER_BITS_STRING = "nrOfScanningCounterBits";
    public static final String SCANNING_COUNTER_VALUE_STRING = "scanningCounterReloadValue";
    public static final String MAX_NR_LEDS_STRING = "maxNrLedsAddrColumns";
    public static final String HDL_IDENTIFIER = "LedArrayRowScanning";

    public LedArrayRowScanningHdlGeneratorFactory() {
        this.myParametersList.add(ACTIVE_LOW_STRING, -5).add(MAX_NR_LEDS_STRING, -7).add(NR_OF_COLUMS_STRING, -3).add(NR_OF_LEDS_STRING, -1).add(NR_OF_ROWS_STRING, -2).add(NR_OF_ROW_ADDRESS_BITS_STRING, -4).add(SCANNING_COUNTER_BITS_STRING, -6).add(SCANNING_COUNTER_VALUE_STRING, -8);
        this.myWires.addWire("s_rowCounterNext", -4).addWire("s_scanningCounterNext", -6).addWire("s_tickNext", 1).addWire("s_maxLedInputs", -7).addRegister("s_rowCounterReg", -4).addRegister("s_scanningCounterReg", -6).addRegister("s_tickReg", 1);
        this.myPorts.add("input", "fpgaGlobalClock", 1, 0).add("input", LedArrayGenericHdlGeneratorFactory.LedArrayInputs, -1, 1).add("output", LedArrayGenericHdlGeneratorFactory.LedArrayRowAddress, -4, 2).add("output", LedArrayGenericHdlGeneratorFactory.LedArrayColumnOutputs, -3, 3);
    }

    public static LineBuffer getGenericMap(int nrOfRows, int nrOfColumns, long FpgaClockFrequency, boolean activeLow) {
        int nrRowAddrBits = LedArrayGenericHdlGeneratorFactory.getNrOfBitsRequired(nrOfRows);
        int scanningReload = (int)(FpgaClockFrequency / 1000L);
        int nrOfScanningBits = LedArrayGenericHdlGeneratorFactory.getNrOfBitsRequired(scanningReload);
        int maxNrLeds = (int)Math.pow(2.0, nrRowAddrBits) * nrOfRows;
        HashMap<String, String> generics = new HashMap<String, String>();
        generics.put(NR_OF_LEDS_STRING, Integer.toString(nrOfRows * nrOfColumns));
        generics.put(NR_OF_ROWS_STRING, Integer.toString(nrOfRows));
        generics.put(NR_OF_COLUMS_STRING, Integer.toString(nrOfColumns));
        generics.put(NR_OF_ROW_ADDRESS_BITS_STRING, Integer.toString(nrRowAddrBits));
        generics.put(SCANNING_COUNTER_BITS_STRING, Integer.toString(nrOfScanningBits));
        generics.put(SCANNING_COUNTER_VALUE_STRING, Integer.toString(scanningReload - 1));
        generics.put(MAX_NR_LEDS_STRING, Integer.toString(maxNrLeds));
        generics.put(ACTIVE_LOW_STRING, activeLow ? "1" : "0");
        return LedArrayGenericHdlGeneratorFactory.getGenericPortMapAlligned(generics, true);
    }

    public static LineBuffer getPortMap(int id) {
        HashMap<String, String> ports = new HashMap<String, String>();
        ports.put(LedArrayGenericHdlGeneratorFactory.LedArrayRowAddress, String.format("%s%d", LedArrayGenericHdlGeneratorFactory.LedArrayRowAddress, id));
        ports.put(LedArrayGenericHdlGeneratorFactory.LedArrayColumnOutputs, String.format("%s%d", LedArrayGenericHdlGeneratorFactory.LedArrayColumnOutputs, id));
        ports.put("fpgaGlobalClock", "fpgaGlobalClock");
        ports.put(LedArrayGenericHdlGeneratorFactory.LedArrayInputs, String.format("s_%s%d", LedArrayGenericHdlGeneratorFactory.LedArrayInputs, id));
        return LedArrayGenericHdlGeneratorFactory.getGenericPortMapAlligned(ports, false);
    }

    public static List<String> getRowCounterCode() {
        LineBuffer contents = LineBuffer.getHdlBuffer().pair("rowAddress", LedArrayGenericHdlGeneratorFactory.LedArrayRowAddress).pair("bits", SCANNING_COUNTER_BITS_STRING).pair("value", SCANNING_COUNTER_VALUE_STRING).pair("clock", "fpgaGlobalClock");
        if (Hdl.isVhdl()) {
            contents.addVhdlKeywords().add("\n{{rowAddress}} <= s_rowCounterReg;\n\ns_tickNext <= '1' {{when}} s_scanningCounterReg = std_logic_vector(to_unsigned(0, {{bits}})) {{else}} '0';\n\ns_scanningCounterNext <= ({{others}} => '0') {{when}} s_tickReg /= '0' {{and}} s_tickReg /= '1' {{else}} -- for simulation\n                         std_logic_vector(to_unsigned({{value}}-1, {{bits}})) {{when}} s_scanningCounterReg = std_logic_vector(to_unsigned(0, {{bits}})) {{else}}\n                         std_logic_vector(unsigned(s_scanningCounterReg)-1);\n\ns_rowCounterNext <= ({{others}} => '0') {{when}} s_tickReg /= '0' {{and}} s_tickReg /= '1' {{else}} -- for simulation\n                    s_rowCounterReg {{when}} s_tickReg = '0' {{else}}\n                    std_logic_vector(to_unsigned(nrOfRows-1,nrOfRowAddressBits))\n                       {{when}} s_rowCounterReg = std_logic_vector(to_unsigned(0,nrOfRowAddressBits)) {{else}}\n                    std_logic_vector(unsigned(s_rowCounterReg)-1);\n\nmakeFlops : {{process}} ({{clock}}) {{is}}\n{{begin}}\n   {{if}} (rising_edge({{clock}})) {{then}}\n      s_rowCounterReg      <= s_rowCounterNext;\n      s_scanningCounterReg <= s_scanningCounterNext;\n      s_tickReg            <= s_tickNext;\n   {{end}} {{if}};\n{{end}} {{process}} makeFlops;\n").empty();
        } else {
            contents.add("\nassign rowAddress = s_rowCounterReg;\n\nassign s_tickNext = (s_scanningCounterReg == 0) ? 1'b1 : 1'b0;\nassign s_scanningCounterNext = (s_scanningCounterReg == 0) ? {{value}} : s_scanningCounterReg - 1;\nassign s_rowCounterNext = (s_tickReg == 1'b0) ? s_rowCounterReg :\n                          (s_rowCounterReg == 0) ? nrOfRows-1 : s_rowCounterReg-1;\n").addRemarkBlock("Here the simulation only initial is defined").add("initial\nbegin\n   s_rowCounterReg      = 0;\n   s_scanningCounterReg = 0;\n   s_tickReg            = 1'b0;\nend\n\nalways @(posedge {{clock}})\nbegin\n    s_rowCounterReg      = s_rowCounterNext;\n    s_scanningCounterReg = s_scanningCounterNext;\n    s_tickReg            = s_tickNext;\nend\n").empty();
        }
        return contents.get();
    }

    @Override
    public LineBuffer getModuleFunctionality(Netlist TheNetlist, AttributeSet attrs) {
        LineBuffer contents = LineBuffer.getHdlBuffer().pair("ins", LedArrayGenericHdlGeneratorFactory.LedArrayInputs).pair("outs", LedArrayGenericHdlGeneratorFactory.LedArrayColumnOutputs).pair(ACTIVE_LOW_STRING, ACTIVE_LOW_STRING).pair(NR_OF_LEDS_STRING, NR_OF_LEDS_STRING).pair(NR_OF_COLUMS_STRING, NR_OF_COLUMS_STRING).add(LedArrayRowScanningHdlGeneratorFactory.getRowCounterCode());
        if (Hdl.isVhdl()) {
            contents.addVhdlKeywords().add("makeVirtualInputs : {{process}} ( internalLeds ) {{is}}\n{{begin}}\n   s_maxLedInputs <= ({{others}} => '0');\n   {{if}} ({{activeLow}} = 1) {{then}}\n      s_maxLedInputs({{nrOfLeds}}-1 {{downto}} 0) <= {{not}} {{ins}};\n   {{else}}\n      s_maxLedInputs({{nrOfLeds}}-1 {{downto}} 0) <= {{ins}};\n   {{end}} {{if}};\n{{end}} {{process}} makeVirtualInputs;\n\ngenOutputs : {{for}} n {{in}} {{nrOfColumns}}-1 {{downto}} 0 {{generate{{\n   {{outs}}(n) <= s_maxLedInputs({{nrOfColumns}} * to_integer(unsigned(s_rowCounterReg)) + n);\n{{end}} {{generate}} genOutputs;\n").empty();
        } else {
            contents.add("genvar i;\ngenerate\n   for (i = 0; i < {{nrOfColumns}}; i = i + 1)\n   begin:outputs\n      assign {{outs}}[i] = (activeLow == 1)\n         ? ~{{ins}}[{{nrOfColumns}} * s_rowCounterReg + i]\n         :  {{ins}}[{{nrOfColumns}} * s_rowCounterReg + i];\n   end\nendgenerate\n").empty();
        }
        return contents;
    }
}

