/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.io;

import com.cburch.logisim.data.AttributeOption;
import com.cburch.logisim.fpga.designrulecheck.Netlist;
import com.cburch.logisim.fpga.designrulecheck.netlistComponent;
import com.cburch.logisim.fpga.hdlgenerator.Hdl;
import com.cburch.logisim.fpga.hdlgenerator.InlinedHdlGeneratorFactory;
import com.cburch.logisim.std.io.PortIo;
import com.cburch.logisim.util.LineBuffer;

public class PortHdlGeneratorFactory
extends InlinedHdlGeneratorFactory {
    @Override
    public LineBuffer getInlinedCode(Netlist nets, Long componentId, netlistComponent componentInfo, String circuitName) {
        LineBuffer contents = LineBuffer.getHdlBuffer();
        AttributeOption portType = componentInfo.getComponent().getAttributeSet().getValue(PortIo.ATTR_DIR);
        int nrOfPins = componentInfo.getComponent().getAttributeSet().getValue(PortIo.ATTR_SIZE).getWidth();
        if (portType == PortIo.INPUT) {
            int busIndex = 0;
            while (nrOfPins > 0) {
                int startIndex = componentInfo.getLocalBubbleInputStartId() + busIndex * 64;
                int nrOfBitsInThisBus = Math.min(nrOfPins, 64);
                nrOfPins -= nrOfBitsInThisBus;
                int endIndex = startIndex + nrOfBitsInThisBus - 1;
                contents.add("{{assign}} {{1}}{{=}}{{2}}{{<}}{{3}}{{4}}{{5}}{{>}};", Hdl.getBusName(componentInfo, busIndex, nets), "logisimInputBubbles", endIndex, Hdl.vectorLoopId(), startIndex);
                ++busIndex;
            }
        } else if (portType == PortIo.OUTPUT) {
            int busIndex = 0;
            while (nrOfPins > 0) {
                int startIndex = componentInfo.getLocalBubbleOutputStartId() + busIndex * 64;
                int nrOfBitsInThisBus = Math.min(nrOfPins, 64);
                nrOfPins -= nrOfBitsInThisBus;
                int endIndex = startIndex + nrOfBitsInThisBus - 1;
                contents.add("{{assign}} {{1}}{{<}}{{2}}{{3}}{{4}}{{>}}{{=}}{{5}};", "logisimOutputBubbles", endIndex, Hdl.vectorLoopId(), startIndex, Hdl.getBusName(componentInfo, busIndex, nets));
                ++busIndex;
            }
        } else {
            int outputIndex = 0;
            int busIndex = 0;
            while (nrOfPins > 0) {
                int startIndex = componentInfo.getLocalBubbleInOutStartId() + busIndex * 64;
                int nrOfBitsInThisBus = Math.min(nrOfPins, 64);
                nrOfPins -= nrOfBitsInThisBus;
                int endIndex = startIndex + nrOfBitsInThisBus - 1;
                int inputIndex = portType == PortIo.INOUTSE ? busIndex + 1 : busIndex * 2 + 1;
                outputIndex = inputIndex + 1;
                contents.add("{{assign}} {{1}}{{=}}{{2}}{{<}}{{3}}{{4}}{{5}}{{>}};", Hdl.getBusName(componentInfo, inputIndex, nets), "logisimInOutBubbles", endIndex, Hdl.vectorLoopId(), startIndex);
                ++busIndex;
            }
            int enableIndex = 0;
            nrOfPins = componentInfo.getComponent().getAttributeSet().getValue(PortIo.ATTR_SIZE).getWidth();
            int busIndex2 = 0;
            while (nrOfPins > 0) {
                int startIndex = componentInfo.getLocalBubbleInOutStartId() + busIndex2 * 64;
                int nrOfBitsInThisBus = Math.min(nrOfPins, 64);
                nrOfPins -= nrOfBitsInThisBus;
                int endIndex = startIndex + nrOfBitsInThisBus - 1;
                if (portType != PortIo.INOUTSE && busIndex2 > 0) {
                    enableIndex += 2;
                }
                if (portType == PortIo.INOUTSE) {
                    if (Hdl.isVhdl()) {
                        contents.addVhdlKeywords().add("{{1}}({{2}} {{downto}} {{3}}) <= {{4}} {{when}} {{5}} = '1' {{else}} ({{others}} => 'Z');", "logisimInOutBubbles", endIndex, startIndex, Hdl.getBusName(componentInfo, outputIndex++, nets), Hdl.getNetName(componentInfo, enableIndex, true, nets));
                    } else {
                        contents.add("assign {{1}}[{{2}}:{{3}}] = ({{4}}) ? {{5}} : {{6}}'bZ;", "logisimInOutBubbles", endIndex, startIndex, Hdl.getNetName(componentInfo, enableIndex, true, nets), Hdl.getBusName(componentInfo, outputIndex++, nets), nrOfBitsInThisBus);
                    }
                } else {
                    for (int busBitIndex = 0; busBitIndex < nrOfBitsInThisBus; ++busBitIndex) {
                        if (Hdl.isVhdl()) {
                            contents.add("{{1}}({{2}}) <= {{3}} {{when}} {{4}} = '1' {{else}} 'Z';", "logisimInOutBubbles", startIndex + busBitIndex, Hdl.getBusEntryName(componentInfo, outputIndex, true, busBitIndex, nets), Hdl.getBusEntryName(componentInfo, enableIndex, true, busBitIndex, nets));
                            continue;
                        }
                        contents.add("assign {{1}}[{{2}}] = ({{3}}) ? {{4}} : 1'bZ;", "logisimInOutBubbles", startIndex + busBitIndex, Hdl.getBusEntryName(componentInfo, enableIndex, true, busBitIndex, nets), Hdl.getBusEntryName(componentInfo, outputIndex, true, busBitIndex, nets));
                    }
                    ++outputIndex;
                }
                ++busIndex2;
            }
        }
        return contents;
    }
}

