/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.io;

import com.cburch.logisim.comp.Component;
import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Direction;
import com.cburch.logisim.data.Location;
import com.cburch.logisim.fpga.data.ComponentMapInformationContainer;
import com.cburch.logisim.instance.InstanceFactory;
import com.cburch.logisim.instance.InstancePainter;
import com.cburch.logisim.instance.InstanceState;
import com.cburch.logisim.instance.Port;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.std.Strings;
import com.cburch.logisim.std.io.ReptarLocalBusHdlGeneratorFactory;
import java.awt.Color;
import java.awt.Graphics;
import java.util.ArrayList;

public class ReptarLocalBus
extends InstanceFactory {
    public static final String _ID = "ReptarLB";
    public static final int SP6_LB_nCS3_O = 0;
    public static final int SP6_LB_nADV_ALE_O = 1;
    public static final int SP6_LB_RE_nOE_O = 2;
    public static final int SP6_LB_nWE_O = 3;
    public static final int SP_6_LB_WAIT_3_I = 4;
    public static final int ADDR_DATA_LB_O = 5;
    public static final int ADDR_DATA_LB_I = 6;
    public static final int ADDR_DATA_LB_TRIS_I = 7;
    public static final int ADDR_LB_O = 8;
    public static final int IRQ_I = 9;
    private static final String defaultLocalBusName = "LocalBus";

    public static String getInputLabel(int id) {
        if (id < 5) {
            switch (id) {
                case 0: {
                    return "SP6_LB_nCS3_i";
                }
                case 1: {
                    return "SP6_LB_nADV_ALE_i";
                }
                case 2: {
                    return "SP6_LB_RE_nOE_i";
                }
                case 3: {
                    return "SP6_LB_nWE_i";
                }
            }
        }
        if (id < 13) {
            return "Addr_LB_i_" + (id + 11);
        }
        return "Undefined";
    }

    public static String getOutputLabel(int id) {
        return switch (id) {
            case 0 -> "SP6_LB_WAIT3_o";
            case 1 -> "IRQ_o";
            default -> "Undefined";
        };
    }

    public static String getIoLabel(int id) {
        if (id < 16) {
            return "Addr_Data_LB_io_" + id;
        }
        return "Undefined";
    }

    public ReptarLocalBus() {
        super(_ID, Strings.S.getter("repLBComponent"), new ReptarLocalBusHdlGeneratorFactory(), false, true);
        ArrayList<String> inpLabels = new ArrayList<String>();
        ArrayList<String> outpLabels = new ArrayList<String>();
        ArrayList<String> ioLabels = new ArrayList<String>();
        for (int i = 0; i < 16; ++i) {
            if (i < 13) {
                inpLabels.add(ReptarLocalBus.getInputLabel(i));
            }
            if (i < 2) {
                outpLabels.add(ReptarLocalBus.getOutputLabel(i));
            }
            ioLabels.add(ReptarLocalBus.getIoLabel(i));
        }
        this.setAttributes(new Attribute[]{StdAttr.LABEL, StdAttr.MAPINFO}, new Object[]{defaultLocalBusName, new ComponentMapInformationContainer(13, 2, 16, inpLabels, outpLabels, ioLabels)});
        this.setOffsetBounds(Bounds.create(-110, -10, 110, 110));
        this.setIconName("localbus.gif");
        Port[] ps = new Port[]{new Port(0, 0, "output", 1), new Port(0, 10, "output", 1), new Port(0, 20, "output", 1), new Port(0, 30, "output", 1), new Port(0, 40, "input", 1), new Port(0, 50, "output", 16), new Port(0, 60, "input", 16), new Port(0, 70, "input", 1), new Port(0, 80, "output", 9), new Port(0, 90, "input", 1)};
        ps[0].setToolTip(Strings.S.getter("repLBTip"));
        ps[1].setToolTip(Strings.S.getter("repLBTip"));
        ps[2].setToolTip(Strings.S.getter("repLBTip"));
        ps[3].setToolTip(Strings.S.getter("repLBTip"));
        ps[4].setToolTip(Strings.S.getter("repLBTip"));
        ps[5].setToolTip(Strings.S.getter("repLBTip"));
        ps[6].setToolTip(Strings.S.getter("repLBTip"));
        ps[7].setToolTip(Strings.S.getter("repLBTip"));
        ps[8].setToolTip(Strings.S.getter("repLBTip"));
        ps[9].setToolTip(Strings.S.getter("repLBTip"));
        this.setPorts(ps);
    }

    @Override
    public Component createComponent(Location loc, AttributeSet attrs) {
        attrs.setReadOnly(StdAttr.LABEL, true);
        return super.createComponent(loc, attrs);
    }

    @Override
    public String getHDLName(AttributeSet attrs) {
        return attrs.getValue(StdAttr.LABEL);
    }

    @Override
    public void paintInstance(InstancePainter painter) {
        Graphics g = painter.getGraphics();
        painter.drawBounds();
        g.setColor(Color.BLACK);
        g.setFont(g.getFont().deriveFont(g.getFont().getSize2D() - 2.0f));
        painter.drawPort(0, "SP6_LB_nCS3_o", Direction.WEST);
        painter.drawPort(1, "SP6_LB_nADV_ALE_o", Direction.WEST);
        painter.drawPort(2, "SP6_LB_RE_nOE_o", Direction.WEST);
        painter.drawPort(3, "SP6_LB_nWE_o", Direction.WEST);
        painter.drawPort(4, "SP6_LB_WAIT3_i", Direction.WEST);
        painter.drawPort(5, "Addr_Data_LB_o", Direction.WEST);
        painter.drawPort(6, "Addr_Data_LB_i", Direction.WEST);
        painter.drawPort(7, "Addr_Data_LB_tris_i", Direction.WEST);
        painter.drawPort(8, "Addr_LB_o", Direction.WEST);
        painter.drawPort(9, "IRQ_i", Direction.WEST);
    }

    @Override
    public void propagate(InstanceState state) {
        throw new UnsupportedOperationException("Reptar Local Bus simulation not implemented");
    }
}

