/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.io;

import com.cburch.logisim.circuit.appear.DynamicElement;
import com.cburch.logisim.circuit.appear.DynamicElementProvider;
import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Direction;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.fpga.data.ComponentMapInformationContainer;
import com.cburch.logisim.gui.icons.LedIcon;
import com.cburch.logisim.instance.Instance;
import com.cburch.logisim.instance.InstanceDataSingleton;
import com.cburch.logisim.instance.InstanceFactory;
import com.cburch.logisim.instance.InstanceLogger;
import com.cburch.logisim.instance.InstancePainter;
import com.cburch.logisim.instance.InstanceState;
import com.cburch.logisim.instance.Port;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.std.Strings;
import com.cburch.logisim.std.io.AbstractSimpleIoHdlGeneratorFactory;
import com.cburch.logisim.std.io.IoLibrary;
import com.cburch.logisim.std.io.RgbLedShape;
import com.cburch.logisim.tools.key.DirectionConfigurator;
import com.cburch.logisim.util.GraphicsUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.List;

public class RgbLed
extends InstanceFactory
implements DynamicElementProvider {
    public static final String _ID = "RGBLED";
    public static final int RED = 0;
    public static final int GREEN = 1;
    public static final int BLUE = 2;

    public static List<String> getLabels() {
        ArrayList<String> labelNames = new ArrayList<String>();
        for (int i = 0; i < 3; ++i) {
            labelNames.add("");
        }
        labelNames.set(0, "RED");
        labelNames.set(1, "GREEN");
        labelNames.set(2, "BLUE");
        return labelNames;
    }

    public static String getLabel(int id) {
        if (id < 0 || id > RgbLed.getLabels().size()) {
            return "Undefined";
        }
        return RgbLed.getLabels().get(id);
    }

    public RgbLed() {
        super(_ID, Strings.S.getter("RGBledComponent"), new AbstractSimpleIoHdlGeneratorFactory(false), true);
        this.setAttributes(new Attribute[]{StdAttr.FACING, IoLibrary.ATTR_ACTIVE, StdAttr.LABEL, StdAttr.LABEL_LOC, StdAttr.LABEL_FONT, StdAttr.LABEL_COLOR, StdAttr.LABEL_VISIBILITY, StdAttr.MAPINFO}, new Object[]{Direction.WEST, Boolean.TRUE, "", Direction.EAST, StdAttr.DEFAULT_LABEL_FONT, StdAttr.DEFAULT_LABEL_COLOR, true, new ComponentMapInformationContainer(0, 3, 0, null, RgbLed.getLabels(), null)});
        this.setFacingAttribute(StdAttr.FACING);
        this.setIcon(new LedIcon(true));
        this.setKeyConfigurator(new DirectionConfigurator(StdAttr.LABEL_LOC, 512));
        this.setInstanceLogger(Logger.class);
    }

    private void updatePorts(Instance instance) {
        Direction facing = instance.getAttributeValue(StdAttr.FACING);
        Port[] ps = new Port[3];
        int cx = 0;
        int cy = 0;
        int dx = 0;
        int dy = 0;
        if (facing == Direction.NORTH) {
            cy = 10;
            dx = 10;
        } else if (facing == Direction.EAST) {
            cx = -10;
            dy = 10;
        } else if (facing == Direction.SOUTH) {
            cy = -10;
            dx = -10;
        } else {
            cx = 10;
            dy = -10;
        }
        ps[0] = new Port(0, 0, "input", 1);
        ps[1] = new Port(cx + dx, cy + dy, "input", 1);
        ps[2] = new Port(cx - dx, cy - dy, "input", 1);
        ps[0].setToolTip(Strings.S.getter("RED"));
        ps[1].setToolTip(Strings.S.getter("GREEN"));
        ps[2].setToolTip(Strings.S.getter("BLUE"));
        instance.setPorts(ps);
    }

    @Override
    public boolean activeOnHigh(AttributeSet attrs) {
        return attrs.getValue(IoLibrary.ATTR_ACTIVE);
    }

    @Override
    protected void configureNewInstance(Instance instance) {
        instance.addAttributeListener();
        this.updatePorts(instance);
        instance.computeLabelTextField(8);
    }

    @Override
    public Bounds getOffsetBounds(AttributeSet attrs) {
        Direction facing = attrs.getValue(StdAttr.FACING);
        return Bounds.create(0, -10, 20, 20).rotate(Direction.WEST, facing, 0, 0);
    }

    @Override
    protected void instanceAttributeChanged(Instance instance, Attribute<?> attr) {
        if (attr == StdAttr.FACING) {
            instance.recomputeBounds();
            this.updatePorts(instance);
            instance.computeLabelTextField(8);
        } else if (attr == StdAttr.LABEL_LOC) {
            instance.computeLabelTextField(8);
        }
    }

    @Override
    public void paintGhost(InstancePainter painter) {
        Graphics g = painter.getGraphics();
        Bounds bds = painter.getBounds();
        GraphicsUtil.switchToWidth(g, 2);
        g.drawOval(bds.getX() + 1, bds.getY() + 1, bds.getWidth() - 2, bds.getHeight() - 2);
    }

    @Override
    public void paintInstance(InstancePainter painter) {
        InstanceDataSingleton data = (InstanceDataSingleton)painter.getData();
        int sum = data == null ? 0 : (Integer)data.getValue();
        Bounds bds = painter.getBounds().expand(-1);
        Graphics g = painter.getGraphics();
        if (painter.getShowState()) {
            Boolean activ = painter.getAttributeValue(IoLibrary.ATTR_ACTIVE);
            int mask = activ != false ? 0 : 7;
            int red = ((sum ^= mask) >> 0 & 1) * 255;
            int green = (sum >> 1 & 1) * 255;
            int blue = (sum >> 2 & 1) * 255;
            Color ledColor = new Color(red, green, blue);
            g.setColor(ledColor);
            g.fillOval(bds.getX(), bds.getY(), bds.getWidth(), bds.getHeight());
        }
        g.setColor(Color.BLACK);
        GraphicsUtil.switchToWidth(g, 2);
        g.drawOval(bds.getX(), bds.getY(), bds.getWidth(), bds.getHeight());
        GraphicsUtil.switchToWidth(g, 1);
        painter.drawLabel();
        painter.drawPorts();
    }

    @Override
    public void propagate(InstanceState state) {
        int summary = 0;
        for (int i = 0; i < 3; ++i) {
            Value val = state.getPortValue(i);
            if (val != Value.TRUE) continue;
            summary |= 1 << i;
        }
        Integer value = summary;
        InstanceDataSingleton data = (InstanceDataSingleton)state.getData();
        if (data == null) {
            state.setData(new InstanceDataSingleton(value));
        } else {
            data.setValue(value);
        }
    }

    @Override
    public DynamicElement createDynamicElement(int x, int y, DynamicElement.Path path) {
        return new RgbLedShape(x, y, path);
    }

    public static class Logger
    extends InstanceLogger {
        static final BitWidth BITWIDTH = BitWidth.create(3);

        @Override
        public String getLogName(InstanceState state, Object option) {
            return state.getAttributeValue(StdAttr.LABEL);
        }

        @Override
        public BitWidth getBitWidth(InstanceState state, Object option) {
            return BITWIDTH;
        }

        @Override
        public Value getLogValue(InstanceState state, Object option) {
            InstanceDataSingleton data = (InstanceDataSingleton)state.getData();
            if (data == null) {
                return Value.createUnknown(BITWIDTH);
            }
            return Value.createKnown(BITWIDTH, (long)((Integer)data.getValue()).intValue());
        }
    }
}

