/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.io;

import com.cburch.logisim.circuit.CircuitState;
import com.cburch.logisim.circuit.appear.DynamicElement;
import com.cburch.logisim.instance.InstanceDataSingleton;
import com.cburch.logisim.std.Strings;
import com.cburch.logisim.std.io.IoLibrary;
import com.cburch.logisim.std.io.LedShape;
import com.cburch.logisim.util.GraphicsUtil;
import java.awt.Color;
import java.awt.Graphics;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class RgbLedShape
extends LedShape {
    public RgbLedShape(int x, int y, DynamicElement.Path p) {
        super(x, y, p);
    }

    @Override
    public void paintDynamic(Graphics g, CircuitState state) {
        int x = this.bounds.getX() + 1;
        int y = this.bounds.getY() + 1;
        int w = this.bounds.getWidth() - 2;
        int h = this.bounds.getHeight() - 2;
        GraphicsUtil.switchToWidth(g, this.strokeWidth);
        if (state == null) {
            g.setColor(Color.lightGray);
            g.fillOval(x, y, w, h);
            g.setColor(DynamicElement.COLOR);
        } else {
            Boolean activ = this.path.leaf().getAttributeSet().getValue(IoLibrary.ATTR_ACTIVE);
            InstanceDataSingleton data = (InstanceDataSingleton)this.getData(state);
            int summ = data == null ? 0 : (Integer)data.getValue();
            int mask = activ != false ? 0 : 7;
            int red = ((summ ^= mask) >> 0 & 1) * 255;
            int green = (summ >> 1 & 1) * 255;
            int blue = (summ >> 2 & 1) * 255;
            g.setColor(new Color(red, green, blue));
            g.fillOval(x, y, w, h);
            g.setColor(Color.darkGray);
        }
        g.drawOval(x, y, w, h);
        this.drawLabel(g);
    }

    @Override
    public Element toSvgElement(Document doc) {
        return this.toSvgElement(doc.createElement("visible-rgbled"));
    }

    @Override
    public String getDisplayName() {
        return Strings.S.get("RGBledComponent");
    }

    @Override
    public String toString() {
        return "RgbLed:" + this.getBounds();
    }
}

