/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.io;

import com.cburch.logisim.circuit.CircuitState;
import com.cburch.logisim.circuit.appear.DynamicElement;
import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.std.Strings;
import com.cburch.logisim.std.io.Tty;
import com.cburch.logisim.std.io.TtyState;
import com.cburch.logisim.util.GraphicsUtil;
import com.cburch.logisim.util.UnmodifiableList;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TtyShape
extends DynamicElement {
    public TtyShape(int x, int y, DynamicElement.Path p) {
        super(p, Bounds.create(x, y, 240, 130));
    }

    public void setBounds(int width, int height) {
        this.bounds = Bounds.create(this.bounds.getX(), this.bounds.getY(), width, height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintDynamic(Graphics g, CircuitState state) {
        int rows;
        TtyState data;
        TtyState ttyState = data = state == null ? null : (TtyState)this.getData(state);
        if (data != null) {
            int height;
            rows = data.getNrRows();
            int cols = data.getNrCols();
            int width = 10 + cols * 7;
            if (width < 30) {
                width = 30;
            }
            if ((height = 10 + rows * 15) < 30) {
                height = 30;
            }
            this.setBounds(width, height);
        }
        GraphicsUtil.switchToWidth(g, 2);
        g.setColor(Color.YELLOW);
        g.fillRoundRect(this.bounds.getX(), this.bounds.getY(), this.bounds.getWidth(), this.bounds.getHeight(), 10, 10);
        g.setColor(Color.BLACK);
        g.drawRoundRect(this.bounds.getX(), this.bounds.getY(), this.bounds.getWidth(), this.bounds.getHeight(), 10, 10);
        if (data != null) {
            rows = data.getNrRows();
            String[] rowData = new String[rows];
            TtyState width = data;
            synchronized (width) {
                for (int i = 0; i < rows; ++i) {
                    rowData[i] = data.getRowString(i);
                }
            }
            g.setFont(Tty.DEFAULT_FONT);
            FontMetrics fm = g.getFontMetrics();
            int x = this.bounds.getX() + 5;
            int y = this.bounds.getY() + 5 + (15 + fm.getAscent()) / 2;
            for (int i = 0; i < rows; ++i) {
                g.drawString(rowData[i], x, y);
                y += 15;
            }
        }
    }

    @Override
    public List<Attribute<?>> getAttributes() {
        return UnmodifiableList.create(new Attribute[]{ATTR_LABEL, StdAttr.LABEL_FONT, StdAttr.LABEL_COLOR});
    }

    @Override
    public Element toSvgElement(Document doc) {
        return this.toSvgElement(doc.createElement("visible-tty"));
    }

    @Override
    public String getDisplayName() {
        return Strings.S.get("ttyComponent");
    }

    public String toString() {
        return "Tty:" + this.getBounds();
    }
}

