/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.io.extra;

import com.cburch.logisim.circuit.Circuit;
import com.cburch.logisim.circuit.CircuitState;
import com.cburch.logisim.circuit.SubcircuitFactory;
import com.cburch.logisim.comp.Component;
import com.cburch.logisim.comp.ComponentFactory;
import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.AttributeOption;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.data.Attributes;
import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Direction;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.instance.Instance;
import com.cburch.logisim.instance.InstanceData;
import com.cburch.logisim.instance.InstanceFactory;
import com.cburch.logisim.instance.InstancePainter;
import com.cburch.logisim.instance.InstanceState;
import com.cburch.logisim.instance.Port;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.std.Strings;
import com.cburch.logisim.util.GraphicsUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.Line;

public class Buzzer
extends InstanceFactory {
    public static final String _ID = "Buzzer";
    private static final byte FREQ = 0;
    private static final byte ENABLE = 1;
    private static final byte VOL = 2;
    private static final byte PW = 3;
    private static final Attribute<BitWidth> VOLUME_WIDTH = Attributes.forBitWidth("vol_width", Strings.S.getter("buzzerVolumeBitWidth"));
    private static final AttributeOption Hz = new AttributeOption("Hz", Strings.S.getter("Hz"));
    private static final AttributeOption dHz = new AttributeOption("dHz", Strings.S.getter("buzzerUnitDhz"));
    private static final Attribute<AttributeOption> FREQUENCY_MEASURE = Attributes.forOption("freq_measure", Strings.S.getter("buzzerFrequecy"), new AttributeOption[]{Hz, dHz});
    private static final AttributeOption Sine = new AttributeOption((Object)BuzzerWaveform.Sine, Strings.S.getter("buzzerSine"));
    private static final AttributeOption Square = new AttributeOption((Object)BuzzerWaveform.Square, Strings.S.getter("buzzerSquare"));
    private static final AttributeOption Triangle = new AttributeOption((Object)BuzzerWaveform.Triangle, Strings.S.getter("buzzerTriangle"));
    private static final AttributeOption Sawtooth = new AttributeOption((Object)BuzzerWaveform.Sawtooth, Strings.S.getter("buzzerSawtooth"));
    private static final AttributeOption Noise = new AttributeOption((Object)BuzzerWaveform.Noise, Strings.S.getter("buzzerNoise"));
    private static final Attribute<AttributeOption> WAVEFORM = Attributes.forOption("waveform", Strings.S.getter("buzzerWaveform"), new AttributeOption[]{Sine, Square, Triangle, Sawtooth, Noise});
    private static final AttributeOption C_BOTH = new AttributeOption(3, Strings.S.getter("buzzerChannelBoth"));
    private static final AttributeOption C_LEFT = new AttributeOption(1, Strings.S.getter("buzzerChannelLeft"));
    private static final AttributeOption C_RIGHT = new AttributeOption(2, Strings.S.getter("buzzerChannelRight"));
    private static final Attribute<AttributeOption> CHANNEL = Attributes.forOption("channel", Strings.S.getter("buzzerChannel"), new AttributeOption[]{C_BOTH, C_LEFT, C_RIGHT});
    private static final Attribute<Integer> SMOOTH_LEVEL = Attributes.forIntegerRange("smooth_level", Strings.S.getter("buzzerSmoothLevel"), 0, 10);
    private static final Attribute<Integer> SMOOTH_WIDTH = Attributes.forIntegerRange("smooth_width", Strings.S.getter("buzzerSmoothWidth"), 1, 10);

    public Buzzer() {
        super(_ID, Strings.S.getter("buzzerComponent"));
        this.setAttributes(new Attribute[]{StdAttr.FACING, StdAttr.SELECT_LOC, FREQUENCY_MEASURE, VOLUME_WIDTH, StdAttr.LABEL, StdAttr.LABEL_FONT, WAVEFORM, CHANNEL, SMOOTH_LEVEL, SMOOTH_WIDTH}, new Object[]{Direction.WEST, StdAttr.SELECT_BOTTOM_LEFT, Hz, BitWidth.create(7), "", StdAttr.DEFAULT_LABEL_FONT, Sine, C_BOTH, 2, 2});
        this.setFacingAttribute(StdAttr.FACING);
        this.setIconName("buzzer.gif");
    }

    public static void stopBuzzerSound(Component comp, CircuitState circState) {
        ComponentFactory compFact = comp.getFactory();
        if (compFact instanceof Buzzer) {
            Data d = (Data)circState.getData(comp);
            if (d != null && d.thread.isAlive()) {
                d.isOn.set(false);
            }
        } else if (compFact instanceof SubcircuitFactory) {
            for (Component subComponent : ((SubcircuitFactory)comp.getFactory()).getSubcircuit().getComponents()) {
                Buzzer.stopBuzzerSound(subComponent, ((SubcircuitFactory)compFact).getSubstate(circState, comp));
            }
        }
    }

    @Override
    protected void configureNewInstance(Instance instance) {
        Bounds b = instance.getBounds();
        this.updateports(instance);
        instance.addAttributeListener();
        instance.setTextField(StdAttr.LABEL, StdAttr.LABEL_FONT, b.getX() + b.getWidth() / 2, b.getY() - 3, 0, 2);
    }

    @Override
    public Bounds getOffsetBounds(AttributeSet attrs) {
        Direction dir = attrs.getValue(StdAttr.FACING);
        return dir == Direction.EAST || dir == Direction.WEST ? Bounds.create(-40, -20, 40, 40).rotate(Direction.EAST, dir, 0, 0) : Bounds.create(-20, 0, 40, 40).rotate(Direction.NORTH, dir, 0, 0);
    }

    @Override
    protected void instanceAttributeChanged(Instance instance, Attribute<?> attr) {
        if (attr == StdAttr.FACING) {
            instance.recomputeBounds();
            this.updateports(instance);
        } else if (attr == VOLUME_WIDTH || attr == StdAttr.SELECT_LOC) {
            this.updateports(instance);
        } else if (attr == WAVEFORM || attr == CHANNEL || attr == SMOOTH_LEVEL || attr == SMOOTH_WIDTH) {
            instance.fireInvalidated();
        }
    }

    @Override
    public void paintGhost(InstancePainter painter) {
        Bounds b = painter.getBounds();
        Graphics g = painter.getGraphics();
        g.setColor(Color.GRAY);
        g.drawOval(b.getX(), b.getY(), 40, 40);
    }

    @Override
    public void paintInstance(InstancePainter painter) {
        Graphics g = painter.getGraphics();
        Bounds b = painter.getBounds();
        int x = b.getX();
        int y = b.getY();
        byte height = (byte)b.getHeight();
        byte width = (byte)b.getWidth();
        g.setColor(Color.DARK_GRAY);
        g.fillOval(x, y, 40, 40);
        g.setColor(Color.GRAY);
        GraphicsUtil.switchToWidth(g, 2);
        for (int k = 8; k <= 16; k = (int)((byte)(k + 4))) {
            g.drawOval(x + 20 - k, y + 20 - k, k * 2, k * 2);
        }
        GraphicsUtil.switchToWidth(g, 2);
        g.setColor(Color.DARK_GRAY);
        g.drawLine(x + 4, y + height / 2, x + 36, y + height / 2);
        g.drawLine(x + width / 2, y + 4, x + width / 2, y + 36);
        g.setColor(Color.BLACK);
        g.fillOval(x + 15, y + 15, 10, 10);
        g.drawOval(x, y, 40, 40);
        painter.drawPorts();
        painter.drawLabel();
    }

    private Data getData(InstanceState state) {
        Data data = (Data)state.getData();
        if (data == null) {
            data = new Data();
            state.setData(data);
        }
        return data;
    }

    @Override
    public void propagate(InstanceState state) {
        Data data = this.getData(state);
        boolean active = state.getPortValue(1) == Value.TRUE;
        data.isOn.set(active);
        int freq = (int)state.getPortValue(0).toLongValue();
        if (freq >= 0) {
            if (state.getAttributeValue(FREQUENCY_MEASURE) == dHz) {
                freq /= 10;
            }
            data.hz = freq;
        } else {
            data.hz = 440;
        }
        data.wf = (BuzzerWaveform)((Object)state.getAttributeValue(WAVEFORM).getValue());
        data.channels = (Integer)state.getAttributeValue(CHANNEL).getValue();
        data.pw = state.getPortValue(3).isFullyDefined() ? (int)state.getPortValue(3).toLongValue() : 128;
        data.smoothLevel = state.getAttributeValue(SMOOTH_LEVEL);
        data.smoothWidth = state.getAttributeValue(SMOOTH_WIDTH);
        if (state.getPortValue(2).isFullyDefined()) {
            int vol = (int)state.getPortValue(2).toLongValue();
            byte volumeWidth = (byte)state.getAttributeValue(VOLUME_WIDTH).getWidth();
            data.vol = (double)(((long)vol & 0xFFFFFFFFL) * 32767L) / (Math.pow(2.0, volumeWidth) - 1.0);
        } else {
            data.vol = 0.5;
        }
        data.updateRequired = true;
        if (active && !data.thread.isAlive()) {
            data.startThread();
        }
    }

    private void updateports(Instance instance) {
        Direction facing = instance.getAttributeValue(StdAttr.FACING);
        byte volumeWidth = (byte)instance.getAttributeValue(VOLUME_WIDTH).getWidth();
        Port[] ports = new Port[4];
        if (facing == Direction.EAST || facing == Direction.WEST) {
            ports[0] = new Port(0, -10, "input", 14);
            ports[2] = new Port(0, 10, "input", volumeWidth);
        } else {
            ports[0] = new Port(-10, 0, "input", 14);
            ports[2] = new Port(10, 0, "input", volumeWidth);
        }
        ports[0].setToolTip(Strings.S.getter("buzzerFrequecy"));
        ports[2].setToolTip(Strings.S.getter("buzzerVolume"));
        ports[1] = new Port(0, 0, "input", 1);
        ports[1].setToolTip(Strings.S.getter("enableSound"));
        AttributeOption selectLoc = instance.getAttributeValue(StdAttr.SELECT_LOC);
        int xPw = 20;
        int yPw = 20;
        if (facing == Direction.NORTH || facing == Direction.SOUTH) {
            xPw *= selectLoc == StdAttr.SELECT_BOTTOM_LEFT ? -1 : 1;
            yPw *= facing == Direction.SOUTH ? -1 : 1;
        } else {
            xPw *= facing == Direction.EAST ? -1 : 1;
            yPw *= selectLoc == StdAttr.SELECT_TOP_RIGHT ? -1 : 1;
        }
        ports[3] = new Port(xPw, yPw, "input", 8);
        ports[3].setToolTip(Strings.S.getter("buzzerDutyCycle"));
        instance.setPorts(ports);
    }

    @Override
    public void removeComponent(Circuit circ, Component c, CircuitState state) {
        Buzzer.stopBuzzerSound(c, state);
    }

    private static class Data
    implements InstanceData {
        private int sampleRate;
        private final AtomicBoolean isOn = new AtomicBoolean(false);
        public int pw;
        public int channels;
        private int hz;
        private double vol;
        private int smoothLevel = 0;
        private int smoothWidth = 0;
        private boolean updateRequired = true;
        private BuzzerWaveform wf = BuzzerWaveform.Sine;
        private Thread thread;

        public Data() {
            this.startThread();
        }

        @Override
        public Object clone() {
            return new Data();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void threadFunc() {
            AudioFormat af = null;
            Line clip = null;
            AudioInputStream ais = null;
            int oldfreq = -1;
            int oldpw = -1;
            try {
                while (this.isOn.get()) {
                    if (!this.updateRequired) continue;
                    this.updateRequired = false;
                    if (this.hz < 20 || this.hz > 20000) {
                        return;
                    }
                    if (this.hz != oldfreq) {
                        this.sampleRate = (int)Math.ceil(44100.0 / (double)this.hz) * this.hz;
                        af = new AudioFormat(this.sampleRate, 16, 2, true, false);
                        oldfreq = this.hz;
                    }
                    int cycle = Math.max(1, this.sampleRate / this.hz);
                    double[] values = new double[4 * cycle];
                    for (int i = 0; i < values.length; ++i) {
                        values[i] = this.wf.strategy.amplitude((double)i / (double)this.sampleRate, this.hz, (double)this.pw / 256.0);
                    }
                    if (this.wf != BuzzerWaveform.Sine && this.smoothLevel > 0 && this.smoothWidth > 0) {
                        double[] nsig = new double[values.length];
                        for (int k = 0; k < this.smoothLevel; ++k) {
                            int sum = 0;
                            for (int i = 0; i < values.length; ++i) {
                                if (i > 2 * this.smoothWidth) {
                                    nsig[i - this.smoothWidth - 1] = ((double)sum - values[i - this.smoothWidth - 1]) / (double)(2 * this.smoothWidth);
                                    sum = (int)((double)sum - values[i - 2 * this.smoothWidth - 1]);
                                }
                                sum = (int)((double)sum + values[i]);
                            }
                            System.arraycopy(nsig, this.smoothWidth, values, this.smoothWidth, values.length - 2 * this.smoothWidth);
                        }
                    }
                    double[] rvalues = new double[this.sampleRate];
                    for (int i = 0; i < this.sampleRate; i += cycle) {
                        System.arraycopy(values, 2 * cycle, rvalues, i, Math.min(cycle, this.sampleRate - i));
                    }
                    byte[] buf = new byte[4 * this.sampleRate];
                    int i = 0;
                    int j = 0;
                    while (i < buf.length) {
                        short val = (short)Math.round(rvalues[j] * this.vol);
                        if ((this.channels & 1) != 0) {
                            buf[i] = (byte)(val & 0xFF);
                            buf[i + 1] = (byte)(val >> 8);
                        }
                        if ((this.channels & 2) != 0) {
                            buf[i + 2] = (byte)(val & 0xFF);
                            buf[i + 3] = (byte)(val >> 8);
                        }
                        i += 4;
                        ++j;
                    }
                    AudioInputStream newAis = new AudioInputStream(new ByteArrayInputStream(buf), af, buf.length);
                    Clip newClip = AudioSystem.getClip();
                    newClip.open(newAis);
                    if (clip != null) {
                        newClip.loop(-1);
                        clip.close();
                        ais.close();
                    }
                    clip = newClip;
                    ais = newAis;
                    clip.loop(-1);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (clip != null) {
                    clip.close();
                }
                if (ais != null) {
                    try {
                        ais.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }

        public void startThread() {
            if (Thread.activeCount() > 100) {
                return;
            }
            this.thread = new Thread(this::threadFunc);
            this.thread.start();
            this.thread.setName("Sound Thread");
        }
    }

    private static enum BuzzerWaveform {
        Sine((i, hz, pw) -> Math.sin(i * hz * 2.0 * Math.PI)),
        Square((i, hz, pw) -> hz * i % 1.0 < pw ? 1.0 : -1.0),
        Triangle((i, hz, pw) -> Math.asin(BuzzerWaveform.Sine.strategy.amplitude(i, hz, pw)) * 2.0 / Math.PI),
        Sawtooth((i, hz, pw) -> 2.0 * (hz * i % 1.0) - 1.0),
        Noise((i, hz, pw) -> Math.random() * 2.0 - 1.0);

        public final BuzzerWaveformStrategy strategy;

        private BuzzerWaveform(BuzzerWaveformStrategy strategy) {
            this.strategy = strategy;
        }
    }

    private static interface BuzzerWaveformStrategy {
        public double amplitude(double var1, double var3, double var5);
    }
}

