/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.io.extra;

import com.cburch.logisim.data.Value;
import com.cburch.logisim.instance.InstanceData;
import java.util.Arrays;

class DiagramState
implements InstanceData {
    private byte usedcell = (byte)-1;
    private Value LastClock = Value.UNKNOWN;
    private boolean moveback = false;
    private Boolean[][] diagram;
    private byte Inputs;
    private byte Length;
    private byte clocknumber;

    public DiagramState(byte inputs, byte length) {
        this.diagram = new Boolean[inputs][length];
        this.clear();
        this.Inputs = inputs;
        this.Length = length;
        this.clocknumber = (byte)(this.Length / 2);
    }

    public void clear() {
        for (byte i = 0; i < this.Inputs; i = (byte)(i + 1)) {
            for (byte j = 0; j < this.Length; j = (byte)(j + 1)) {
                this.diagram[i][j] = null;
            }
        }
        this.moveback = false;
    }

    @Override
    public DiagramState clone() {
        try {
            return (DiagramState)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public byte getclocknumber() {
        return this.clocknumber;
    }

    public boolean getmoveback() {
        return this.moveback;
    }

    public Boolean getState(int i, int j) {
        return this.diagram[i][j];
    }

    public byte getusedcell() {
        return this.usedcell;
    }

    public void hastomoveback(boolean b) {
        this.moveback = b;
    }

    public void moveback() {
        if (this.Length >= 1) {
            for (byte i = 0; i < this.Inputs; i = (byte)(i + 1)) {
                System.arraycopy(this.diagram[i], 1, this.diagram[i], 0, this.Length - 1);
            }
        }
    }

    public void setclocknumber(byte i) {
        this.clocknumber = i < 100 ? i : (byte)1;
    }

    public Value setLastClock(Value newClock) {
        Value ret = this.LastClock;
        this.LastClock = newClock;
        return ret;
    }

    public void setState(byte i, byte j, Boolean b) {
        this.diagram[i][j] = b;
    }

    public void setusedcell(byte i) {
        this.usedcell = i;
    }

    public void updateSize(byte inputs, byte length) {
        if (inputs != this.Inputs || length != this.Length) {
            byte oldinputs = this.Inputs;
            byte oldlength = this.Length;
            this.Inputs = inputs;
            this.Length = length;
            this.clocknumber = (byte)(this.clocknumber + (this.Length - oldlength) / 2);
            Boolean[][] olddiagram = (Boolean[][])Arrays.copyOf(this.diagram, this.diagram.length);
            this.diagram = new Boolean[this.Inputs][this.Length];
            this.clear();
            if (this.usedcell < this.Length - 1) {
                for (byte i = 0; i < this.Inputs && i < oldinputs; i = (byte)(i + 1)) {
                    for (byte j = 0; j < this.Length && j < oldlength; j = (byte)(j + 1)) {
                        this.diagram[i][j] = olddiagram[i][j];
                    }
                }
                this.moveback = false;
            } else {
                for (int i = 0; i < this.Inputs && i < oldinputs; ++i) {
                    int h = oldlength - 1;
                    for (byte j = (byte)(this.Length - 1); j >= 0 && h >= 0; --h, j = (byte)(j - 1)) {
                        this.diagram[i][j] = olddiagram[i][h - (oldlength - this.usedcell - 1)];
                    }
                }
                this.usedcell = (byte)(this.Length - 1);
                this.moveback = true;
            }
        }
    }
}

