/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.io.extra;

import com.cburch.contracts.BaseMouseListenerContract;
import com.cburch.contracts.BaseMouseMotionListenerContract;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.prefs.AppPreferences;
import com.cburch.logisim.std.Strings;
import com.cburch.logisim.std.io.extra.PlaRomData;
import com.cburch.logisim.std.ttl.Drawgates;
import com.cburch.logisim.util.GraphicsUtil;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;

public class PlaRomPanel
extends JPanel
implements BaseMouseListenerContract,
BaseMouseMotionListenerContract {
    private static final long serialVersionUID = 7182231893518001053L;
    private static final byte IMAGE_BORDER = 20;
    private final PlaRomData data;
    private boolean hover = false;

    public PlaRomPanel(PlaRomData data) {
        this.data = data;
        super.addMouseListener(this);
        super.addMouseMotionListener(this);
    }

    private boolean drawCircleConnection(MouseEvent e) {
        int row = this.getRow(AppPreferences.getDownScaled(e.getY()));
        int column = this.getColumn(AppPreferences.getDownScaled(e.getX()));
        int column2 = this.getColumn(AppPreferences.getDownScaled(e.getX()) + 10);
        this.hover = true;
        if (row % 2 == 0 && row > 0 && column > 0 && (row = row / 2 - 1) <= this.data.getAnd() - 1) {
            if (column <= this.data.getInputs() * 2) {
                this.data.setHovered(row, column - 1);
                return true;
            }
            if (column2 > this.data.getInputs() * 2 + 3 && (column2 -= this.data.getInputs() * 2 + 4) % 2 == 0) {
                this.data.setHovered(row, this.data.getInputs() * 2 + column2 / 2);
                return true;
            }
        }
        this.hover = false;
        return false;
    }

    private void drawNot(Graphics g, int x, int y) {
        if (AppPreferences.GATE_SHAPE.get().equals("rectangular")) {
            g.drawRect(x - 6, y, 12, 13);
            GraphicsUtil.drawCenteredText(g, "1", x, y + 6);
        } else {
            int[] xp = new int[4];
            int[] yp = new int[4];
            xp[0] = x - 6;
            yp[0] = y;
            xp[1] = x;
            yp[1] = y + 13;
            xp[2] = x + 6;
            yp[2] = y;
            xp[3] = x - 6;
            yp[3] = y;
            g.drawPolyline(xp, yp, 4);
        }
        g.drawOval(x - 3, y + 14, 6, 6);
    }

    private void drawOr(Graphics g, int x, int y) {
        if (AppPreferences.GATE_SHAPE.get().equals("rectangular")) {
            g.drawRect(x - 14, y, 28, 28);
            GraphicsUtil.drawCenteredText(g, "\u22651", x, y + 12);
        } else {
            GraphicsUtil.drawCenteredArc(g, x + 21, y - 1, 36, 180, 53);
            GraphicsUtil.drawCenteredArc(g, x - 21, y - 1, 36, 0, -53);
            GraphicsUtil.drawCenteredArc(g, x, y - 28, 30, -120, 60);
        }
    }

    private int getColumn(int x) {
        return (x += 0) / 20;
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(AppPreferences.getScaled((this.data.getInputs() + this.data.getOutputs() + 1) * 40 + 40 - 10), AppPreferences.getScaled((this.data.getAnd() + 2) * 40 + 25 + 40));
    }

    private int getRow(int y) {
        return (y -= 40) / 20;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        int row = this.getRow(AppPreferences.getDownScaled(e.getY()));
        int column = this.getColumn(AppPreferences.getDownScaled(e.getX()));
        int column2 = this.getColumn(AppPreferences.getDownScaled(e.getX()) + 10);
        if (row % 2 == 0 && row > 0 && column > 0 && (row = row / 2 - 1) <= this.data.getAnd() - 1) {
            if (column <= this.data.getInputs() * 2) {
                if (--column % 2 == 1 && !this.data.getInputAndValue(row, column) && this.data.getInputAndValue(row, column - 1)) {
                    this.data.setInputAndValue(row, column - 1, false);
                } else if (column % 2 == 0 && !this.data.getInputAndValue(row, column) && this.data.getInputAndValue(row, column + 1)) {
                    this.data.setInputAndValue(row, column + 1, false);
                }
                this.data.setInputAndValue(row, column, !this.data.getInputAndValue(row, column));
                this.repaint();
            } else if (column2 > this.data.getInputs() * 2 + 3 && (column2 -= this.data.getInputs() * 2 + 4) % 2 == 0) {
                this.data.setAndOutputValue(row, column2, !this.data.getAndOutputValue(row, column2 /= 2));
                this.repaint();
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (this.drawCircleConnection(e)) {
            this.setCursor(Cursor.getPredefinedCursor(12));
        } else {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics g) {
        byte i;
        Graphics2D g2 = (Graphics2D)g;
        g2.scale(AppPreferences.getScaled(1.0), AppPreferences.getScaled(1.0));
        if (AppPreferences.AntiAliassing.getBoolean()) {
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        super.paintComponent(g);
        byte inputs = this.data.getInputs();
        byte outputs = this.data.getOutputs();
        byte and = this.data.getAnd();
        GraphicsUtil.switchToWidth(g, 2);
        g.setColor(Color.DARK_GRAY);
        g.setFont(new Font("sans serif", 1, 14));
        GraphicsUtil.drawCenteredText(g, "\u2190" + Strings.S.getter("demultiplexerInTip").toString(), 40 * (inputs + 1) - 0 + 5, 14);
        GraphicsUtil.drawCenteredText(g, Strings.S.getter("multiplexerOutTip").toString() + "\u2192", 30 + 40 * inputs, 120 + 40 * and + 6);
        for (i = 1; i <= inputs; i = (byte)(i + 1)) {
            Color inputColor = this.data.getInputValue((byte)(i - 1)).getColor();
            Color notColor = this.data.getInputValue((byte)(i - 1)).not().getColor();
            g.setColor(Color.BLACK);
            GraphicsUtil.drawCenteredText(g, Integer.toString(i - 1), 40 * i - 0, 8);
            g.setColor(inputColor);
            GraphicsUtil.drawCenteredText(g, this.data.getInputValue((byte)(i - 1)).toString(), 40 * i - 0, 20);
            g.drawLine(40 * i - 0, 35, 40 * i - 0, 42);
            g.fillOval(40 * i - 0 - 3, 39, 6, 6);
            g.drawLine(40 * i - 10, 42, 40 * i - -10, 42);
            g.drawLine(40 * i - 10, 42, 40 * i - 10, 50);
            g.drawLine(40 * i - -10, 42, 40 * i - -10, 90 + 40 * (and - 1));
            g.setColor(notColor);
            g.drawLine(40 * i - 10, 70, 40 * i - 10, 90 + 40 * (and - 1));
            g.setColor(Color.BLACK);
            this.drawNot(g, 40 * i - 10, 50);
        }
        for (i = 1; i <= and; i = (byte)(i + 1)) {
            g.drawLine(30, 50 + 40 * i, 24 + 40 * inputs, 50 + 40 * i);
            g.setColor(this.data.getAndValue((byte)(i - 1)).getColor());
            g.drawLine(56 + 40 * inputs, 50 + 40 * i, 20 + 40 * (inputs + 1) + 20 + 40 * (outputs - 1), 50 + 40 * i);
            g.setColor(Color.BLACK);
            Drawgates.paintAnd(g, 56 + 40 * inputs, 50 + 40 * i, 32, 32, false);
        }
        for (i = 1; i <= outputs; i = (byte)(i + 1)) {
            g.drawLine(40 + 40 * (inputs + i), 90, 40 + 40 * (inputs + i), 74 + 40 * and);
            g.setColor(Color.BLACK);
            GraphicsUtil.drawCenteredText(g, Integer.toString(i - 1), 40 + 40 * (inputs + i), 120 + 40 * and + 12);
            g.setColor(this.data.getOutputValue((byte)(i - 1)).getColor());
            g.drawLine(40 + 40 * (inputs + i), 102 + 40 * and, 40 + 40 * (inputs + i), 109 + 40 * and);
            GraphicsUtil.drawCenteredText(g, this.data.getOutputValue((byte)(i - 1)).toString(), 40 + 40 * (inputs + i), 120 + 40 * and);
            g.setColor(Color.BLACK);
            this.drawOr(g, 40 + 40 * (inputs + i), 74 + 40 * and);
        }
        for (i = 0; i < and; i = (byte)(i + 1)) {
            for (int j = 0; j < inputs * 2; j = (int)((byte)(j + 1))) {
                if (!this.data.getInputAndValue(i, j)) continue;
                g.setColor(Color.WHITE);
                g.fillOval(26 + 20 * j, 86 + 40 * i, 8, 8);
                g.setColor(Color.BLACK);
                g.drawOval(26 + 20 * j, 86 + 40 * i, 8, 8);
            }
            for (byte k = 0; k < outputs; k = (byte)(k + 1)) {
                if (!this.data.getAndOutputValue(i, k)) continue;
                g.setColor(Color.WHITE);
                g.fillOval(36 + 40 * (inputs + 1) + 40 * k, 86 + 40 * i, 8, 8);
                g.setColor(Color.BLACK);
                g.drawOval(36 + 40 * (inputs + 1) + 40 * k, 86 + 40 * i, 8, 8);
            }
        }
        if (this.hover) {
            g.setColor(Value.trueColor);
            if (this.data.columnHovered < inputs * 2) {
                g.drawOval(24 + 20 * this.data.columnHovered, 84 + 40 * this.data.rowHovered, 12, 12);
            } else {
                g.drawOval(34 + 40 * (inputs + 1) + 40 * (this.data.columnHovered - 2 * inputs), 84 + 40 * this.data.rowHovered, 12, 12);
            }
        }
    }
}

