/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.io.extra;

import com.cburch.logisim.circuit.RadixOption;
import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.AttributeOption;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.data.Attributes;
import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Direction;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.instance.Instance;
import com.cburch.logisim.instance.InstanceData;
import com.cburch.logisim.instance.InstanceFactory;
import com.cburch.logisim.instance.InstancePainter;
import com.cburch.logisim.instance.InstancePoker;
import com.cburch.logisim.instance.InstanceState;
import com.cburch.logisim.instance.Port;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.std.Strings;
import com.cburch.logisim.std.io.IoLibrary;
import com.cburch.logisim.util.GraphicsUtil;
import com.cburch.logisim.util.LocaleManager;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;

public class Slider
extends InstanceFactory {
    public static final String _ID = "Slider";
    private static final int MAXIMUM_NUMBER_OF_BITS = 8;
    private static final int MAXIMUM_SLIDER_POSITION = 255;
    private static final AttributeOption RIGHT_TO_LEFT = new AttributeOption("right_to_left", Strings.S.getter("right_to_leftOption"));
    private static final AttributeOption LEFT_TO_RIGHT = new AttributeOption("left_to_right", Strings.S.getter("left_to_rightOption"));
    private static final Attribute<AttributeOption> ATTR_DIR = Attributes.forOption("Direction", new LocaleManager("resources/logisim", "circuit").getter("wireDirectionAttr"), new AttributeOption[]{RIGHT_TO_LEFT, LEFT_TO_RIGHT});
    private static final Attribute<BitWidth> WIDTH = Attributes.forBitWidth("width", Strings.S.getter("stdDataWidthAttr"), 1, 8);

    public Slider() {
        super(_ID, Strings.S.getter(_ID));
        this.setAttributes(new Attribute[]{StdAttr.FACING, WIDTH, RadixOption.ATTRIBUTE, IoLibrary.ATTR_COLOR, StdAttr.LABEL, StdAttr.LABEL_FONT, StdAttr.LABEL_VISIBILITY, ATTR_DIR}, new Object[]{Direction.EAST, BitWidth.create(8), RadixOption.RADIX_2, Color.WHITE, "", StdAttr.DEFAULT_LABEL_FONT, true, LEFT_TO_RIGHT});
        this.setFacingAttribute(StdAttr.FACING);
        this.setIconName("slider.gif");
        this.setPorts(new Port[]{new Port(0, 0, "output", 1)});
        this.setInstancePoker(Poker.class);
    }

    private void computeTextField(Instance instance) {
        boolean isWestOrientated = instance.getAttributeValue(StdAttr.FACING) == Direction.WEST;
        Bounds bounds = instance.getBounds();
        instance.setTextField(StdAttr.LABEL, StdAttr.LABEL_FONT, bounds.getX() - 3, isWestOrientated ? bounds.getY() : bounds.getY() + bounds.getHeight() / 2 - 1, 1, isWestOrientated ? 1 : 3);
    }

    @Override
    protected void configureNewInstance(Instance instance) {
        instance.addAttributeListener();
        this.computeTextField(instance);
        this.updateports(instance);
    }

    @Override
    public Bounds getOffsetBounds(AttributeSet attrs) {
        Direction facing = attrs.getValue(StdAttr.FACING);
        int width = 275;
        int height = 30;
        if (facing == Direction.EAST) {
            return Bounds.create(-275, -15, 275, 30);
        }
        if (facing == Direction.WEST) {
            return Bounds.create(0, -15, 275, 30);
        }
        if (facing == Direction.NORTH) {
            return Bounds.create(-137, 0, 275, 30);
        }
        return Bounds.create(-137, -30, 275, 30);
    }

    @Override
    protected void instanceAttributeChanged(Instance instance, Attribute<?> attr) {
        if (attr == StdAttr.FACING) {
            instance.recomputeBounds();
            this.updateports(instance);
            this.computeTextField(instance);
        } else if (attr == WIDTH) {
            this.updateports(instance);
            instance.fireInvalidated();
        } else if (attr == ATTR_DIR) {
            instance.fireInvalidated();
        }
    }

    @Override
    public void paintInstance(InstancePainter painter) {
        Graphics2D gfx = (Graphics2D)painter.getGraphics();
        Bounds bounds = painter.getBounds();
        SliderValue data = (SliderValue)painter.getData();
        int posX = bounds.getX();
        int posY = bounds.getY();
        int sliderPosition = data != null ? data.getSliderPosition() : (painter.getAttributeValue(ATTR_DIR) == RIGHT_TO_LEFT ? 255 : 0);
        painter.drawRoundBounds(painter.getAttributeValue(IoLibrary.ATTR_COLOR));
        GraphicsUtil.switchToWidth(gfx, 2);
        gfx.drawLine(posX + 10, posY + bounds.getHeight() - 10, posX + bounds.getWidth() - 10, posY + bounds.getHeight() - 10);
        gfx.setColor(Color.DARK_GRAY);
        gfx.fillRoundRect(posX + sliderPosition + 5, posY + bounds.getHeight() - 15, 10, 10, 4, 4);
        gfx.setColor(Color.BLACK);
        gfx.drawRoundRect(posX + sliderPosition + 5, posY + bounds.getHeight() - 15, 10, 10, 4, 4);
        painter.drawPorts();
        painter.drawLabel();
        gfx.setFont(new Font("SansSerif", 1, 10));
        GraphicsUtil.drawCenteredValue(gfx, painter.getPortValue(0), painter.getAttributeValue(RadixOption.ATTRIBUTE), posX + bounds.getWidth() / 2, posY + 6);
    }

    @Override
    public void propagate(InstanceState state) {
        SliderValue data = (SliderValue)state.getData();
        BitWidth bitWidth = state.getAttributeValue(WIDTH);
        int sliderValue = 0;
        if (data != null) {
            data.setDirection(state.getAttributeValue(ATTR_DIR) == RIGHT_TO_LEFT);
            data.setCurrentBitWidth(bitWidth.getWidth());
            sliderValue = data.getCurrentValue();
        }
        state.setPort(0, Value.createKnown(bitWidth, (long)sliderValue), 1);
    }

    private void updateports(Instance instance) {
        instance.setPorts(new Port[]{new Port(0, 0, "output", instance.getAttributeValue(WIDTH))});
    }

    public static class Poker
    extends InstancePoker {
        private boolean dragging = false;

        @Override
        public void mouseDragged(InstanceState state, MouseEvent e) {
            if (this.dragging) {
                SliderValue data = (SliderValue)state.getData();
                if (data == null) {
                    data = new SliderValue();
                    data.setDirection(state.getAttributeValue(ATTR_DIR) == RIGHT_TO_LEFT);
                    data.setCurrentBitWidth(state.getAttributeValue(WIDTH).getWidth());
                    state.setData(data);
                }
                data.setSliderPosition(e.getX() - state.getInstance().getBounds().getX() - 10);
                state.fireInvalidated();
            }
        }

        @Override
        public void mousePressed(InstanceState state, MouseEvent e) {
            SliderValue data = (SliderValue)state.getData();
            int sliderPosition = data != null ? data.getSliderPosition() : (state.getAttributeValue(ATTR_DIR) == RIGHT_TO_LEFT ? 255 : 0);
            Bounds bounds = state.getInstance().getBounds();
            Rectangle slider = new Rectangle(bounds.getX() + sliderPosition + 5, bounds.getY() + bounds.getHeight() - 16, 12, 12);
            this.dragging = slider.contains(e.getX(), e.getY());
        }

        @Override
        public void mouseReleased(InstanceState state, MouseEvent e) {
            this.dragging = false;
        }
    }

    public static class SliderValue
    implements InstanceData,
    Cloneable {
        private int nrOfBits = 8;
        private int sliderPosition = 0;
        private boolean rightToLeft = false;

        @Override
        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
        }

        public int getCurrentValue() {
            int completeValue = this.rightToLeft ? 255 - this.sliderPosition : this.sliderPosition;
            return completeValue >> 8 - this.nrOfBits;
        }

        public int getSliderPosition() {
            return this.sliderPosition;
        }

        public void setSliderPosition(int value) {
            this.sliderPosition = Math.max(0, Math.min(value, 255));
        }

        public void setCurrentBitWidth(int width) {
            if (width < 0 || width > 8 || width == this.nrOfBits) {
                return;
            }
            this.nrOfBits = width;
        }

        public void setDirection(boolean value) {
            if (value != this.rightToLeft) {
                this.rightToLeft = value;
                this.sliderPosition = 255 - this.sliderPosition;
            }
        }
    }
}

