/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.memory;

import com.cburch.logisim.data.AttributeOption;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.fpga.designrulecheck.Netlist;
import com.cburch.logisim.fpga.hdlgenerator.AbstractHdlGeneratorFactory;
import com.cburch.logisim.fpga.hdlgenerator.Hdl;
import com.cburch.logisim.fpga.hdlgenerator.HdlPorts;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.std.memory.Mem;
import com.cburch.logisim.std.memory.RamAppearance;
import com.cburch.logisim.std.memory.RamAttributes;
import com.cburch.logisim.util.LineBuffer;

public class RamHdlGeneratorFactory
extends AbstractHdlGeneratorFactory {
    private static final String ByteArrayStr = "byteArray";
    private static final int ByteArrayId = -1;
    private static final String RestArrayStr = "restArray";
    private static final int RestArrayId = -2;
    private static final String MemArrayStr = "memoryArray";
    private static final int MemArrayId = -3;

    public RamHdlGeneratorFactory() {
        this.getWiresPortsDuringHDLWriting = true;
    }

    @Override
    public void getGenerationTimeWiresPorts(Netlist theNetlist, AttributeSet attrs) {
        int nrOfBits = attrs.getValue(Mem.DATA_ATTR).getWidth();
        AttributeOption be = attrs.getValue(RamAttributes.ATTR_ByteEnables);
        boolean byteEnables = be != null && be.equals(RamAttributes.BUS_WITH_BYTEENABLES);
        int byteEnableOffset = RamAppearance.getBEIndex(0, attrs);
        int nrBePorts = RamAppearance.getNrBEPorts(attrs);
        int nrOfaddressLines = attrs.getValue(Mem.ADDR_ATTR).getWidth();
        AttributeOption trigger = attrs.getValue(StdAttr.TRIGGER);
        boolean async = StdAttr.TRIG_HIGH.equals(trigger) || StdAttr.TRIG_LOW.equals(trigger);
        int ramEntries = 1 << nrOfaddressLines;
        boolean truncated = nrOfBits % 8 != 0;
        this.myWires.addWire("s_ramdataOut", nrOfBits).addRegister("s_tickDelayLine", 3).addRegister("s_dataInReg", nrOfBits).addRegister("s_addressReg", nrOfaddressLines).addRegister("s_weReg", 1).addRegister("s_oeReg", 1).addRegister("s_dataOutReg", nrOfBits);
        if (byteEnables) {
            this.myWires.addRegister("s_byteEnableReg", nrBePorts);
            for (int idx = 0; idx < nrBePorts; ++idx) {
                this.myWires.addWire(String.format("s_byteEnable%d", idx), 1).addWire(String.format("s_we%d", idx), 1);
                this.myPorts.add("input", String.format("byteEnable%d", idx), 1, byteEnableOffset + nrBePorts - idx - 1);
            }
            this.myPorts.add("input", "oe", 1, RamAppearance.getOEIndex(0, attrs));
            int nrOfMems = nrBePorts;
            if (truncated) {
                this.myTypedWires.addArray(-2, RestArrayStr, nrOfBits % 8, ramEntries).addWire("s_truncMemContents", -2);
                --nrOfMems;
            }
            this.myTypedWires.addArray(-1, ByteArrayStr, 8, ramEntries);
            for (int mem = 0; mem < nrOfMems; ++mem) {
                this.myTypedWires.addWire(String.format("s_byteMem%dContents", mem), -1);
            }
        } else {
            this.myPorts.add("input", "oe", 1, Hdl.oneBit());
            this.myTypedWires.addArray(-3, MemArrayStr, nrOfBits, ramEntries).addWire("s_memContents", -3);
            this.myWires.addWire("s_we", 1).addWire("s_oe", 1);
        }
        this.myPorts.add("input", "address", nrOfaddressLines, RamAppearance.getAddrIndex(0, attrs)).add("input", "dataIn", nrOfBits, RamAppearance.getDataInIndex(0, attrs)).add("input", "we", 1, RamAppearance.getWEIndex(0, attrs)).add("output", "dataOut", nrOfBits, RamAppearance.getDataOutIndex(0, attrs));
        if (!async) {
            this.myPorts.add("clock", HdlPorts.getClockName(1), 1, RamAppearance.getClkIndex(0, attrs));
        }
    }

    @Override
    public LineBuffer getModuleFunctionality(Netlist theNetlist, AttributeSet attrs) {
        boolean byteEnables;
        LineBuffer contents = LineBuffer.getHdlBuffer().pair("clock", HdlPorts.getClockName(1)).pair("tick", HdlPorts.getTickName(1));
        AttributeOption be = attrs.getValue(RamAttributes.ATTR_ByteEnables);
        boolean bl = byteEnables = be != null && be.equals(RamAttributes.BUS_WITH_BYTEENABLES);
        if (Hdl.isVhdl()) {
            int i;
            contents.empty().addVhdlKeywords().addRemarkBlock("The control signals are defined here");
            if (byteEnables) {
                for (i = 0; i < RamAppearance.getNrBEPorts(attrs); ++i) {
                    contents.add("s_byteEnable{{1}} <= s_byteEnableReg({{1}}) {{and}} s_tickDelayLine(2) {{and}} s_oeReg;", i).add("s_we{{1}}         <= s_byteEnableReg({{1}}) {{and}} s_tickDelayLine(0) {{and}} s_weReg;", i);
                }
            } else {
                contents.add("s_oe <= s_tickDelayLine(2) {{and}} s_oeReg;\ns_we <= s_tickDelayLine(0) {{and}} s_weReg;\n");
            }
            contents.empty().addRemarkBlock("The input registers are defined here").add("inputRegs : {{process}}({{clock}}, {{tick}}, address, dataIn, we, oe) {{is}}\n{{begin}}\n   {{if}} (rising_edge({{clock}})) {{then}}\n      {{if}} ({{tick}} = '1') {{then}}\n          s_dataInReg  <= dataIn;\n          s_addressReg <= address;\n          s_weReg      <= we;\n          s_oeReg      <= oe;\n");
            if (byteEnables) {
                for (i = 0; i < RamAppearance.getNrBEPorts(attrs); ++i) {
                    contents.add("         s_byteEnableReg({{1}}) <= byteEnable{{1}}};", i);
                }
            }
            contents.add("      {{end}} {{if}};\n   {{end}} {{if}};\n{{end}} {{process}} inputRegs;\n").empty().add("tickPipeReg : {{process}}({{clock}}) {{is}}\n{{begin}}\n   {{if}} (rising_edge({{clock}})) {{then}}\n       s_tickDelayLine(0)          <= {{tick}};\n       s_tickDelayLine(2 {{downto}} 1) <= s_tickDelayLine(1 {{downto}} 0);\n   {{end}} {{if}};\n{{end}} {{process}} tickPipeReg;\n").empty().addRemarkBlock("The actual memorie(s) is(are) defined here");
            if (byteEnables) {
                boolean truncated = attrs.getValue(Mem.DATA_ATTR).getWidth() % 8 != 0;
                for (int i2 = 0; i2 < RamAppearance.getNrBEPorts(attrs); ++i2) {
                    contents.add("mem{{1}} : {{process}}({{clock}}, s_we{{1}}, s_dataInReg, s_addressReg) {{is}}", i2).add("{{begin}}").add("   {{if}} (rising_edge({{clock}})) {{then}}").add("      {{if}} (s_we{{1}} = '1') {{then}}", i2);
                    int startIndex = i2 * 8;
                    int endIndex = i2 == RamAppearance.getNrBEPorts(attrs) - 1 ? attrs.getValue(Mem.DATA_ATTR).getWidth() - 1 : (i2 + 1) * 8 - 1;
                    String memName = i2 == RamAppearance.getNrBEPorts(attrs) - 1 && truncated ? "s_truncMemContents" : String.format("s_byteMem%dContents", i2);
                    contents.add("         {{1}}(to_integer(unsigned(s_addressReg))) <= s_dataInReg({{2}} {{downto}} {{3}});", memName, endIndex, startIndex).add("      {{end}} {{if}};").add("      s_ramdataOut({{1}} {{downto}} {{2}}) <= {{3}}(to_integer(unsigned(s_addressReg)));", endIndex, startIndex, memName).add("   {{end}} {{if}};").add("{{end}} {{process}} mem{{1}};", i2).add("");
                }
            } else {
                contents.add("mem : {{process}}({{clock}} , s_we, s_dataInReg, s_addressReg) {{is}}\n{{begin}}\n   {{if}} (rising_edge({{clock}})) {{then}}\n      {{if}} (s_we = '1') {{then}}\n         s_memContents(to_integer(unsigned(s_addressReg))) <= s_dataInReg;\n      {{end}} {{if}};\n      s_ramdataOut <= s_memContents(to_integer(unsigned(s_addressReg)));\n   {{end}} {{if}};\n{{end}} {{process}} mem;\n");
            }
            contents.empty().addRemarkBlock("The output register is defined here");
            if (byteEnables) {
                for (i = 0; i < RamAppearance.getNrBEPorts(attrs); ++i) {
                    contents.add("res{{1}} : {{process}}({{clock}}, s_byteEnable{{1}}, s_ramdataOut) {{is}}", i).add("{{begin}}").add("   {{if}} (rising_edge({{clock}}) {{then}}").add("      {{if}} (s_byteEnable{{1}} = '1') {{then}}", i);
                    int startIndex = i * 8;
                    int endIndex = i == RamAppearance.getNrBEPorts(attrs) - 1 ? attrs.getValue(Mem.DATA_ATTR).getWidth() - 1 : (i + 1) * 8 - 1;
                    contents.add("         dataOut({{1}} {{downto}} {{2}}) <= s_ramdataOut({{1}} {{downto}} {{2}});", endIndex, startIndex).add("      {{end}} {{if}};").add("   {{end}} {{if}};").add("{{end}} {{process}} res{{1}};", i);
                }
            } else {
                contents.add("res : {{process}}({{clock}}, s_oe, s_ramdataOut) {{is}}\n{{begin}}\n   {{if}} (rising_edge({{clock}})) {{then}}\n      {{if}} (s_oe = '1') {{then}}\n        dataOut <= s_ramdataOut;\n      {{end}} {{if}};\n   {{end}} {{if}};\n{{end}} {{process}} res;\n");
            }
        }
        return contents.empty();
    }

    @Override
    public boolean isHdlSupportedTarget(AttributeSet attrs) {
        if (attrs == null) {
            return false;
        }
        AttributeOption busVal = attrs.getValue(RamAttributes.ATTR_DBUS);
        boolean separate = busVal != null && busVal.equals(RamAttributes.BUS_SEP);
        AttributeOption trigger = attrs.getValue(StdAttr.TRIGGER);
        boolean asynch = trigger == null || trigger.equals(StdAttr.TRIG_HIGH) || trigger.equals(StdAttr.TRIG_LOW);
        boolean byteEnabled = RamAppearance.getNrLEPorts(attrs) == 0;
        boolean syncRead = !attrs.containsAttribute(Mem.ASYNC_READ) || attrs.getValue(Mem.ASYNC_READ) == false;
        boolean clearPin = attrs.getValue(RamAttributes.CLEAR_PIN) == null ? false : attrs.getValue(RamAttributes.CLEAR_PIN);
        boolean readAfterWrite = !attrs.containsAttribute(Mem.READ_ATTR) || attrs.getValue(Mem.READ_ATTR).equals(Mem.READAFTERWRITE);
        return Hdl.isVhdl() && separate && !asynch && byteEnabled && syncRead && !clearPin && readAfterWrite;
    }
}

