/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.memory;

import com.cburch.contracts.BaseMouseListenerContract;
import com.cburch.logisim.circuit.Circuit;
import com.cburch.logisim.circuit.CircuitState;
import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.gui.generic.LFrame;
import com.cburch.logisim.gui.hex.HexFile;
import com.cburch.logisim.gui.hex.HexFrame;
import com.cburch.logisim.gui.icons.ArithmeticIcon;
import com.cburch.logisim.gui.main.Frame;
import com.cburch.logisim.instance.Instance;
import com.cburch.logisim.instance.InstanceComponent;
import com.cburch.logisim.instance.InstancePainter;
import com.cburch.logisim.instance.InstanceState;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.proj.Project;
import com.cburch.logisim.std.Strings;
import com.cburch.logisim.std.memory.Mem;
import com.cburch.logisim.std.memory.MemContents;
import com.cburch.logisim.std.memory.MemState;
import com.cburch.logisim.std.memory.RamAppearance;
import com.cburch.logisim.std.memory.RomAttributes;
import com.cburch.logisim.std.memory.RomHdlGeneratorFactory;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.WeakHashMap;
import javax.swing.JLabel;

public class Rom
extends Mem {
    public static final String _ID = "ROM";
    public static final Attribute<MemContents> CONTENTS_ATTR = new ContentsAttribute();
    private final WeakHashMap<Instance, Mem.MemListener> memListeners;

    public Rom() {
        super(_ID, Strings.S.getter("romComponent"), 0, new RomHdlGeneratorFactory(), true);
        this.setIcon(new ArithmeticIcon(_ID, 3));
        this.memListeners = new WeakHashMap();
    }

    @Override
    protected void configureNewInstance(Instance instance) {
        super.configureNewInstance(instance);
        MemContents contents = Rom.getMemContents(instance);
        Mem.MemListener listener = new Mem.MemListener(instance);
        this.memListeners.put(instance, listener);
        contents.addHexModelListener(listener);
        instance.addAttributeListener();
    }

    @Override
    void configurePorts(Instance instance) {
        RamAppearance.configurePorts(instance);
    }

    @Override
    public AttributeSet createAttributeSet() {
        return new RomAttributes();
    }

    @Override
    HexFrame getHexFrame(Project proj, Instance instance, CircuitState state) {
        return RomAttributes.getHexFrame(Rom.getMemContents(instance), proj, instance);
    }

    public static MemContents getMemContents(Instance instance) {
        return instance.getAttributeValue(CONTENTS_ATTR);
    }

    public static void closeHexFrame(com.cburch.logisim.comp.Component c) {
        if (!(c instanceof InstanceComponent)) {
            return;
        }
        Instance inst = ((InstanceComponent)c).getInstance();
        RomAttributes.closeHexFrame(Rom.getMemContents(inst));
    }

    @Override
    public Bounds getOffsetBounds(AttributeSet attrs) {
        int len = attrs.getValue(Mem.DATA_ATTR).getWidth();
        if (attrs.getValue(StdAttr.APPEARANCE) == StdAttr.APPEAR_CLASSIC) {
            return Bounds.create(0, 0, 240, 140);
        }
        return Bounds.create(0, 0, 240, RamAppearance.getControlHeight(attrs) + 20 * len);
    }

    @Override
    MemState getState(Instance instance, CircuitState state) {
        MemState ret = (MemState)instance.getData(state);
        if (ret == null) {
            MemContents contents = Rom.getMemContents(instance);
            ret = new MemState(contents);
            instance.setData(state, ret);
        }
        return ret;
    }

    @Override
    MemState getState(InstanceState state) {
        MemState ret = (MemState)state.getData();
        if (ret == null) {
            MemContents contents = Rom.getMemContents(state.getInstance());
            ret = new MemState(contents);
            state.setData(ret);
        }
        return ret;
    }

    @Override
    protected void instanceAttributeChanged(Instance instance, Attribute<?> attr) {
        if (attr == Mem.DATA_ATTR || attr == Mem.ADDR_ATTR || attr == StdAttr.APPEARANCE || attr == Mem.LINE_ATTR) {
            instance.recomputeBounds();
            this.configurePorts(instance);
        }
    }

    @Override
    public void paintInstance(InstancePainter painter) {
        if (painter.getAttributeValue(StdAttr.APPEARANCE) == StdAttr.APPEAR_CLASSIC) {
            RamAppearance.drawRamClassic(painter);
        } else {
            RamAppearance.drawRamEvolution(painter);
        }
    }

    @Override
    public void propagate(InstanceState state) {
        MemState myState = this.getState(state);
        BitWidth dataBits = (BitWidth)state.getAttributeValue(DATA_ATTR);
        AttributeSet attrs = state.getAttributeSet();
        Value addrValue = state.getPortValue(RamAppearance.getAddrIndex(0, attrs));
        int nrDataLines = RamAppearance.getNrDataOutPorts(attrs);
        long addr = addrValue.toLongValue();
        if (addrValue.isErrorValue() || addrValue.isFullyDefined() && addr < 0L) {
            for (int i = 0; i < nrDataLines; ++i) {
                state.setPort(RamAppearance.getDataOutIndex(i, attrs), Value.createError(dataBits), 10);
            }
            return;
        }
        if (!addrValue.isFullyDefined()) {
            for (int i = 0; i < nrDataLines; ++i) {
                state.setPort(RamAppearance.getDataOutIndex(i, attrs), Value.createUnknown(dataBits), 10);
            }
            return;
        }
        if (addr != myState.getCurrent()) {
            myState.setCurrent(addr);
            myState.scrollToShow(addr);
        }
        boolean misaligned = addr % (long)nrDataLines != 0L;
        boolean misalignError = misaligned && (Boolean)state.getAttributeValue(ALLOW_MISALIGNED) == false;
        for (int i = 0; i < nrDataLines; ++i) {
            long val = myState.getContents().get(addr + (long)i);
            state.setPort(RamAppearance.getDataOutIndex(i, attrs), misalignError ? Value.createError(dataBits) : Value.createKnown(dataBits, val), 10);
        }
    }

    @Override
    public void removeComponent(Circuit circ, com.cburch.logisim.comp.Component c, CircuitState state) {
        Rom.closeHexFrame(c);
    }

    static class ContentsAttribute
    extends Attribute<MemContents> {
        public ContentsAttribute() {
            super("contents", Strings.S.getter("romContentsAttr"));
        }

        @Override
        public Component getCellEditor(Window source, MemContents value) {
            if (source instanceof Frame) {
                Frame frame = (Frame)source;
                Project proj = frame.getProject();
                RomAttributes.register(value, proj);
            }
            ContentsCell ret = new ContentsCell(source, value);
            ret.mouseClicked(null);
            return ret;
        }

        @Override
        public MemContents parse(String value) {
            int lineBreak = value.indexOf(10);
            String first = lineBreak < 0 ? value : value.substring(0, lineBreak);
            String rest = lineBreak < 0 ? "" : value.substring(lineBreak + 1);
            StringTokenizer toks = new StringTokenizer(first);
            try {
                String header = toks.nextToken();
                if (!header.equals("addr/data:")) {
                    return null;
                }
                int addr = Integer.parseInt(toks.nextToken());
                int data = Integer.parseInt(toks.nextToken());
                return HexFile.parseFromCircFile(rest, addr, data);
            }
            catch (IOException | NumberFormatException | NoSuchElementException e) {
                return null;
            }
        }

        @Override
        public String toDisplayString(MemContents value) {
            return Strings.S.get("romContentsValue");
        }

        @Override
        public String toStandardString(MemContents state) {
            int addr = state.getLogLength();
            int data = state.getWidth();
            String contents = HexFile.saveToString(state);
            return "addr/data: " + addr + " " + data + "\n" + contents;
        }
    }

    private static class ContentsCell
    extends JLabel
    implements BaseMouseListenerContract {
        final Window source;
        final MemContents contents;

        ContentsCell(Window source, MemContents contents) {
            super(Strings.S.get("romContentsValue"));
            this.source = source;
            this.contents = contents;
            this.addMouseListener(this);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            Project project;
            LFrame frame;
            if (this.contents == null) {
                return;
            }
            Window window = this.source;
            if (window instanceof Frame) {
                frame = (Frame)window;
                project = frame.getProject();
            } else {
                project = null;
            }
            Project proj = project;
            frame = RomAttributes.getHexFrame(this.contents, proj, null);
            ((HexFrame)frame).setVisible(true);
            frame.toFront();
        }
    }
}

