/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.memory;

import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.fpga.designrulecheck.Netlist;
import com.cburch.logisim.fpga.designrulecheck.netlistComponent;
import com.cburch.logisim.fpga.hdlgenerator.Hdl;
import com.cburch.logisim.fpga.hdlgenerator.InlinedHdlGeneratorFactory;
import com.cburch.logisim.fpga.hdlgenerator.WithSelectHdlGenerator;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.std.memory.Mem;
import com.cburch.logisim.std.memory.MemContents;
import com.cburch.logisim.std.memory.RamAppearance;
import com.cburch.logisim.std.memory.Rom;
import com.cburch.logisim.util.LineBuffer;

public class RomHdlGeneratorFactory
extends InlinedHdlGeneratorFactory {
    @Override
    public LineBuffer getInlinedCode(Netlist nets, Long componentId, netlistComponent componentInfo, String circuitName) {
        AttributeSet attrs = componentInfo.getComponent().getAttributeSet();
        int addressWidth = attrs.getValue(Mem.ADDR_ATTR).getWidth();
        int dataWidth = attrs.getValue(Mem.DATA_ATTR).getWidth();
        MemContents romContents = attrs.getValue(Rom.CONTENTS_ATTR);
        WithSelectHdlGenerator generator = new WithSelectHdlGenerator(componentInfo.getComponent().getAttributeSet().getValue(StdAttr.LABEL), Hdl.getBusName(componentInfo, RamAppearance.getAddrIndex(0, attrs), nets), addressWidth, Hdl.getBusName(componentInfo, RamAppearance.getDataOutIndex(0, attrs), nets), dataWidth).setDefault(0L);
        for (long addr = 0L; addr < 1L << addressWidth; ++addr) {
            long romValue = romContents.get(addr);
            if (romValue == 0L) continue;
            generator.add((Long)addr, (Long)romValue);
        }
        return LineBuffer.getBuffer().add(generator.getHdlCode());
    }

    @Override
    public boolean isHdlSupportedTarget(AttributeSet attrs) {
        if (attrs == null) {
            return false;
        }
        if (attrs.getValue(Mem.LINE_ATTR) == null) {
            return false;
        }
        return attrs.getValue(Mem.LINE_ATTR).equals(Mem.SINGLE);
    }
}

