/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.memory;

import com.cburch.logisim.data.Value;
import com.cburch.logisim.fpga.hdlgenerator.HdlGeneratorFactory;
import com.cburch.logisim.gui.icons.FlipFlopIcon;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.std.Strings;
import com.cburch.logisim.std.memory.AbstractFlipFlop;
import com.cburch.logisim.std.memory.AbstractFlipFlopHdlGeneratorFactory;
import com.cburch.logisim.util.LineBuffer;

public class SRFlipFlop
extends AbstractFlipFlop {
    public static final String _ID = "S-R Flip-Flop";

    public SRFlipFlop() {
        super(_ID, new FlipFlopIcon(3), Strings.S.getter("srFlipFlopComponent"), 2, true, (HdlGeneratorFactory)new SRFFHDLGeneratorFactory());
    }

    @Override
    protected Value computeValue(Value[] inputs, Value curValue) {
        if (inputs[0] == Value.FALSE) {
            if (inputs[1] == Value.FALSE) {
                return curValue;
            }
            if (inputs[1] == Value.TRUE) {
                return Value.FALSE;
            }
        } else if (inputs[0] == Value.TRUE) {
            if (inputs[1] == Value.FALSE) {
                return Value.TRUE;
            }
            if (inputs[1] == Value.TRUE) {
                return Value.ERROR;
            }
        }
        return Value.UNKNOWN;
    }

    @Override
    protected String getInputName(int index) {
        return index == 0 ? "S" : "R";
    }

    private static class SRFFHDLGeneratorFactory
    extends AbstractFlipFlopHdlGeneratorFactory {
        public SRFFHDLGeneratorFactory() {
            super(2, StdAttr.TRIGGER);
            this.myPorts.add("input", "s", 1, 0).add("input", "r", 1, 1);
        }

        @Override
        public LineBuffer getUpdateLogic() {
            return LineBuffer.getHdlBuffer().add("{{assign}} s_nextState{{=}}(s_currentState{{or}}s){{and}}{{not}}(r);");
        }
    }
}

