/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.plexers;

import com.cburch.logisim.LogisimVersion;
import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.AttributeOption;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Direction;
import com.cburch.logisim.data.Location;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.fpga.designrulecheck.CorrectLabel;
import com.cburch.logisim.gui.icons.PlexerIcon;
import com.cburch.logisim.instance.Instance;
import com.cburch.logisim.instance.InstanceFactory;
import com.cburch.logisim.instance.InstancePainter;
import com.cburch.logisim.instance.InstanceState;
import com.cburch.logisim.instance.Port;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.std.Strings;
import com.cburch.logisim.std.plexers.DecoderHdlGeneratorFactory;
import com.cburch.logisim.std.plexers.Multiplexer;
import com.cburch.logisim.std.plexers.PlexersLibrary;
import com.cburch.logisim.tools.key.BitWidthConfigurator;
import com.cburch.logisim.util.GraphicsUtil;
import java.awt.Color;
import java.awt.Graphics;

public class Decoder
extends InstanceFactory {
    public static final String _ID = "Decoder";

    public Decoder() {
        super(_ID, Strings.S.getter("decoderComponent"), new DecoderHdlGeneratorFactory());
        this.setAttributes(new Attribute[]{StdAttr.FACING, StdAttr.SELECT_LOC, PlexersLibrary.ATTR_SELECT, PlexersLibrary.ATTR_TRISTATE, PlexersLibrary.ATTR_DISABLED, PlexersLibrary.ATTR_ENABLE}, new Object[]{Direction.EAST, StdAttr.SELECT_BOTTOM_LEFT, PlexersLibrary.DEFAULT_SELECT, PlexersLibrary.DEFAULT_TRISTATE, PlexersLibrary.DISABLED_ZERO, Boolean.TRUE});
        this.setKeyConfigurator(new BitWidthConfigurator(PlexersLibrary.ATTR_SELECT, 1, 5, 0));
        this.setIcon(new PlexerIcon(true, false));
        this.setFacingAttribute(StdAttr.FACING);
    }

    @Override
    protected void configureNewInstance(Instance instance) {
        instance.addAttributeListener();
        this.updatePorts(instance);
    }

    @Override
    public boolean contains(Location loc, AttributeSet attrs) {
        Direction facing = attrs.getValue(StdAttr.FACING).reverse();
        return PlexersLibrary.contains(loc, this.getOffsetBounds(attrs), facing);
    }

    @Override
    public Object getDefaultAttributeValue(Attribute<?> attr, LogisimVersion ver) {
        if (attr == PlexersLibrary.ATTR_ENABLE) {
            int newer = ver.compareTo(new LogisimVersion(2, 6, 4));
            return newer >= 0;
        }
        return super.getDefaultAttributeValue(attr, ver);
    }

    @Override
    public String getHDLName(AttributeSet attrs) {
        return CorrectLabel.getCorrectLabel(this.getName()) + "_" + (1 << attrs.getValue(PlexersLibrary.ATTR_SELECT).getWidth());
    }

    @Override
    public Bounds getOffsetBounds(AttributeSet attrs) {
        Bounds bds;
        boolean reversed;
        Direction facing = attrs.getValue(StdAttr.FACING);
        AttributeOption selectLoc = attrs.getValue(StdAttr.SELECT_LOC);
        BitWidth select = attrs.getValue(PlexersLibrary.ATTR_SELECT);
        int outputs = 1 << select.getWidth();
        boolean bl = reversed = facing == Direction.WEST || facing == Direction.NORTH;
        if (selectLoc == StdAttr.SELECT_TOP_RIGHT) {
            boolean bl2 = reversed = !reversed;
        }
        if (outputs == 2) {
            int y = reversed ? 0 : -40;
            bds = Bounds.create(-20, y - 5, 30, 50);
        } else {
            int x = -20;
            int y = reversed ? -10 : -(outputs * 10 + 10);
            bds = Bounds.create(x, y, 40, outputs * 10 + 20);
        }
        return bds.rotate(Direction.EAST, facing, 0, 0);
    }

    @Override
    public boolean hasThreeStateDrivers(AttributeSet attrs) {
        return attrs.getValue(PlexersLibrary.ATTR_TRISTATE) != false || attrs.getValue(PlexersLibrary.ATTR_DISABLED) == PlexersLibrary.DISABLED_FLOATING;
    }

    @Override
    protected void instanceAttributeChanged(Instance instance, Attribute<?> attr) {
        if (attr == StdAttr.FACING || attr == StdAttr.SELECT_LOC || attr == PlexersLibrary.ATTR_SELECT) {
            instance.recomputeBounds();
            this.updatePorts(instance);
        } else if (attr == PlexersLibrary.ATTR_ENABLE) {
            this.updatePorts(instance);
        } else if (attr == PlexersLibrary.ATTR_TRISTATE || attr == PlexersLibrary.ATTR_DISABLED) {
            instance.fireInvalidated();
        }
    }

    @Override
    public void paintGhost(InstancePainter painter) {
        Direction facing = painter.getAttributeValue(StdAttr.FACING);
        BitWidth select = painter.getAttributeValue(PlexersLibrary.ATTR_SELECT);
        Bounds bds = painter.getBounds();
        if (select.getWidth() == 1) {
            if (facing == Direction.EAST || facing == Direction.WEST) {
                PlexersLibrary.drawTrapezoid(painter.getGraphics(), Bounds.create(bds.getX(), bds.getY() + 5, bds.getWidth(), bds.getHeight() - 10), facing.reverse(), 10);
            } else {
                PlexersLibrary.drawTrapezoid(painter.getGraphics(), Bounds.create(bds.getX() + 5, bds.getY(), bds.getWidth() - 10, bds.getHeight()), facing.reverse(), 10);
            }
        } else {
            PlexersLibrary.drawTrapezoid(painter.getGraphics(), bds, facing.reverse(), 20);
        }
    }

    @Override
    public void paintInstance(InstancePainter painter) {
        int halign;
        int y0;
        int x0;
        int dy;
        Graphics g = painter.getGraphics();
        Bounds bds = painter.getBounds();
        Direction facing = painter.getAttributeValue(StdAttr.FACING);
        AttributeOption selectLoc = painter.getAttributeValue(StdAttr.SELECT_LOC);
        BitWidth select = painter.getAttributeValue(PlexersLibrary.ATTR_SELECT);
        boolean enable = painter.getAttributeValue(PlexersLibrary.ATTR_ENABLE);
        int selMult = selectLoc == StdAttr.SELECT_TOP_RIGHT ? -1 : 1;
        int outputs = 1 << select.getWidth();
        GraphicsUtil.switchToWidth(g, 3);
        boolean vertical = facing == Direction.NORTH || facing == Direction.SOUTH;
        int dx = vertical ? selMult : 0;
        int n = dy = vertical ? 0 : -selMult;
        if (outputs == 2) {
            if (painter.getShowState()) {
                g.setColor(painter.getPortValue(outputs).getColor());
            }
            Location pt = painter.getInstance().getPortLocation(outputs);
            g.drawLine(pt.getX(), pt.getY(), pt.getX() + 2 * dx, pt.getY() + 2 * dy);
        }
        if (enable) {
            int len;
            Location en = painter.getInstance().getPortLocation(outputs + 1);
            int n2 = len = outputs == 2 ? 6 : 4;
            if (painter.getShowState()) {
                g.setColor(painter.getPortValue(outputs + 1).getColor());
            }
            g.drawLine(en.getX(), en.getY(), en.getX() + len * dx, en.getY() + len * dy);
        }
        GraphicsUtil.switchToWidth(g, 1);
        Multiplexer.drawSelectCircle(g, bds, painter.getInstance().getPortLocation(outputs));
        if (facing == Direction.WEST) {
            x0 = 3;
            y0 = 15 + (outputs == 2 ? 5 : 0);
            halign = -1;
        } else if (facing == Direction.NORTH) {
            x0 = 10 + (outputs == 2 ? 5 : 0);
            y0 = 15;
            halign = 0;
        } else if (facing == Direction.SOUTH) {
            x0 = 10 + (outputs == 2 ? 5 : 0);
            y0 = bds.getHeight() - 3;
            halign = 0;
        } else {
            x0 = bds.getWidth() - 3;
            y0 = 15 + (outputs == 2 ? 5 : 0);
            halign = 1;
        }
        g.setColor(Color.GRAY);
        GraphicsUtil.drawText(g, "0", bds.getX() + x0, bds.getY() + y0, halign, 1);
        g.setColor(Color.BLACK);
        if (outputs == 2) {
            if (facing == Direction.EAST || facing == Direction.WEST) {
                PlexersLibrary.drawTrapezoid(g, Bounds.create(bds.getX(), bds.getY() + 5, bds.getWidth(), bds.getHeight() - 10), facing.reverse(), 10);
            } else {
                PlexersLibrary.drawTrapezoid(g, Bounds.create(bds.getX() + 5, bds.getY(), bds.getWidth() - 10, bds.getHeight()), facing.reverse(), 10);
            }
        } else {
            PlexersLibrary.drawTrapezoid(g, bds, facing.reverse(), 20);
        }
        GraphicsUtil.drawCenteredText(g, "Decd", bds.getX() + bds.getWidth() / 2, bds.getY() + bds.getHeight() / 2);
        painter.drawPorts();
    }

    @Override
    public void propagate(InstanceState state) {
        Value en;
        BitWidth data = BitWidth.ONE;
        BitWidth select = state.getAttributeValue(PlexersLibrary.ATTR_SELECT);
        Boolean threeState = state.getAttributeValue(PlexersLibrary.ATTR_TRISTATE);
        Boolean enable = state.getAttributeValue(PlexersLibrary.ATTR_ENABLE);
        int outputs = 1 << select.getWidth();
        Value others = threeState != false ? Value.UNKNOWN : Value.FALSE;
        int outIndex = -1;
        Value out = null;
        Value value = en = enable != false ? state.getPortValue(outputs + 1) : Value.TRUE;
        if (en == Value.FALSE) {
            AttributeOption opt = state.getAttributeValue(PlexersLibrary.ATTR_DISABLED);
            Value base = opt == PlexersLibrary.DISABLED_ZERO ? Value.FALSE : Value.UNKNOWN;
            others = Value.repeat(base, data.getWidth());
        } else if (en == Value.ERROR && state.isPortConnected(outputs + 1)) {
            others = Value.createError(data);
        } else {
            Value sel = state.getPortValue(outputs);
            if (sel.isFullyDefined()) {
                outIndex = (int)sel.toLongValue();
                out = Value.TRUE;
            } else {
                others = sel.isErrorValue() ? Value.createError(data) : Value.createUnknown(data);
            }
        }
        for (int i = 0; i < outputs; ++i) {
            state.setPort(i, i == outIndex ? out : others, 3);
        }
    }

    private void updatePorts(Instance instance) {
        Direction facing = instance.getAttributeValue(StdAttr.FACING);
        AttributeOption selectLoc = instance.getAttributeValue(StdAttr.SELECT_LOC);
        BitWidth select = instance.getAttributeValue(PlexersLibrary.ATTR_SELECT);
        Boolean enable = instance.getAttributeValue(PlexersLibrary.ATTR_ENABLE);
        int outputs = 1 << select.getWidth();
        Port[] ps = new Port[outputs + (enable != false ? 2 : 1)];
        if (outputs == 2) {
            Location end1;
            Location end0;
            if (facing == Direction.NORTH || facing == Direction.SOUTH) {
                int y;
                int n = y = facing == Direction.NORTH ? -10 : 10;
                if (selectLoc == StdAttr.SELECT_TOP_RIGHT) {
                    end0 = Location.create(-30, y, true);
                    end1 = Location.create(-10, y, true);
                } else {
                    end0 = Location.create(10, y, true);
                    end1 = Location.create(30, y, true);
                }
            } else {
                int x;
                int n = x = facing == Direction.WEST ? -10 : 10;
                if (selectLoc == StdAttr.SELECT_TOP_RIGHT) {
                    end0 = Location.create(x, 10, true);
                    end1 = Location.create(x, 30, true);
                } else {
                    end0 = Location.create(x, -30, true);
                    end1 = Location.create(x, -10, true);
                }
            }
            ps[0] = new Port(end0.getX(), end0.getY(), "output", 1);
            ps[1] = new Port(end1.getX(), end1.getY(), "output", 1);
        } else {
            int ddx;
            int dx;
            int ddy;
            int dy;
            if (facing == Direction.NORTH || facing == Direction.SOUTH) {
                dy = facing == Direction.NORTH ? -20 : 20;
                ddy = 0;
                dx = selectLoc == StdAttr.SELECT_TOP_RIGHT ? -10 * outputs : 0;
                ddx = 10;
            } else {
                dx = facing == Direction.WEST ? -20 : 20;
                ddx = 0;
                dy = selectLoc == StdAttr.SELECT_TOP_RIGHT ? 0 : -10 * outputs;
                ddy = 10;
            }
            for (int i = 0; i < outputs; ++i) {
                ps[i] = new Port(dx, dy, "output", 1);
                dx += ddx;
                dy += ddy;
            }
        }
        Location en = Location.create(0, 0, true).translate(facing, -10);
        ps[outputs] = new Port(0, 0, "input", select.getWidth());
        if (enable.booleanValue()) {
            ps[outputs + 1] = new Port(en.getX(), en.getY(), "input", BitWidth.ONE);
        }
        for (int i = 0; i < outputs; ++i) {
            ps[i].setToolTip(Strings.S.getter("decoderOutTip", "" + i));
        }
        ps[outputs].setToolTip(Strings.S.getter("decoderSelectTip"));
        if (enable.booleanValue()) {
            ps[outputs + 1].setToolTip(Strings.S.getter("decoderEnableTip"));
        }
        instance.setPorts(ps);
    }
}

