/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.plexers;

import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.AttributeOption;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Direction;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.gui.icons.ArithmeticIcon;
import com.cburch.logisim.instance.Instance;
import com.cburch.logisim.instance.InstanceFactory;
import com.cburch.logisim.instance.InstancePainter;
import com.cburch.logisim.instance.InstanceState;
import com.cburch.logisim.instance.Port;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.std.Strings;
import com.cburch.logisim.std.plexers.PlexersLibrary;
import com.cburch.logisim.std.plexers.PriorityEncoderHdlGeneratorFactory;
import com.cburch.logisim.tools.key.BitWidthConfigurator;
import com.cburch.logisim.util.GraphicsUtil;
import java.awt.Color;
import java.awt.Graphics;

public class PriorityEncoder
extends InstanceFactory {
    public static final String _ID = "Priority Encoder";
    static final int OUT = 0;
    static final int EN_IN = 1;
    static final int EN_OUT = 2;
    static final int GS = 3;

    public PriorityEncoder() {
        super(_ID, Strings.S.getter("priorityEncoderComponent"), new PriorityEncoderHdlGeneratorFactory());
        this.setAttributes(new Attribute[]{StdAttr.FACING, PlexersLibrary.ATTR_SELECT, PlexersLibrary.ATTR_DISABLED}, new Object[]{Direction.EAST, BitWidth.create(3), PlexersLibrary.DISABLED_ZERO});
        this.setKeyConfigurator(new BitWidthConfigurator(PlexersLibrary.ATTR_SELECT, 1, 5, 0));
        this.setIcon(new ArithmeticIcon("Pri"));
        this.setFacingAttribute(StdAttr.FACING);
    }

    @Override
    protected void configureNewInstance(Instance instance) {
        instance.addAttributeListener();
        this.updatePorts(instance);
    }

    @Override
    public Bounds getOffsetBounds(AttributeSet attrs) {
        Direction dir = attrs.getValue(StdAttr.FACING);
        BitWidth select = attrs.getValue(PlexersLibrary.ATTR_SELECT);
        int inputs = 1 << select.getWidth();
        int offs = -5 * inputs;
        int len = 10 * inputs + 10;
        if (dir == Direction.NORTH) {
            return Bounds.create(offs, 0, len, 40);
        }
        if (dir == Direction.SOUTH) {
            return Bounds.create(offs, -40, len, 40);
        }
        if (dir == Direction.WEST) {
            return Bounds.create(0, offs, 40, len);
        }
        return Bounds.create(-40, offs, 40, len);
    }

    @Override
    public boolean hasThreeStateDrivers(AttributeSet attrs) {
        return attrs.getValue(PlexersLibrary.ATTR_DISABLED) == PlexersLibrary.DISABLED_FLOATING;
    }

    @Override
    protected void instanceAttributeChanged(Instance instance, Attribute<?> attr) {
        if (attr == StdAttr.FACING || attr == PlexersLibrary.ATTR_SELECT) {
            instance.recomputeBounds();
            this.updatePorts(instance);
        } else if (attr == PlexersLibrary.ATTR_DISABLED) {
            instance.fireInvalidated();
        }
    }

    @Override
    public void paintInstance(InstancePainter painter) {
        int halign;
        int y0;
        int x0;
        Graphics g = painter.getGraphics();
        Direction facing = painter.getAttributeValue(StdAttr.FACING);
        painter.drawBounds();
        Bounds bds = painter.getBounds();
        g.setColor(Color.GRAY);
        if (facing == Direction.WEST) {
            x0 = bds.getX() + bds.getWidth() - 3;
            y0 = bds.getY() + 15;
            halign = 1;
        } else if (facing == Direction.NORTH) {
            x0 = bds.getX() + 10;
            y0 = bds.getY() + bds.getHeight() - 2;
            halign = 0;
        } else if (facing == Direction.SOUTH) {
            x0 = bds.getX() + 10;
            y0 = bds.getY() + 12;
            halign = 0;
        } else {
            x0 = bds.getX() + 3;
            y0 = bds.getY() + 15;
            halign = -1;
        }
        GraphicsUtil.drawText(g, "0", x0, y0, halign, 1);
        g.setColor(Color.BLACK);
        GraphicsUtil.drawCenteredText(g, "Pri", bds.getX() + bds.getWidth() / 2, bds.getY() + bds.getHeight() / 2);
        painter.drawPorts();
    }

    @Override
    public void propagate(InstanceState state) {
        Value outDefault;
        BitWidth select = state.getAttributeValue(PlexersLibrary.ATTR_SELECT);
        int n = 1 << select.getWidth();
        boolean enabled = state.getPortValue(n + 1) != Value.FALSE;
        int out = -1;
        if (enabled) {
            outDefault = Value.createUnknown(select);
            for (int i = n - 1; i >= 0; --i) {
                if (state.getPortValue(i) != Value.TRUE) continue;
                out = i;
                break;
            }
        } else {
            AttributeOption opt = state.getAttributeValue(PlexersLibrary.ATTR_DISABLED);
            Value base = opt == PlexersLibrary.DISABLED_ZERO ? Value.FALSE : Value.UNKNOWN;
            outDefault = Value.repeat(base, select.getWidth());
        }
        if (out < 0) {
            state.setPort(n + 0, outDefault, 3);
            state.setPort(n + 2, enabled ? Value.TRUE : Value.FALSE, 3);
            state.setPort(n + 3, Value.FALSE, 3);
        } else {
            state.setPort(n + 0, Value.createKnown(select, (long)out), 3);
            state.setPort(n + 2, Value.FALSE, 3);
            state.setPort(n + 3, Value.TRUE, 3);
        }
    }

    private void updatePorts(Instance instance) {
        Direction dir = instance.getAttributeValue(StdAttr.FACING);
        BitWidth select = instance.getAttributeValue(PlexersLibrary.ATTR_SELECT);
        int n = 1 << select.getWidth();
        Port[] ps = new Port[n + 4];
        if (dir == Direction.NORTH || dir == Direction.SOUTH) {
            x = -5 * n + 10;
            y = dir == Direction.NORTH ? 40 : -40;
            for (i = 0; i < n; ++i) {
                ps[i] = new Port(x + 10 * i, y, "input", 1);
            }
            ps[n + 0] = new Port(0, 0, "output", select.getWidth());
            ps[n + 1] = new Port(x + 10 * n, y / 2, "input", 1);
            ps[n + 2] = new Port(x - 10, y / 2, "output", 1);
            ps[n + 3] = new Port(10, 0, "output", 1);
        } else {
            x = dir == Direction.EAST ? -40 : 40;
            y = -5 * n + 10;
            for (i = 0; i < n; ++i) {
                ps[i] = new Port(x, y + 10 * i, "input", 1);
            }
            ps[n + 0] = new Port(0, 0, "output", select.getWidth());
            ps[n + 1] = new Port(x / 2, y + 10 * n, "input", 1);
            ps[n + 2] = new Port(x / 2, y - 10, "output", 1);
            ps[n + 3] = new Port(0, 10, "output", 1);
        }
        for (int i = 0; i < n; ++i) {
            ps[i].setToolTip(Strings.S.getter("priorityEncoderInTip", "" + i));
        }
        ps[n + 0].setToolTip(Strings.S.getter("priorityEncoderOutTip"));
        ps[n + 1].setToolTip(Strings.S.getter("priorityEncoderEnableInTip"));
        ps[n + 2].setToolTip(Strings.S.getter("priorityEncoderEnableOutTip"));
        ps[n + 3].setToolTip(Strings.S.getter("priorityEncoderGroupSignalTip"));
        instance.setPorts(ps);
    }
}

