/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.tcl;

import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.gui.icons.ArithmeticIcon;
import com.cburch.logisim.instance.Instance;
import com.cburch.logisim.instance.InstanceFactory;
import com.cburch.logisim.instance.InstancePainter;
import com.cburch.logisim.instance.InstanceState;
import com.cburch.logisim.instance.Port;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.std.tcl.TclComponentAttributes;
import com.cburch.logisim.std.tcl.TclComponentData;
import com.cburch.logisim.std.tcl.TclComponentListener;
import com.cburch.logisim.util.GraphicsUtil;
import com.cburch.logisim.util.StringGetter;
import com.cburch.logisim.util.StringUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.Arrays;
import java.util.WeakHashMap;

public abstract class TclComponent
extends InstanceFactory {
    static final int WIDTH = 140;
    static final int HEIGHT = 40;
    static final int PORT_GAP = 10;
    static final int X_PADDING = 5;
    private Port[] inputs;
    private Port[] outputs;
    private final WeakHashMap<Instance, TclComponentListener> contentListeners = new WeakHashMap();

    protected static <T> T[] concat(T[] first, T[] second) {
        T[] result = Arrays.copyOf(first, first.length + second.length);
        System.arraycopy(second, 0, result, first.length, second.length);
        return result;
    }

    public TclComponent(String name, StringGetter displayName) {
        super(name, displayName);
        this.inputs = new Port[0];
        this.outputs = new Port[0];
        this.setIcon(new ArithmeticIcon("TCL", 3));
    }

    @Override
    protected void configureNewInstance(Instance instance) {
        TclComponentListener listener = new TclComponentListener(instance);
        this.contentListeners.put(instance, listener);
        instance.addAttributeListener();
        this.updatePorts(instance);
    }

    @Override
    public AttributeSet createAttributeSet() {
        return new TclComponentAttributes();
    }

    @Override
    public Bounds getOffsetBounds(AttributeSet attrs) {
        int nbInputs = this.inputs.length;
        int nbOutputs = this.outputs.length;
        return Bounds.create(0, 0, 140, Math.max(nbInputs, nbOutputs) * 10 + 40);
    }

    @Override
    public void paintInstance(InstancePainter painter) {
        Graphics g = painter.getGraphics();
        FontMetrics metric = g.getFontMetrics();
        Bounds bds = painter.getBounds();
        int x0 = bds.getX() + bds.getWidth() / 2;
        int y0 = bds.getY() + metric.getHeight() + 12;
        GraphicsUtil.drawText(g, StringUtil.resizeString(this.getDisplayName(), metric, 140), x0, y0, 0, 2);
        String glbLabel = painter.getAttributeValue(StdAttr.LABEL);
        if (glbLabel != null) {
            Font font = g.getFont();
            g.setFont(painter.getAttributeValue(StdAttr.LABEL_FONT));
            GraphicsUtil.drawCenteredText(g, glbLabel, bds.getX() + bds.getWidth() / 2, bds.getY() - g.getFont().getSize());
            g.setFont(font);
        }
        g.setColor(Color.GRAY);
        g.setFont(g.getFont().deriveFont(10.0f));
        metric = g.getFontMetrics();
        int i = 0;
        for (Port p : this.inputs) {
            GraphicsUtil.drawText(g, StringUtil.resizeString(p.getToolTip(), metric, 65), bds.getX() + 5, bds.getY() + 40 - 2 + i++ * 10, -1, 0);
        }
        i = 0;
        for (Port p : this.outputs) {
            GraphicsUtil.drawText(g, StringUtil.resizeString(p.getToolTip(), metric, 65), bds.getX() + 140 - 5, bds.getY() + 40 - 2 + i++ * 10, 1, 0);
        }
        painter.drawBounds();
        painter.drawPorts();
    }

    @Override
    public void propagate(InstanceState state) {
        TclComponentData tclComponentData = TclComponentData.get(state);
        tclComponentData.getTclWrapper().start();
        if (tclComponentData.isConnected()) {
            for (Port p : state.getInstance().getPorts()) {
                int index = state.getPortIndex(p);
                Value val = state.getPortValue(index);
                String message = p.getType() + ":" + p.getToolTip() + ":" + val.toBinaryString() + ":" + index;
                tclComponentData.send(message);
            }
            if (tclComponentData.isNewTick()) {
                tclComponentData.send("sync_force");
                this.getPortsFromServer(state, tclComponentData);
            } else {
                String serverResponse;
                tclComponentData.send("sync_examine");
                while ((serverResponse = tclComponentData.receive()) != null && serverResponse.length() > 0 && !serverResponse.equals("sync")) {
                }
            }
        }
    }

    void getPortsFromServer(InstanceState state, TclComponentData tclComponentData) {
        String serverResponse;
        while ((serverResponse = tclComponentData.receive()) != null && serverResponse.length() > 0 && !serverResponse.equals("sync")) {
            String[] parameters = serverResponse.split(":");
            if (parameters.length < 2) continue;
            String busValue = parameters[1];
            int portId = Integer.parseInt(parameters[2]);
            int width = state.getFactory().getPorts().get(portId).getFixedBitWidth().getWidth();
            if (busValue.length() > width) {
                busValue = busValue.substring(busValue.length() - width);
            }
            Value[] vectorValues = new Value[width];
            for (int i = width - 1; i >= busValue.length(); --i) {
                vectorValues[i] = Value.UNKNOWN;
            }
            int idx = busValue.length() - 1;
            for (char bit : busValue.toCharArray()) {
                try {
                    vectorValues[idx] = switch (Character.getNumericValue(bit)) {
                        case 0 -> Value.FALSE;
                        case 1 -> Value.TRUE;
                        default -> Value.UNKNOWN;
                    };
                }
                catch (NumberFormatException e) {
                    vectorValues[idx] = Value.ERROR;
                }
                --idx;
            }
            state.setPort(portId, Value.create(vectorValues), 1);
        }
    }

    void setPorts(Port[] inputs, Port[] outputs) {
        this.inputs = inputs;
        this.outputs = outputs;
        this.setPorts(TclComponent.concat(inputs, outputs));
    }

    void updatePorts(Instance instance) {
    }

    public static class PortDescription {
        private final String name;
        private final String type;
        private final BitWidth width;

        public PortDescription(String name, String type, int width) {
            this.name = name;
            this.type = type;
            this.width = BitWidth.create(width);
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }

        public BitWidth getWidth() {
            return this.width;
        }
    }
}

