/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.ttl;

import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.instance.StdAttr;

class ClockState
implements Cloneable {
    private Value lastClock = Value.FALSE;

    public ClockState clone() {
        try {
            return (ClockState)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public boolean updateClock(Value newClock, Object trigger) {
        Value oldClock = this.lastClock;
        this.lastClock = newClock;
        if (trigger == null || trigger == StdAttr.TRIG_RISING) {
            return oldClock == Value.FALSE && newClock == Value.TRUE;
        }
        if (trigger == StdAttr.TRIG_FALLING) {
            return oldClock == Value.TRUE && newClock == Value.FALSE;
        }
        if (trigger == StdAttr.TRIG_HIGH) {
            return newClock == Value.TRUE;
        }
        if (trigger == StdAttr.TRIG_LOW) {
            return newClock == Value.FALSE;
        }
        return oldClock == Value.FALSE && newClock == Value.TRUE;
    }

    public boolean updateClock(Value newClock) {
        Value oldClock = this.lastClock;
        this.lastClock = newClock;
        return oldClock == Value.FALSE && newClock == Value.TRUE;
    }

    public boolean updateClock(Value newClock, int which) {
        Value[] values = this.lastClock.getAll();
        if (values.length <= which) {
            Value[] nvalue = Value.createKnown(BitWidth.create(which + 1), 0L).getAll();
            System.arraycopy(values, 0, nvalue, 0, values.length);
            values = nvalue;
        }
        Value oldClock = values[which];
        values[which] = newClock;
        this.lastClock = Value.create(values);
        return oldClock == Value.FALSE && newClock == Value.TRUE;
    }
}

