/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.ttl;

import com.cburch.logisim.fpga.hdlgenerator.HdlGeneratorFactory;
import com.cburch.logisim.instance.InstancePainter;
import com.cburch.logisim.instance.InstanceState;
import com.cburch.logisim.std.ttl.AbstractGateHdlGenerator;
import com.cburch.logisim.std.ttl.AbstractTtlGate;
import com.cburch.logisim.std.ttl.Drawgates;
import com.cburch.logisim.util.LineBuffer;
import java.awt.Graphics;

public class Ttl7404
extends AbstractTtlGate {
    public static final String _ID = "7404";
    private static final byte portCount = 14;
    private static final byte[] outPorts = new byte[]{2, 4, 6, 8, 10, 12};

    public Ttl7404() {
        super(_ID, (byte)14, outPorts, true, (HdlGeneratorFactory)new NotGateHdlGeneratorFactory());
    }

    public Ttl7404(String name) {
        super(name, (byte)14, outPorts, true, (HdlGeneratorFactory)new NotGateHdlGeneratorFactory());
    }

    @Override
    public void paintInternal(InstancePainter painter, int x, int y, int height, boolean up) {
        Graphics g = painter.getGraphics();
        int portwidth = 12;
        int portheight = 6;
        int youtput = y + (up ? 20 : 40);
        Drawgates.paintNot(g, x + 26, youtput, 12, 6);
        Drawgates.paintOutputgate(g, x + 30, y, x + 26, youtput, up, height);
        Drawgates.paintSingleInputgate(g, x + 10, y, x + 26 - 12, youtput, up, height);
    }

    @Override
    public void propagateTtl(InstanceState state) {
        int i;
        for (i = 1; i < 6; i = (int)((byte)(i + 2))) {
            state.setPort(i, state.getPortValue(i - 1).not(), 1);
        }
        for (i = 6; i < 12; i = (int)((byte)(i + 2))) {
            state.setPort(i, state.getPortValue(i + 1).not(), 1);
        }
    }

    private static class NotGateHdlGeneratorFactory
    extends AbstractGateHdlGenerator {
        public NotGateHdlGeneratorFactory() {
            super(true);
        }

        @Override
        public LineBuffer getLogicFunction(int index) {
            return LineBuffer.getHdlBuffer().add("{{assign}}gateO{{1}}{{assign}}{{not}}(gateA{{1}});", index);
        }
    }
}

