/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.ttl;

import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.fpga.designrulecheck.Netlist;
import com.cburch.logisim.fpga.hdlgenerator.AbstractHdlGeneratorFactory;
import com.cburch.logisim.fpga.hdlgenerator.Hdl;
import com.cburch.logisim.std.ttl.TtlLibrary;
import com.cburch.logisim.util.LineBuffer;

public class Ttl7410HdlGenerator
extends AbstractHdlGeneratorFactory {
    private final boolean Inverted;
    private final boolean andgate;

    public Ttl7410HdlGenerator() {
        this(true, true);
    }

    public Ttl7410HdlGenerator(boolean invert, boolean IsAnd) {
        this.Inverted = invert;
        this.andgate = IsAnd;
        this.myPorts.add("input", "A0", 1, 0).add("input", "B0", 1, 1).add("input", "C0", 1, 11).add("input", "A1", 1, 2).add("input", "B1", 1, 3).add("input", "C1", 1, 4).add("input", "A2", 1, 9).add("input", "B2", 1, 8).add("input", "C2", 1, 7).add("output", "Y0", 1, 10).add("output", "Y1", 1, 5).add("output", "Y2", 1, 6);
    }

    @Override
    public LineBuffer getModuleFunctionality(Netlist TheNetlist, AttributeSet attrs) {
        String Inv = this.Inverted ? Hdl.notOperator() : "";
        String Func = this.andgate ? Hdl.andOperator() : Hdl.orOperator();
        return LineBuffer.getHdlBuffer().add("{{assign}}Y0{{=}}{{1}}(A0{{2}}B0{{2}}C0);", Inv, Func).add("{{assign}}Y1{{=}}{{1}}(A1{{2}}B1{{2}}C1);", Inv, Func).add("{{assign}}Y2{{=}}{{1}}(A2{{2}}B2{{2}}C2);", Inv, Func);
    }

    @Override
    public boolean isHdlSupportedTarget(AttributeSet attrs) {
        if (attrs == null) {
            return false;
        }
        return attrs.getValue(TtlLibrary.VCC_GND) == false;
    }
}

