/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.ttl;

import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.fpga.designrulecheck.netlistComponent;
import com.cburch.logisim.instance.InstancePainter;
import com.cburch.logisim.instance.InstancePoker;
import com.cburch.logisim.instance.InstanceState;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.std.ttl.AbstractTtlGate;
import com.cburch.logisim.std.ttl.Drawgates;
import com.cburch.logisim.std.ttl.ShiftRegisterData;
import com.cburch.logisim.std.ttl.TtlLibrary;
import com.cburch.logisim.util.GraphicsUtil;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.MouseEvent;

public class Ttl74164
extends AbstractTtlGate {
    public static final String _ID = "74164";
    public static final int PORT_INDEX_A = 0;
    public static final int PORT_INDEX_B = 1;
    public static final int PORT_INDEX_QA = 2;
    public static final int PORT_INDEX_QB = 3;
    public static final int PORT_INDEX_QC = 4;
    public static final int PORT_INDEX_QD = 5;
    public static final int PORT_INDEX_CLK = 6;
    public static final int PORT_INDEX_CLR = 7;
    public static final int PORT_INDEX_QE = 8;
    public static final int PORT_INDEX_QF = 9;
    public static final int PORT_INDEX_QG = 10;
    public static final int PORT_INDEX_QH = 11;

    public Ttl74164() {
        super(_ID, (byte)14, new byte[]{3, 4, 5, 6, 10, 11, 12, 13}, new String[]{"A", "B", "QA", "QB", "QC", "QD", "Clock", "Clear", "QE", "QF", "QG", "QH"}, null);
        super.setInstancePoker(Poker.class);
    }

    private ShiftRegisterData getData(InstanceState state) {
        ShiftRegisterData data = (ShiftRegisterData)state.getData();
        if (data == null) {
            data = new ShiftRegisterData(BitWidth.ONE, 8);
            state.setData(data);
        }
        return data;
    }

    @Override
    public void paintInternal(InstancePainter painter, int x, int y, int height, boolean up) {
        Graphics2D gfx = (Graphics2D)painter.getGraphics();
        super.paintBase(painter, false, false);
        Drawgates.paintPortNames(painter, x, y, height, new String[]{"A", "B", "QA", "QB", "QC", "QD", "CLK", "CLR", "QE", "QF", "QG", "QH"});
        ShiftRegisterData data = this.getData(painter);
        this.drawState(gfx, x, y, height, data);
    }

    private void drawState(Graphics2D gfx, int x, int y, int height, ShiftRegisterData state) {
        if (state == null) {
            return;
        }
        for (int i = 0; i < 8; ++i) {
            gfx.setColor(state.get(7 - i).getColor());
            gfx.fillOval(x + 36 + i * 10, y + height / 2 - 4, 8, 8);
            gfx.setColor(Color.WHITE);
            GraphicsUtil.drawCenteredText(gfx, state.get(7 - i).toDisplayString(), x + 40 + i * 10, y + height / 2);
        }
        gfx.setColor(Color.BLACK);
    }

    @Override
    public void propagateTtl(InstanceState state) {
        ShiftRegisterData data = this.getData(state);
        boolean triggered = data.updateClock(state.getPortValue(6), StdAttr.TRIG_RISING);
        if (state.getPortValue(7) == Value.FALSE) {
            data.clear();
        } else if (triggered) {
            data.clear();
            data.push(state.getPortValue(0) == Value.TRUE && state.getPortValue(1) == Value.TRUE ? Value.TRUE : Value.FALSE);
            data.push(state.getPortValue(2));
            data.push(state.getPortValue(3));
            data.push(state.getPortValue(4));
            data.push(state.getPortValue(5));
            data.push(state.getPortValue(8));
            data.push(state.getPortValue(9));
            data.push(state.getPortValue(10));
        }
        state.setPort(2, data.get(0), 4);
        state.setPort(3, data.get(1), 4);
        state.setPort(4, data.get(2), 4);
        state.setPort(5, data.get(3), 4);
        state.setPort(8, data.get(4), 4);
        state.setPort(9, data.get(5), 4);
        state.setPort(10, data.get(6), 4);
        state.setPort(11, data.get(7), 4);
    }

    @Override
    public boolean checkForGatedClocks(netlistComponent comp) {
        return true;
    }

    @Override
    public int[] clockPinIndex(netlistComponent comp) {
        return new int[]{6};
    }

    public static class Poker
    extends InstancePoker {
        boolean isPressed = true;

        private boolean isInside(InstanceState state, MouseEvent e) {
            Point p = AbstractTtlGate.getTranslatedTtlXY(state, e);
            boolean inside = false;
            for (int i = 0; i < 8; ++i) {
                int dx = p.x - (40 + i * 10);
                int dy = p.y - 30;
                int d2 = dx * dx + dy * dy;
                inside |= d2 < 16;
            }
            return inside;
        }

        private int getIndex(InstanceState state, MouseEvent e) {
            Point p = AbstractTtlGate.getTranslatedTtlXY(state, e);
            for (int i = 0; i < 8; ++i) {
                int dx = p.x - (40 + i * 10);
                int dy = p.y - 30;
                int d2 = dx * dx + dy * dy;
                if (d2 >= 16) continue;
                return 7 - i;
            }
            return 0;
        }

        @Override
        public void mousePressed(InstanceState state, MouseEvent e) {
            this.isPressed = this.isInside(state, e);
        }

        @Override
        public void mouseReleased(InstanceState state, MouseEvent e) {
            if (!state.getAttributeValue(TtlLibrary.DRAW_INTERNAL_STRUCTURE).booleanValue()) {
                return;
            }
            if (this.isPressed && this.isInside(state, e)) {
                int index = this.getIndex(state, e);
                ShiftRegisterData myState = (ShiftRegisterData)state.getData();
                if (myState == null) {
                    return;
                }
                if (myState.get(index).isFullyDefined()) {
                    myState.set(index, myState.get(index).not());
                } else {
                    myState.set(index, Value.createKnown(1, 0L));
                }
                state.fireInvalidated();
            }
            this.isPressed = false;
        }
    }
}

