/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.ttl;

import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.fpga.designrulecheck.netlistComponent;
import com.cburch.logisim.instance.InstancePainter;
import com.cburch.logisim.instance.InstancePoker;
import com.cburch.logisim.instance.InstanceState;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.std.ttl.AbstractTtlGate;
import com.cburch.logisim.std.ttl.Drawgates;
import com.cburch.logisim.std.ttl.ShiftRegisterData;
import com.cburch.logisim.std.ttl.TtlLibrary;
import com.cburch.logisim.util.GraphicsUtil;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.MouseEvent;

public class Ttl74166
extends AbstractTtlGate {
    public static final String _ID = "74166";

    public Ttl74166() {
        super(_ID, (byte)16, new byte[]{13}, new String[]{"Serial Input", "P0", "P1", "P2", "P3", "Clock Inhibit", "Clock", "Clear", "P4", "P5", "P6", "Q7", "P7", "Shift/Load"}, null);
        super.setInstancePoker(Poker.class);
    }

    private ShiftRegisterData getData(InstanceState state) {
        ShiftRegisterData data = (ShiftRegisterData)state.getData();
        if (data == null) {
            data = new ShiftRegisterData(BitWidth.ONE, 8);
            state.setData(data);
        }
        return data;
    }

    @Override
    public void paintInternal(InstancePainter painter, int x, int y, int height, boolean up) {
        Graphics2D g = (Graphics2D)painter.getGraphics();
        super.paintBase(painter, false, false);
        Drawgates.paintPortNames(painter, x, y, height, new String[]{"SER", "P0", "P1", "P2", "P3", "CkIh", "CK", "nCLR", "P4", "P5", "P6", "Q7", "P7", "ShLd"});
        ShiftRegisterData data = this.getData(painter);
        this.drawState(g, x, y, height, data);
    }

    private void drawState(Graphics2D g, int x, int y, int height, ShiftRegisterData state) {
        if (state != null) {
            for (int i = 0; i < 8; ++i) {
                g.setColor(state.get(7 - i).getColor());
                g.fillOval(x + 36 + i * 10, y + height / 2 - 4, 8, 8);
                g.setColor(Color.WHITE);
                GraphicsUtil.drawCenteredText(g, state.get(7 - i).toDisplayString(), x + 40 + i * 10, y + height / 2);
            }
            g.setColor(Color.BLACK);
        }
    }

    @Override
    public void propagateTtl(InstanceState state) {
        ShiftRegisterData data = this.getData(state);
        boolean triggered = data.updateClock(state.getPortValue(6), StdAttr.TRIG_RISING);
        if (state.getPortValue(7) == Value.FALSE) {
            data.clear();
        } else if (triggered && state.getPortValue(5) != Value.TRUE) {
            if (state.getPortValue(13) == Value.FALSE) {
                data.clear();
                data.push(state.getPortValue(12));
                data.push(state.getPortValue(10));
                data.push(state.getPortValue(9));
                data.push(state.getPortValue(8));
                data.push(state.getPortValue(4));
                data.push(state.getPortValue(3));
                data.push(state.getPortValue(2));
                data.push(state.getPortValue(1));
            } else if (state.getPortValue(13) == Value.TRUE) {
                data.push(state.getPortValue(0));
            }
        }
        state.setPort(11, data.get(0), 4);
    }

    @Override
    public boolean checkForGatedClocks(netlistComponent comp) {
        return true;
    }

    @Override
    public int[] clockPinIndex(netlistComponent comp) {
        return new int[]{6};
    }

    public static class Poker
    extends InstancePoker {
        boolean isPressed = true;

        private boolean isInside(InstanceState state, MouseEvent e) {
            Point p = AbstractTtlGate.getTranslatedTtlXY(state, e);
            boolean inside = false;
            for (int i = 0; i < 8; ++i) {
                int dx = p.x - (40 + i * 10);
                int dy = p.y - 30;
                int d2 = dx * dx + dy * dy;
                inside |= d2 < 16;
            }
            return inside;
        }

        private int getIndex(InstanceState state, MouseEvent e) {
            Point p = AbstractTtlGate.getTranslatedTtlXY(state, e);
            for (int i = 0; i < 8; ++i) {
                int dx = p.x - (40 + i * 10);
                int dy = p.y - 30;
                int d2 = dx * dx + dy * dy;
                if (d2 >= 16) continue;
                return 7 - i;
            }
            return 0;
        }

        @Override
        public void mousePressed(InstanceState state, MouseEvent e) {
            this.isPressed = this.isInside(state, e);
        }

        @Override
        public void mouseReleased(InstanceState state, MouseEvent e) {
            if (!state.getAttributeValue(TtlLibrary.DRAW_INTERNAL_STRUCTURE).booleanValue()) {
                return;
            }
            if (this.isPressed && this.isInside(state, e)) {
                int index = this.getIndex(state, e);
                ShiftRegisterData myState = (ShiftRegisterData)state.getData();
                if (myState == null) {
                    return;
                }
                if (myState.get(index).isFullyDefined()) {
                    myState.set(index, myState.get(index).not());
                } else {
                    myState.set(index, Value.createKnown(1, 0L));
                }
                state.fireInvalidated();
            }
            this.isPressed = false;
        }
    }
}

