/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.ttl;

import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.fpga.hdlgenerator.HdlGeneratorFactory;
import com.cburch.logisim.instance.InstancePainter;
import com.cburch.logisim.instance.InstanceState;
import com.cburch.logisim.std.ttl.AbstractTtlGate;
import com.cburch.logisim.std.ttl.Drawgates;
import com.cburch.logisim.std.ttl.Ttl74283HdlGenerator;

public class Ttl74283
extends AbstractTtlGate {
    public static final String _ID = "74283";

    public Ttl74283() {
        super(_ID, (byte)16, new byte[]{1, 4, 9, 10, 13}, new String[]{"\u22112", "B2", "A2", "\u22111", "A1", "B1", "CIN", "C4", "\u22114", "B4", "A4", "\u22113", "A3", "B3"}, (HdlGeneratorFactory)new Ttl74283HdlGenerator());
    }

    @Override
    public void paintInternal(InstancePainter painter, int x, int y, int height, boolean up) {
        super.paintBase(painter, true, false);
        Drawgates.paintPortNames(painter, x, y, height, this.portNames);
    }

    @Override
    public void propagateTtl(InstanceState state) {
        int A1 = state.getPortValue(4) == Value.TRUE ? 1 : 0;
        int A2 = state.getPortValue(2) == Value.TRUE ? 2 : 0;
        int A3 = state.getPortValue(12) == Value.TRUE ? 4 : 0;
        int A4 = state.getPortValue(10) == Value.TRUE ? 8 : 0;
        int B1 = state.getPortValue(5) == Value.TRUE ? 1 : 0;
        int B2 = state.getPortValue(1) == Value.TRUE ? 2 : 0;
        int B3 = state.getPortValue(13) == Value.TRUE ? 4 : 0;
        int B4 = state.getPortValue(9) == Value.TRUE ? 8 : 0;
        int CIN = state.getPortValue(6) == Value.TRUE ? 1 : 0;
        byte sum = (byte)(A1 + A2 + A3 + A4 + B1 + B2 + B3 + B4 + CIN);
        Value output = Value.createKnown(BitWidth.create(5), (long)sum);
        state.setPort(3, output.get(0), 1);
        state.setPort(0, output.get(1), 1);
        state.setPort(11, output.get(2), 1);
        state.setPort(8, output.get(3), 1);
        state.setPort(7, output.get(4), 1);
    }
}

