/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.ttl;

import com.cburch.logisim.fpga.hdlgenerator.HdlGeneratorFactory;
import com.cburch.logisim.instance.InstancePainter;
import com.cburch.logisim.instance.InstanceState;
import com.cburch.logisim.std.ttl.AbstractGateHdlGenerator;
import com.cburch.logisim.std.ttl.AbstractTtlGate;
import com.cburch.logisim.std.ttl.Drawgates;
import com.cburch.logisim.util.LineBuffer;
import java.awt.Graphics;

public class Ttl7434
extends AbstractTtlGate {
    public static final String _ID = "7434";
    private static final byte pinCount = 14;
    private static final byte[] outPins = new byte[]{2, 4, 6, 8, 10, 12};

    public Ttl7434() {
        super(_ID, (byte)14, outPins, true, (HdlGeneratorFactory)new BufferGateHdlGeneratorFactory());
    }

    public Ttl7434(String name) {
        super(name, (byte)14, outPins, true, (HdlGeneratorFactory)new BufferGateHdlGeneratorFactory());
    }

    @Override
    public void paintInternal(InstancePainter painter, int x, int y, int height, boolean isUpOriented) {
        Graphics g = painter.getGraphics();
        int portWidth = 16;
        int portHeight = 6;
        int yOutput = y + (isUpOriented ? 20 : 40);
        Drawgates.paintBuffer(g, x + 30, yOutput, 16, 6);
        Drawgates.paintOutputgate(g, x + 30, y, x + 26, yOutput, isUpOriented, height);
        Drawgates.paintSingleInputgate(g, x + 10, y, x + 30 - 16, yOutput, isUpOriented, height);
    }

    @Override
    public void propagateTtl(InstanceState state) {
        int i;
        for (i = 1; i < 6; i = (int)((byte)(i + 2))) {
            state.setPort(i, state.getPortValue(i - 1), 1);
        }
        for (i = 6; i < 12; i = (int)((byte)(i + 2))) {
            state.setPort(i, state.getPortValue(i + 1), 1);
        }
    }

    private static class BufferGateHdlGeneratorFactory
    extends AbstractGateHdlGenerator {
        public BufferGateHdlGeneratorFactory() {
            super(true);
        }

        @Override
        public LineBuffer getLogicFunction(int index) {
            return LineBuffer.getHdlBuffer().add("{{assign}}gateO{{1}}{{=}}gateA{{1}};", index);
        }
    }
}

