/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.ttl;

import com.cburch.logisim.fpga.hdlgenerator.HdlGeneratorFactory;
import com.cburch.logisim.instance.InstancePainter;
import com.cburch.logisim.instance.InstanceState;
import com.cburch.logisim.std.ttl.AbstractGateHdlGenerator;
import com.cburch.logisim.std.ttl.AbstractTtlGate;
import com.cburch.logisim.std.ttl.Drawgates;
import com.cburch.logisim.util.LineBuffer;
import java.awt.Graphics;

public class Ttl747266
extends AbstractTtlGate {
    public static final String _ID = "747266";

    public Ttl747266() {
        super(_ID, (byte)14, new byte[]{3, 6, 8, 11}, true, (HdlGeneratorFactory)new XNorGateHdlGeneratorFactory());
    }

    @Override
    public void paintInternal(InstancePainter painter, int x, int y, int height, boolean up) {
        Graphics g = painter.getGraphics();
        int portwidth = 18;
        int portheight = 15;
        int youtput = y + (up ? 20 : 40);
        Drawgates.paintXor(g, x + 44, youtput, 14, 15, true);
        Drawgates.paintOutputgate(g, x + 50, y, x + 48, youtput, up, height);
        Drawgates.paintDoubleInputgate(g, x + 30, y, x + 44 - 18, youtput, 15, up, false, height);
    }

    @Override
    public void propagateTtl(InstanceState state) {
        int i;
        for (i = 2; i < 6; i = (int)((byte)(i + 3))) {
            state.setPort(i, state.getPortValue(i - 1).xor(state.getPortValue(i - 2)).not(), 1);
        }
        for (i = 6; i < 12; i = (int)((byte)(i + 3))) {
            state.setPort(i, state.getPortValue(i + 1).xor(state.getPortValue(i + 2)).not(), 1);
        }
    }

    private static class XNorGateHdlGeneratorFactory
    extends AbstractGateHdlGenerator {
        private XNorGateHdlGeneratorFactory() {
        }

        @Override
        public LineBuffer getLogicFunction(int index) {
            return LineBuffer.getHdlBuffer().add("{{assign}}gateO{{1}}{{=}}{{not}}(gateA{{1}}{{xor}}gateB{{1}});", index);
        }
    }
}

