/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.wiring;

import com.cburch.logisim.comp.Component;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.fpga.designrulecheck.Netlist;
import com.cburch.logisim.fpga.designrulecheck.netlistComponent;
import com.cburch.logisim.fpga.hdlgenerator.AbstractHdlGeneratorFactory;
import com.cburch.logisim.fpga.hdlgenerator.Hdl;
import com.cburch.logisim.std.wiring.Clock;
import com.cburch.logisim.util.LineBuffer;
import java.util.SortedMap;
import java.util.TreeMap;

public class ClockHdlGeneratorFactory
extends AbstractHdlGeneratorFactory {
    public static final int NR_OF_CLOCK_BITS = 5;
    public static final int DERIVED_CLOCK_INDEX = 0;
    public static final int INVERTED_DERIVED_CLOCK_INDEX = 1;
    public static final int POSITIVE_EDGE_TICK_INDEX = 2;
    public static final int NEGATIVE_EDGE_TICK_INDEX = 3;
    public static final int GLOBAL_CLOCK_INDEX = 4;
    private static final String HIGH_TICK_STR = "highTicks";
    private static final int HIGH_TICK_ID = -1;
    private static final String LOW_TICK_STR = "lowTicks";
    private static final int LOW_TICK_ID = -2;
    private static final String PHASE_STR = "phase";
    private static final int PHASE_ID = -3;
    private static final String NR_OF_BITS_STR = "nrOfBits";
    private static final int NR_OF_BITS_ID = -4;

    public ClockHdlGeneratorFactory() {
        super("base");
        this.myParametersList.add(HIGH_TICK_STR, -1, 6, Clock.ATTR_HIGH).add(LOW_TICK_STR, -2, 6, Clock.ATTR_LOW).add(PHASE_STR, -3, 6, Clock.ATTR_PHASE, 1).add(NR_OF_BITS_STR, -4, 5, Clock.ATTR_HIGH, Clock.ATTR_LOW);
        this.myWires.addWire("s_counterNext", -4).addWire("s_counterIsZero", 1).addRegister("s_outputRegs", 4).addRegister("s_bufferRegs", 2).addRegister("s_counterValue", -4).addRegister("s_derivedClock", -3);
        this.myPorts.add("input", "globalClock", 1, 0).add("input", "clockTick", 1, 1).add("output", "clockBus", 5, 2);
    }

    public SortedMap<String, String> getPortMap(Netlist nets, Object mapInfo) {
        TreeMap<String, String> map = new TreeMap<String, String>();
        if (!(mapInfo instanceof netlistComponent)) {
            return map;
        }
        netlistComponent componentInfo = (netlistComponent)mapInfo;
        map.put("globalClock", "fpgaGlobalClock");
        map.put("clockTick", "s_fpgaTick");
        map.put("clockBus", ClockHdlGeneratorFactory.getClockNetName(componentInfo.getComponent(), nets));
        return map;
    }

    private static String getClockNetName(Component comp, Netlist theNets) {
        StringBuilder contents = new StringBuilder();
        int clockNetId = theNets.getClockSourceId(comp);
        if (clockNetId >= 0) {
            contents.append("s_").append("logisimClockTree").append(clockNetId);
        }
        return contents.toString();
    }

    @Override
    public LineBuffer getModuleFunctionality(Netlist theNetlist, AttributeSet attrs) {
        LineBuffer contents = LineBuffer.getHdlBuffer().pair(PHASE_STR, PHASE_STR).pair(NR_OF_BITS_STR, NR_OF_BITS_STR).pair("lowTick", LOW_TICK_STR).pair("highTick", HIGH_TICK_STR).addRemarkBlock("The output signals are defined here; we synchronize them all on the main clock").empty();
        if (Hdl.isVhdl()) {
            contents.addVhdlKeywords().add("clockBus <= globalClock&s_outputRegs;\n\nmakeOutputs : {{process}}(globalClock) {{is}}\n{{begin}}\n   {{if}} (rising_edge(globalClock)) {{then}}\n      s_bufferRegs(0)  <= s_derivedClock({{phase}} - 1);\n      s_bufferRegs(1)  <= {{not}}(s_derivedClock({{phase}} - 1));\n      s_outputRegs(0)  <= s_bufferRegs(0);\n      s_outputRegs(1)  <= s_bufferRegs(1);\n      s_outputRegs(2)  <= {{not}}(s_bufferRegs(0)) {{and}} s_derivedClock({{phase}} - 1);\n      s_outputRegs(3)  <= s_bufferRegs(0) {{and}} {{not}}(s_derivedClock({{phase}} - 1));\n   {{end}} {{if}};\n{{end}} {{process}} makeOutputs;\n");
        } else {
            contents.add("assign clockBus = {globalClock,s_outputRegs};\nalways @(posedge globalClock)\nbegin\n   s_bufferRegs[0] <= s_derivedClock[{{phase}} - 1];\n   s_bufferRegs[1] <= ~s_derivedClock[{{phase}} - 1];\n   s_outputRegs[0] <= s_bufferRegs[0];\n   s_outputRegs[1] <= s_outputRegs[1];\n   s_outputRegs[2] <= ~s_bufferRegs[0] & s_derivedClock[{{phase}} - 1];\n   s_outputRegs[3] <= ~s_derivedClock[{{phase}} - 1] & s_bufferRegs[0];\nend\n");
        }
        contents.empty().addRemarkBlock("The control signals are defined here");
        if (Hdl.isVhdl()) {
            contents.add("s_counterIsZero <= '1' {{when}} s_counterValue = std_logic_vector(to_unsigned(0,{{nrOfBits}})) {{else}} '0';\ns_counterNext   <= std_logic_vector(unsigned(s_counterValue) - 1)\n                      {{when}} s_counterIsZero = '0' {{else}}\n                   std_logic_vector(to_unsigned(({{lowTick}}-1), {{nrOfBits}}))\n                      {{when}} s_derivedClock(0) = '1' {{else}}\n                   std_logic_vector(to_unsigned(({{highTick}}-1), {{nrOfBits}}));\n");
        } else {
            contents.add("assign s_counterIsZero = (s_counterValue == 0) ? 1'b1 : 1'b0;\nassign s_counterNext = (s_counterIsZero == 1'b0)\n                       ? s_counterValue - 1\n                       : (s_derivedClock[0] == 1'b1)\n                          ? {{lowTick}} - 1\n                          : {{highTick}} - 1;\n").empty().addRemarkBlock("The initial values are defined here (for simulation only)").add("initial\nbegin\n   s_outputRegs = 0;\n   s_derivedClock = 0;\n   s_counterValue = 0;\nend\n");
        }
        contents.empty().addRemarkBlock("The state registers are defined here");
        if (Hdl.isVhdl()) {
            contents.add("makeDerivedClock : {{process}}(globalClock, clockTick, s_counterIsZero, s_derivedClock) {{is}}\n{{begin}}\n   {{if}} (rising_edge(globalClock)) {{then}}\n      {{if}} (s_derivedClock(0) /= '0' {{and}} s_derivedClock(0) /= '1') {{then}} --For simulation only\n         s_derivedClock <= ({{others}} => '1');\n      {{elsif}} (clockTick = '1') {{then}}\n         {{for}} n IN {{phase}}-1 {{downto}} 1 {{loop}}\n           s_derivedClock(n) <= s_derivedClock(n-1);\n         {{end}} {{loop}};\n         s_derivedClock(0) <= s_derivedClock(0) {{xor}} s_counterIsZero;\n      {{end}} {{if}};\n   {{end}} {{if}};\n{{end}} {{process}} makeDerivedClock;\n\nmakeCounter : {{process}}(globalClock, clockTick, s_counterNext, s_derivedClock) {{is}}\n{{begin}}\n   {{if}} (rising_edge(globalClock)) {{then}}\n      {{if}} (s_derivedClock(0) /= '0' {{and}} s_derivedClock(0) /= '1') {{then}} --For simulation only\n         s_counterValue <= ({{others}} => '0');\n      {{elsif}} (clockTick = '1') {{then}}\n         s_counterValue <= s_counterNext;\n      {{end}} {{if}};\n   {{end}} {{if}};\n{{end}} {{process}} makeCounter;\n");
        } else {
            contents.add("integer n;\nalways @(posedge globalClock)\nbegin\n   if (clockTick)\n   begin\n      s_derivedClock[0] <= s_derivedClock[0] ^ s_counterIsZero;\n      for (n = 1; n < {{phase}}; n = n+1) begin\n         s_derivedClock[n] <= s_derivedClock[n-1];\n      end\n   end\nend\n\nalways @(posedge globalClock)\nbegin\n   if (clockTick)\n   begin\n      s_counterValue <= s_counterNext;\n   end\nend\n");
        }
        return contents.empty();
    }
}

