/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.wiring;

import com.cburch.logisim.circuit.RadixOption;
import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.AttributeOption;
import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.std.wiring.Pin;
import com.cburch.logisim.std.wiring.ProbeAttributes;
import java.util.ArrayList;
import java.util.List;

class PinAttributes
extends ProbeAttributes {
    public static final Attribute<String> ATTR_DUMMY = new DummyAttr("type");
    public static PinAttributes instance = new PinAttributes();
    private List<Attribute<?>> myAttributes;
    BitWidth width = BitWidth.ONE;
    boolean threeState = false;
    int type = 1;
    Object pull = Pin.PULL_NONE;
    Long initialValue = 0L;

    public PinAttributes() {
        this.updateAttributes();
    }

    private void updateAttributes() {
        this.myAttributes = new ArrayList();
        this.myAttributes.add(StdAttr.FACING);
        this.myAttributes.add(Pin.ATTR_TYPE);
        this.myAttributes.add(StdAttr.WIDTH);
        this.myAttributes.add(Pin.ATTR_TRISTATE);
        this.myAttributes.add(Pin.ATTR_PULL);
        this.myAttributes.add(StdAttr.LABEL);
        this.myAttributes.add(StdAttr.LABEL_FONT);
        this.myAttributes.add(RadixOption.ATTRIBUTE);
        if (this.type == 1 && !this.threeState) {
            this.myAttributes.add(Pin.ATTR_INITIAL);
        }
        this.myAttributes.add(PROBEAPPEARANCE);
        this.myAttributes.add(ATTR_DUMMY);
    }

    @Override
    public List<Attribute<?>> getAttributes() {
        return this.myAttributes;
    }

    @Override
    public boolean isToSave(Attribute<?> attr) {
        return attr.isToSave() && attr != ATTR_DUMMY;
    }

    @Override
    public <V> V getValue(Attribute<V> attr) {
        if (attr == StdAttr.WIDTH) {
            return (V)this.width;
        }
        if (attr == Pin.ATTR_TRISTATE) {
            return (V)Boolean.valueOf(this.threeState);
        }
        if (attr == Pin.ATTR_TYPE) {
            return (V)Boolean.valueOf(this.type == 2);
        }
        if (attr == Pin.ATTR_PULL) {
            return (V)this.pull;
        }
        if (attr == PROBEAPPEARANCE) {
            return (V)this.appearance;
        }
        if (attr == ATTR_DUMMY) {
            return (V)"nochange";
        }
        if (attr == Pin.ATTR_INITIAL) {
            return (V)this.initialValue;
        }
        return super.getValue(attr);
    }

    boolean isInput() {
        return this.type != 2;
    }

    boolean isOutput() {
        return this.type != 1;
    }

    @Override
    public <V> void setValue(Attribute<V> attr, V value) {
        if (attr == ATTR_DUMMY) {
            if (value.equals("output") && this.type != 2) {
                this.type = 2;
                this.fireAttributeValueChanged(Pin.ATTR_TYPE, this.type == 2, null);
                return;
            }
        } else if (attr == StdAttr.WIDTH) {
            BitWidth NewWidth = (BitWidth)value;
            if (this.width == NewWidth) {
                return;
            }
            this.width = (BitWidth)value;
            if (this.width.getWidth() > 8 && this.appearance == ProbeAttributes.APPEAR_EVOLUTION_NEW) {
                super.setValue(RadixOption.ATTRIBUTE, RadixOption.RADIX_16);
            }
        } else if (attr == Pin.ATTR_TRISTATE) {
            boolean NewThree = (Boolean)value;
            if (this.threeState == NewThree) {
                return;
            }
            this.threeState = NewThree;
            this.updateAttributes();
            this.fireAttributeListChanged();
        } else if (attr == Pin.ATTR_TYPE) {
            int Newtype;
            int n = Newtype = (Boolean)value != false ? 2 : 1;
            if (this.type == Newtype) {
                return;
            }
            this.type = Newtype;
            this.updateAttributes();
            this.fireAttributeListChanged();
        } else if (attr == Pin.ATTR_PULL) {
            if (this.pull.equals(value)) {
                return;
            }
            this.pull = value;
        } else if (attr == PROBEAPPEARANCE) {
            AttributeOption newAppearance = (AttributeOption)value;
            if (this.appearance.equals(newAppearance)) {
                return;
            }
            this.appearance = newAppearance;
        } else {
            if (attr == RadixOption.ATTRIBUTE) {
                if (this.width.getWidth() == 1) {
                    super.setValue(RadixOption.ATTRIBUTE, RadixOption.RADIX_2);
                } else {
                    super.setValue(attr, value);
                }
                return;
            }
            if (attr == Pin.ATTR_INITIAL) {
                Long newInitial = (Long)value;
                if (newInitial == this.initialValue) {
                    return;
                }
                this.initialValue = newInitial;
            } else {
                super.setValue(attr, value);
                return;
            }
        }
        this.fireAttributeValueChanged(attr, value, null);
    }

    private static class DummyAttr
    extends Attribute<String> {
        public DummyAttr(String name) {
            super(name, null);
        }

        @Override
        public String parse(String value) {
            return value;
        }

        @Override
        public boolean isHidden() {
            return true;
        }
    }
}

