/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.wiring;

import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.AttributeOption;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.data.Attributes;
import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Direction;
import com.cburch.logisim.data.Location;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.instance.Instance;
import com.cburch.logisim.instance.InstanceFactory;
import com.cburch.logisim.instance.InstancePainter;
import com.cburch.logisim.instance.InstanceState;
import com.cburch.logisim.instance.Port;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.std.Strings;
import com.cburch.logisim.tools.WireRepair;
import com.cburch.logisim.tools.key.BitWidthConfigurator;
import com.cburch.logisim.util.GraphicsUtil;
import com.cburch.logisim.util.IconsUtil;
import java.awt.Color;
import java.awt.Graphics2D;
import javax.swing.Icon;

public class Transistor
extends InstanceFactory {
    public static final String _ID = "Transistor";
    static final AttributeOption TYPE_P = new AttributeOption("p", Strings.S.getter("transistorTypeP"));
    static final AttributeOption TYPE_N = new AttributeOption("n", Strings.S.getter("transistorTypeN"));
    static final Attribute<AttributeOption> ATTR_TYPE = Attributes.forOption("type", Strings.S.getter("transistorTypeAttr"), new AttributeOption[]{TYPE_P, TYPE_N});
    static final int OUTPUT = 0;
    static final int INPUT = 1;
    static final int GATE = 2;
    private static final Icon ICON_N = IconsUtil.getIcon("trans1.gif");
    private static final Icon ICON_P = IconsUtil.getIcon("trans0.gif");

    public Transistor() {
        super(_ID, Strings.S.getter("transistorComponent"));
        this.setAttributes(new Attribute[]{ATTR_TYPE, StdAttr.FACING, StdAttr.SELECT_LOC, StdAttr.WIDTH}, new Object[]{TYPE_P, Direction.EAST, StdAttr.SELECT_TOP_RIGHT, BitWidth.ONE});
        this.setFacingAttribute(StdAttr.FACING);
        this.setKeyConfigurator(new BitWidthConfigurator(StdAttr.WIDTH));
    }

    private Value computeOutput(InstanceState state) {
        Value masked;
        BitWidth width = state.getAttributeValue(StdAttr.WIDTH);
        Value gate = state.getPortValue(2);
        Value input = state.getPortValue(1);
        AttributeOption type = state.getAttributeValue(ATTR_TYPE);
        Value desired = type == TYPE_P ? Value.FALSE : Value.TRUE;
        Value value = masked = type == TYPE_P ? Value.FALSE : Value.TRUE;
        if (!gate.isFullyDefined()) {
            if (input.isFullyDefined()) {
                return Value.createError(width);
            }
            Value[] v = input.getAll();
            for (int i = 0; i < v.length; ++i) {
                if (v[i] == Value.UNKNOWN) continue;
                v[i] = Value.ERROR;
            }
            return Value.create(v);
        }
        if (gate != desired) {
            return Value.createUnknown(width);
        }
        Value[] v = input.getAll();
        for (int i = 0; i < v.length; ++i) {
            if (v[i] != masked) continue;
            v[i] = Value.UNKNOWN;
        }
        return Value.create(v);
    }

    @Override
    protected void configureNewInstance(Instance instance) {
        instance.addAttributeListener();
        this.updatePorts(instance);
    }

    @Override
    public boolean contains(Location loc, AttributeSet attrs) {
        if (super.contains(loc, attrs)) {
            Direction facing = attrs.getValue(StdAttr.FACING);
            Location center = Location.create(0, 0, true).translate(facing, -20);
            return center.manhattanDistanceTo(loc) < 24;
        }
        return false;
    }

    private void drawInstance(InstancePainter painter, boolean isGhost) {
        Color platform;
        Color output;
        Color input;
        Color gate;
        AttributeOption type = painter.getAttributeValue(ATTR_TYPE);
        AttributeOption powerLoc = painter.getAttributeValue(StdAttr.SELECT_LOC);
        Direction from = painter.getAttributeValue(StdAttr.FACING);
        Direction facing = painter.getAttributeValue(StdAttr.FACING);
        boolean flip = (facing == Direction.NORTH || facing == Direction.WEST) == (powerLoc == StdAttr.SELECT_TOP_RIGHT);
        int degrees = Direction.EAST.toDegrees() - from.toDegrees();
        double radians = Math.toRadians((degrees + 360) % 360);
        int m = flip ? 1 : -1;
        Graphics2D g = (Graphics2D)painter.getGraphics();
        Location loc = painter.getLocation();
        g.translate(loc.getX(), loc.getY());
        g.rotate(radians);
        if (!isGhost && painter.getShowState()) {
            gate = painter.getPortValue(2).getColor();
            input = painter.getPortValue(1).getColor();
            output = painter.getPortValue(0).getColor();
            Value out = this.computeOutput(painter);
            platform = out.isUnknown() ? Value.UNKNOWN.getColor() : out.getColor();
        } else {
            Color base;
            gate = base = g.getColor();
            input = base;
            output = base;
            platform = base;
        }
        GraphicsUtil.switchToWidth(g, 3);
        g.setColor(output);
        g.drawLine(0, 0, -13, 0);
        g.drawLine(-13, m * 6, -13, 0);
        g.setColor(input);
        g.drawLine(-40, 0, -27, 0);
        g.drawLine(-27, m * 6, -27, 0);
        g.setColor(gate);
        if (type == TYPE_P) {
            g.drawLine(-20, m * 20, -20, m * 18);
            GraphicsUtil.switchToWidth(g, 2);
            g.drawOval(-23, m * 15 - 3, 6, 6);
        } else {
            g.drawLine(-20, m * 20, -20, m * 13);
            GraphicsUtil.switchToWidth(g, 2);
        }
        g.drawLine(-12, m * 12, -28, m * 12);
        g.setColor(platform);
        g.drawLine(-9, m * 7, -31, m * 7);
        GraphicsUtil.switchToWidth(g, 1);
        g.drawLine(-21, m * 4, -19, m * 2);
        g.drawLine(-21, 0, -19, m * 2);
        g.rotate(-radians);
        g.translate(-loc.getX(), -loc.getY());
    }

    @Override
    public Object getInstanceFeature(Instance instance, Object key) {
        if (key == WireRepair.class) {
            return data -> true;
        }
        return super.getInstanceFeature(instance, key);
    }

    @Override
    public Bounds getOffsetBounds(AttributeSet attrs) {
        int delta;
        Direction facing = attrs.getValue(StdAttr.FACING);
        AttributeOption gateLoc = attrs.getValue(StdAttr.SELECT_LOC);
        int n = delta = gateLoc == StdAttr.SELECT_TOP_RIGHT ? 20 : 0;
        if (facing == Direction.NORTH) {
            return Bounds.create(-20 + delta, 0, 20, 40);
        }
        if (facing == Direction.SOUTH) {
            return Bounds.create(-20 + delta, -40, 20, 40);
        }
        if (facing == Direction.WEST) {
            return Bounds.create(0, delta * -1, 40, 20);
        }
        return Bounds.create(-40, delta * -1, 40, 20);
    }

    @Override
    protected void instanceAttributeChanged(Instance instance, Attribute<?> attr) {
        if (attr == StdAttr.FACING || attr == StdAttr.SELECT_LOC) {
            instance.recomputeBounds();
            this.updatePorts(instance);
        } else if (attr == StdAttr.WIDTH) {
            this.updatePorts(instance);
        } else if (attr == ATTR_TYPE) {
            instance.fireInvalidated();
            this.updatePorts(instance);
        }
    }

    @Override
    public void paintGhost(InstancePainter painter) {
        this.drawInstance(painter, true);
    }

    @Override
    public void paintIcon(InstancePainter painter) {
        AttributeOption type = painter.getAttributeValue(ATTR_TYPE);
        Icon icon = type == TYPE_N ? ICON_N : ICON_P;
        icon.paintIcon(painter.getDestination(), painter.getGraphics(), 2, 2);
    }

    @Override
    public void paintInstance(InstancePainter painter) {
        this.drawInstance(painter, false);
    }

    @Override
    public void propagate(InstanceState state) {
        state.setPort(0, this.computeOutput(state), 1);
    }

    private void updatePorts(Instance instance) {
        Direction facing = instance.getAttributeValue(StdAttr.FACING);
        int dx = 0;
        int dy = 0;
        if (facing == Direction.NORTH) {
            dy = 1;
        } else if (facing == Direction.EAST) {
            dx = -1;
        } else if (facing == Direction.SOUTH) {
            dy = -1;
        } else if (facing == Direction.WEST) {
            dx = 1;
        }
        AttributeOption powerLoc = instance.getAttributeValue(StdAttr.SELECT_LOC);
        boolean flip = (facing == Direction.NORTH || facing == Direction.WEST) == (powerLoc == StdAttr.SELECT_TOP_RIGHT);
        Port[] ports = new Port[]{new Port(0, 0, "output", StdAttr.WIDTH), new Port(40 * dx, 40 * dy, "input", StdAttr.WIDTH), flip ? new Port(20 * (dx + dy), 20 * (-dx + dy), "input", 1) : new Port(20 * (dx - dy), 20 * (dx + dy), "input", 1)};
        if (instance.getAttributeValue(ATTR_TYPE) == TYPE_P) {
            ports[2].setToolTip(Strings.S.getter("transistorPGate"));
            ports[1].setToolTip(Strings.S.getter("transistorPSource"));
            ports[0].setToolTip(Strings.S.getter("transistorPDrain"));
        } else {
            ports[2].setToolTip(Strings.S.getter("transistorNGate"));
            ports[1].setToolTip(Strings.S.getter("transistorNSource"));
            ports[0].setToolTip(Strings.S.getter("transistorNDrain"));
        }
        instance.setPorts(ports);
    }
}

