/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.tools;

import com.cburch.logisim.LogisimVersion;
import com.cburch.logisim.circuit.Circuit;
import com.cburch.logisim.circuit.CircuitEvent;
import com.cburch.logisim.circuit.CircuitListener;
import com.cburch.logisim.circuit.Wire;
import com.cburch.logisim.comp.Component;
import com.cburch.logisim.comp.ComponentDrawContext;
import com.cburch.logisim.comp.ComponentFactory;
import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.data.Direction;
import com.cburch.logisim.data.Location;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.gui.main.Canvas;
import com.cburch.logisim.gui.main.Selection;
import com.cburch.logisim.gui.main.SelectionActions;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.proj.Action;
import com.cburch.logisim.tools.SelectTool;
import com.cburch.logisim.tools.SetAttributeAction;
import com.cburch.logisim.tools.Strings;
import com.cburch.logisim.tools.Tool;
import com.cburch.logisim.tools.WiringTool;
import com.cburch.logisim.util.CollectionUtil;
import com.cburch.logisim.util.GraphicsUtil;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Set;

public class EditTool
extends Tool {
    public static final String _ID = "Edit Tool";
    private static final int CACHE_MAX_SIZE = 32;
    private static final Location NULL_LOCATION = Location.create(Integer.MIN_VALUE, Integer.MIN_VALUE, false);
    private final Listener listener = new Listener();
    private final SelectTool select;
    private final WiringTool wiring;
    private Tool current;
    private final LinkedHashMap<Location, Boolean> cache;
    private Canvas lastCanvas;
    private int lastRawX;
    private int lastRawY;
    private int lastX;
    private int lastY;
    private int lastMods;
    private Location wireLoc;
    private int pressX;
    private int pressY;

    public EditTool(SelectTool select, WiringTool wiring) {
        this.select = select;
        this.wiring = wiring;
        this.current = select;
        this.cache = new LinkedHashMap();
        this.lastX = -1;
        this.wireLoc = NULL_LOCATION;
        this.pressX = -1;
    }

    private void attemptRotate(Canvas canvas, KeyEvent e) {
        Circuit circuit = canvas.getCircuit();
        Selection sel = canvas.getSelection();
        SetAttributeAction act = new SetAttributeAction(circuit, Strings.S.getter("selectionRefaceAction"));
        for (Component comp : sel.getComponents()) {
            if (comp instanceof Wire) continue;
            Attribute<Direction> attr = this.getFacingAttribute(comp);
            Direction d = comp.getAttributeSet().getValue(StdAttr.FACING);
            if (d == null) continue;
            d = d.getRight();
            if (attr == null) continue;
            act.set(comp, attr, d);
        }
        if (!act.isEmpty()) {
            canvas.getProject().doAction(act);
            e.consume();
        }
    }

    private void attemptReface(Canvas canvas, Direction facing, KeyEvent e) {
        if (e.getModifiersEx() == 0) {
            Circuit circuit = canvas.getCircuit();
            Selection sel = canvas.getSelection();
            SetAttributeAction act = new SetAttributeAction(circuit, Strings.S.getter("selectionRefaceAction"));
            for (Component comp : sel.getComponents()) {
                Attribute<Direction> attr;
                if (comp instanceof Wire || (attr = this.getFacingAttribute(comp)) == null) continue;
                act.set(comp, attr, facing);
            }
            if (!act.isEmpty()) {
                canvas.getProject().doAction(act);
                e.consume();
            }
        }
    }

    @Override
    public void deselect(Canvas canvas) {
        this.current = this.select;
        canvas.getSelection().setSuppressHandles((Collection)null);
        this.cache.clear();
        Circuit circ = canvas.getCircuit();
        if (circ != null) {
            circ.removeCircuitListener(this.listener);
        }
        canvas.getSelection().removeListener(this.listener);
    }

    @Override
    public void draw(Canvas canvas, ComponentDrawContext context) {
        Location loc = this.wireLoc;
        if (loc != NULL_LOCATION && this.current != this.wiring) {
            int x = loc.getX();
            int y = loc.getY();
            Graphics g = context.getGraphics();
            g.setColor(Value.trueColor);
            GraphicsUtil.switchToWidth(g, 2);
            g.drawOval(x - 5, y - 5, 10, 10);
            g.setColor(Color.BLACK);
            GraphicsUtil.switchToWidth(g, 1);
        }
        this.current.draw(canvas, context);
    }

    public boolean equals(Object other) {
        return other instanceof EditTool;
    }

    @Override
    public AttributeSet getAttributeSet() {
        return this.select.getAttributeSet();
    }

    @Override
    public AttributeSet getAttributeSet(Canvas canvas) {
        return canvas.getSelection().getAttributeSet();
    }

    @Override
    public Cursor getCursor() {
        return this.select.getCursor();
    }

    @Override
    public String getDescription() {
        return Strings.S.get("editToolDesc");
    }

    @Override
    public String getDisplayName() {
        return Strings.S.get("editTool");
    }

    private Attribute<Direction> getFacingAttribute(Component comp) {
        Attribute a;
        AttributeSet attrs = comp.getAttributeSet();
        Object key = ComponentFactory.FACING_ATTRIBUTE_KEY;
        Attribute ret = a = (Attribute)comp.getFactory().getFeature(key, attrs);
        return ret;
    }

    @Override
    public Set<Component> getHiddenComponents(Canvas canvas) {
        return this.current.getHiddenComponents(canvas);
    }

    public int hashCode() {
        return EditTool.class.hashCode();
    }

    @Override
    public boolean isAllDefaultValues(AttributeSet attrs, LogisimVersion ver) {
        return true;
    }

    private boolean isClick(MouseEvent e) {
        int dy;
        int px = this.pressX;
        if (px < 0) {
            return false;
        }
        int dx = e.getX() - px;
        if (dx * dx + (dy = e.getY() - this.pressY) * dy <= 4) {
            return true;
        }
        this.pressX = -1;
        return false;
    }

    private boolean isWiringPoint(Canvas canvas, Location loc, int modsEx) {
        Circuit circ;
        Set<Component> sel;
        boolean select;
        boolean wiring = (modsEx & 0x200) == 0;
        boolean bl = select = !wiring;
        if (canvas != null && canvas.getSelection() != null && (sel = canvas.getSelection().getComponents()) != null) {
            for (Component c : sel) {
                Wire w;
                if (!(c instanceof Wire) || !(w = (Wire)c).contains(loc) || w.endsAt(loc)) continue;
                return select;
            }
        }
        if ((circ = canvas.getCircuit()) == null) {
            return false;
        }
        Collection<? extends Component> at = circ.getComponents(loc);
        if (CollectionUtil.isNotEmpty(at)) {
            return wiring;
        }
        for (Wire w : circ.getWires()) {
            if (!w.contains(loc)) continue;
            return wiring;
        }
        return select;
    }

    @Override
    public void keyPressed(Canvas canvas, KeyEvent e) {
        switch (e.getKeyCode()) {
            case 8: 
            case 127: {
                if (!canvas.getSelection().isEmpty()) {
                    Action act = SelectionActions.clear(canvas.getSelection());
                    canvas.getProject().doAction(act);
                    e.consume();
                    break;
                }
                this.wiring.keyPressed(canvas, e);
                break;
            }
            case 155: {
                Action act = SelectionActions.duplicate(canvas.getSelection());
                canvas.getProject().doAction(act);
                e.consume();
                break;
            }
            case 38: {
                if (e.getModifiersEx() == 0) {
                    this.attemptReface(canvas, Direction.NORTH, e);
                    break;
                }
                this.select.keyPressed(canvas, e);
                break;
            }
            case 40: {
                if (e.getModifiersEx() == 0) {
                    this.attemptReface(canvas, Direction.SOUTH, e);
                    break;
                }
                this.select.keyPressed(canvas, e);
                break;
            }
            case 37: {
                if (e.getModifiersEx() == 0) {
                    this.attemptReface(canvas, Direction.WEST, e);
                    break;
                }
                this.select.keyPressed(canvas, e);
                break;
            }
            case 39: {
                if (e.getModifiersEx() == 0) {
                    this.attemptReface(canvas, Direction.EAST, e);
                    break;
                }
                this.select.keyPressed(canvas, e);
                break;
            }
            case 18: {
                this.updateLocation(canvas, e);
                e.consume();
                break;
            }
            case 32: {
                if ((e.getModifiersEx() & 0x80) == 128) {
                    this.attemptRotate(canvas, e);
                    break;
                }
                this.select.keyPressed(canvas, e);
                break;
            }
            default: {
                this.select.keyPressed(canvas, e);
            }
        }
    }

    @Override
    public void keyReleased(Canvas canvas, KeyEvent e) {
        if (e.getKeyCode() == 18) {
            this.updateLocation(canvas, e);
            e.consume();
        } else {
            this.select.keyReleased(canvas, e);
        }
    }

    @Override
    public void keyTyped(Canvas canvas, KeyEvent e) {
        this.select.keyTyped(canvas, e);
    }

    @Override
    public void mouseDragged(Canvas canvas, Graphics g, MouseEvent e) {
        this.isClick(e);
        this.current.mouseDragged(canvas, g, e);
    }

    @Override
    public void mouseEntered(Canvas canvas, Graphics g, MouseEvent e) {
        this.pressX = -1;
        this.current.mouseEntered(canvas, g, e);
    }

    @Override
    public void mouseExited(Canvas canvas, Graphics g, MouseEvent e) {
        this.pressX = -1;
        this.current.mouseExited(canvas, g, e);
    }

    @Override
    public void mouseMoved(Canvas canvas, Graphics g, MouseEvent e) {
        this.updateLocation(canvas, e);
        this.select.mouseMoved(canvas, g, e);
    }

    @Override
    public void mousePressed(Canvas canvas, Graphics g, MouseEvent e) {
        canvas.requestFocusInWindow();
        boolean wire = this.updateLocation(canvas, e);
        Location oldWireLoc = this.wireLoc;
        this.wireLoc = NULL_LOCATION;
        this.lastX = Integer.MIN_VALUE;
        if (wire) {
            this.current = this.wiring;
            Selection sel = canvas.getSelection();
            Circuit circ = canvas.getCircuit();
            Collection<Component> selected = sel.getAnchoredComponents();
            ArrayList<Wire> suppress = null;
            for (Wire w : circ.getWires()) {
                if (!selected.contains(w) || !w.contains(oldWireLoc)) continue;
                if (suppress == null) {
                    suppress = new ArrayList<Wire>();
                }
                suppress.add(w);
            }
            sel.setSuppressHandles(suppress);
        } else {
            this.current = this.select;
        }
        this.pressX = e.getX();
        this.pressY = e.getY();
        this.current.mousePressed(canvas, g, e);
    }

    @Override
    public void mouseReleased(Canvas canvas, Graphics g, MouseEvent e) {
        boolean click = this.isClick(e) && this.current == this.wiring;
        canvas.getSelection().setSuppressHandles((Collection)null);
        this.current.mouseReleased(canvas, g, e);
        if (click) {
            this.wiring.resetClick();
            this.select.mousePressed(canvas, g, e);
            this.select.mouseReleased(canvas, g, e);
        }
        this.current = this.select;
        this.cache.clear();
        this.updateLocation(canvas, e);
    }

    @Override
    public void paintIcon(ComponentDrawContext c, int x, int y) {
        this.select.paintIcon(c, x, y);
    }

    @Override
    public void select(Canvas canvas) {
        this.current = this.select;
        this.lastCanvas = canvas;
        this.cache.clear();
        Circuit circ = canvas.getCircuit();
        if (circ != null) {
            circ.addCircuitListener(this.listener);
        }
        canvas.getSelection().addListener(this.listener);
        this.select.select(canvas);
    }

    @Override
    public void setAttributeSet(AttributeSet attrs) {
        this.select.setAttributeSet(attrs);
    }

    private boolean updateLocation(Canvas canvas, int mx, int my, int mods) {
        int snapy;
        int dy;
        boolean isEligible;
        int snapx = Canvas.snapXToGrid(mx);
        int dx = mx - snapx;
        boolean bl = isEligible = dx * dx + (dy = my - (snapy = Canvas.snapYToGrid(my))) * dy < 36;
        if ((mods & 0x200) != 0) {
            isEligible = true;
        }
        if (!isEligible) {
            snapx = -1;
            snapy = -1;
        }
        boolean modsSame = this.lastMods == mods;
        this.lastCanvas = canvas;
        this.lastRawX = mx;
        this.lastRawY = my;
        this.lastMods = mods;
        if (this.lastX == snapx && this.lastY == snapy && modsSame) {
            return this.wireLoc != NULL_LOCATION;
        }
        Location snap = Location.create(snapx, snapy, false);
        if (modsSame) {
            Boolean o = this.cache.get(snap);
            if (o != null) {
                this.lastX = snapx;
                this.lastY = snapy;
                Location oldWireLoc = this.wireLoc;
                boolean ret = o;
                this.wireLoc = ret ? snap : NULL_LOCATION;
                this.repaintIndicators(canvas, oldWireLoc, this.wireLoc);
                return ret;
            }
        } else {
            this.cache.clear();
        }
        Location oldWireLoc = this.wireLoc;
        boolean ret = isEligible && this.isWiringPoint(canvas, snap, mods);
        this.wireLoc = ret ? snap : NULL_LOCATION;
        this.cache.put(snap, ret);
        Iterator<Location> it = this.cache.keySet().iterator();
        for (int toRemove = this.cache.size() - 32; it.hasNext() && toRemove > 0; --toRemove) {
            it.next();
            it.remove();
        }
        this.lastX = snapx;
        this.lastY = snapy;
        this.repaintIndicators(canvas, oldWireLoc, this.wireLoc);
        return ret;
    }

    private void repaintIndicators(Canvas canvas, Location a, Location b) {
        if (a.equals(b)) {
            return;
        }
        if (a != NULL_LOCATION) {
            canvas.repaint(a.getX() - 6, a.getY() - 6, 12, 12);
        }
        if (b != NULL_LOCATION) {
            canvas.repaint(b.getX() - 6, b.getY() - 6, 12, 12);
        }
    }

    private boolean updateLocation(Canvas canvas, KeyEvent e) {
        int x = this.lastRawX;
        if (x >= 0) {
            return this.updateLocation(canvas, x, this.lastRawY, e.getModifiersEx());
        }
        return false;
    }

    private boolean updateLocation(Canvas canvas, MouseEvent e) {
        return this.updateLocation(canvas, e.getX(), e.getY(), e.getModifiersEx());
    }

    private class Listener
    implements CircuitListener,
    Selection.Listener {
        private Listener() {
        }

        @Override
        public void circuitChanged(CircuitEvent event) {
            if (event.getAction() != 4) {
                EditTool.this.lastX = -1;
                EditTool.this.cache.clear();
                EditTool.this.updateLocation(EditTool.this.lastCanvas, EditTool.this.lastRawX, EditTool.this.lastRawY, EditTool.this.lastMods);
            }
        }

        @Override
        public void selectionChanged(Selection.Event event) {
            EditTool.this.lastX = -1;
            EditTool.this.cache.clear();
            EditTool.this.updateLocation(EditTool.this.lastCanvas, EditTool.this.lastRawX, EditTool.this.lastRawY, EditTool.this.lastMods);
        }
    }
}

