/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.tools;

import com.cburch.logisim.gui.generic.OptionPane;
import com.cburch.logisim.tools.MatrixPlacerInfo;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class MatrixPlacerDialog
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private final MatrixPlacerInfo matrixInfo;
    private final JComboBox<Integer> copiesX = new JComboBox();
    private final JComboBox<Integer> copiesY = new JComboBox();
    private final JComboBox<Integer> distanceX = new JComboBox();
    private final JComboBox<Integer> distanceY = new JComboBox();
    private final JTextField labelField = new JTextField();
    private final String compName;

    public MatrixPlacerDialog(MatrixPlacerInfo value, String name, boolean isAutoLabelerActive) {
        int i;
        this.compName = name;
        this.matrixInfo = value;
        GridBagLayout thisLayout = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        this.setLayout(thisLayout);
        c.fill = 1;
        c.anchor = 10;
        c.weightx = 1.0;
        c.weighty = 1.0;
        if (this.matrixInfo.getLabel() != null && isAutoLabelerActive) {
            c.gridx = 0;
            c.gridy = 0;
            c.gridwidth = 4;
            this.add((Component)new JLabel("Base Label:"), c);
            c.gridx = 4;
            c.gridwidth = 7;
            this.labelField.setText(this.matrixInfo.getLabel());
            this.labelField.setEditable(true);
            this.add((Component)this.labelField, c);
            c.gridwidth = 1;
        }
        for (int x = 4; x < 11; ++x) {
            for (int y = 5; y < 12; ++y) {
                c.gridx = x;
                c.gridy = y;
                String symbol = !(x != 4 && x != 7 && x != 10 || y != 5 && y != 8 && y != 11) ? "O" : ".";
                String spacer = " ".repeat(3);
                JLabel compText = new JLabel(spacer + symbol + spacer);
                this.add((Component)compText, c);
            }
        }
        c.gridy = 1;
        c.gridx = 4;
        this.add((Component)new JLabel("    <--"), c);
        c.gridx = 10;
        this.add((Component)new JLabel("-->    "), c);
        c.gridx = 5;
        c.gridwidth = 3;
        this.add((Component)new JLabel("NrOfColums:"), c);
        c.gridx = 8;
        c.gridy = 1;
        c.gridwidth = 2;
        for (i = 1; i < 50; ++i) {
            this.copiesX.addItem(i);
        }
        this.copiesX.setSelectedItem(1);
        this.copiesX.addActionListener(this);
        this.add(this.copiesX, c);
        c.gridy = 2;
        c.gridwidth = 1;
        c.gridx = 4;
        this.add((Component)new JLabel("    <--"), c);
        c.gridx = 7;
        this.add((Component)new JLabel("-->    "), c);
        c.gridx = 5;
        this.add((Component)new JLabel("dx:"), c);
        c.gridx = 6;
        for (i = this.matrixInfo.getMinimalDisplacementX(); i < 100; ++i) {
            this.distanceX.addItem(i);
        }
        this.distanceX.setSelectedIndex(0);
        this.distanceX.addActionListener(this);
        this.add(this.distanceX, c);
        for (int y = 5; y < 12; ++y) {
            c.gridy = y;
            if (y == 5) {
                c.gridx = 3;
                this.add((Component)new JLabel("   ^   "), c);
                c.gridx = 2;
                this.add((Component)new JLabel("   ^   "), c);
                continue;
            }
            if (y == 11) {
                c.gridx = 3;
                this.add((Component)new JLabel("   _   "), c);
                c.gridx = 2;
                c.gridy = 8;
                this.add((Component)new JLabel("   _   "), c);
                continue;
            }
            c.gridx = 3;
            this.add((Component)new JLabel("   |   "), c);
            if (y >= 8) continue;
            c.gridx = 2;
            this.add((Component)new JLabel("   |   "), c);
        }
        c.gridx = 2;
        c.gridy = 10;
        for (i = 1; i < 50; ++i) {
            this.copiesY.addItem(i);
        }
        this.copiesY.setSelectedIndex(0);
        this.copiesY.addActionListener(this);
        this.add(this.copiesY, c);
        c.gridx = 0;
        c.gridwidth = 2;
        this.add((Component)new JLabel("NrOfRows:"), c);
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 6;
        this.add((Component)new JLabel("dy:"), c);
        c.gridx = 1;
        for (i = this.matrixInfo.getMinimalDisplacementY(); i < 100; ++i) {
            this.distanceY.addItem(i);
        }
        this.distanceY.setSelectedIndex(0);
        this.distanceY.addActionListener(this);
        this.add(this.distanceY, c);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.matrixInfo == null) {
            return;
        }
        if (e.getSource() == this.copiesX) {
            this.matrixInfo.setCopiesCountX((Integer)this.copiesX.getSelectedItem());
        } else if (e.getSource() == this.distanceX) {
            this.matrixInfo.setDisplacementX((Integer)this.distanceX.getSelectedItem());
        } else if (e.getSource() == this.copiesY) {
            this.matrixInfo.setCopiesCountY((Integer)this.copiesY.getSelectedItem());
        } else if (e.getSource() == this.distanceY) {
            this.matrixInfo.setDisplacementY((Integer)this.distanceY.getSelectedItem());
        }
    }

    public boolean execute() {
        this.labelField.setText(this.matrixInfo.getLabel());
        boolean ret = OptionPane.showOptionDialog(null, this, "Matrix Place component \"" + this.compName + "\"", 2, -1, null, null, null) == 0;
        this.matrixInfo.setLabel(this.labelField.getText());
        return ret;
    }
}

