/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.tools;

import com.cburch.logisim.circuit.Circuit;
import com.cburch.logisim.circuit.CircuitEvent;
import com.cburch.logisim.circuit.CircuitListener;
import com.cburch.logisim.circuit.RadixOption;
import com.cburch.logisim.circuit.Wire;
import com.cburch.logisim.circuit.WireSet;
import com.cburch.logisim.comp.Component;
import com.cburch.logisim.comp.ComponentDrawContext;
import com.cburch.logisim.comp.ComponentUserEvent;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.data.Location;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.gui.main.Canvas;
import com.cburch.logisim.prefs.AppPreferences;
import com.cburch.logisim.proj.Project;
import com.cburch.logisim.tools.AbstractCaret;
import com.cburch.logisim.tools.Caret;
import com.cburch.logisim.tools.Pokable;
import com.cburch.logisim.tools.Strings;
import com.cburch.logisim.tools.Tool;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.GeneralPath;

public class PokeTool
extends Tool {
    public static final String _ID = "Poke Tool";
    private static final Color caretColor = new Color(255, 255, 150);
    private static final Cursor cursor = Cursor.getPredefinedCursor(12);
    private static final Cursor move = Cursor.getPredefinedCursor(13);
    private final Listener listener = new Listener();
    private Circuit pokedCircuit;
    private Component pokedComponent;
    private Caret pokeCaret;
    private Point oldPosition;

    @Override
    public void deselect(Canvas canvas) {
        this.removeCaret(true);
        canvas.setHighlightedWires(WireSet.EMPTY);
    }

    @Override
    public void draw(Canvas canvas, ComponentDrawContext context) {
        if (this.pokeCaret != null) {
            this.pokeCaret.draw(context.getGraphics());
        }
    }

    public boolean equals(Object other) {
        return other instanceof PokeTool;
    }

    @Override
    public Cursor getCursor() {
        return cursor;
    }

    @Override
    public String getDescription() {
        return Strings.S.get("pokeToolDesc");
    }

    @Override
    public String getDisplayName() {
        return Strings.S.get("pokeTool");
    }

    public int hashCode() {
        return PokeTool.class.hashCode();
    }

    @Override
    public void keyPressed(Canvas canvas, KeyEvent e) {
        if (this.pokeCaret != null) {
            this.pokeCaret.keyPressed(e);
            canvas.getProject().repaintCanvas();
        }
    }

    @Override
    public void keyReleased(Canvas canvas, KeyEvent e) {
        if (this.pokeCaret != null) {
            this.pokeCaret.keyReleased(e);
            canvas.getProject().repaintCanvas();
        }
    }

    @Override
    public void keyTyped(Canvas canvas, KeyEvent e) {
        if (this.pokeCaret != null) {
            this.pokeCaret.keyTyped(e);
            canvas.getProject().repaintCanvas();
        }
    }

    @Override
    public void mouseDragged(Canvas canvas, Graphics g, MouseEvent e) {
        if (this.pokeCaret != null) {
            this.pokeCaret.mouseDragged(e);
            canvas.getProject().repaintCanvas();
        } else {
            Point m = canvas.getMousePosition();
            if (this.oldPosition == null || m == null) {
                this.oldPosition = m;
                return;
            }
            int x = (int)(this.oldPosition.getX() - m.getX());
            int y = (int)(this.oldPosition.getY() - m.getY());
            canvas.setCursor(move);
            canvas.setScrollBar(canvas.getHorizontalScrollBar() + x, canvas.getVerticalScrollBar() + y);
        }
    }

    @Override
    public void mousePressed(Canvas canvas, Graphics g, MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        Location loc = Location.create(x, y, false);
        boolean dirty = false;
        canvas.setHighlightedWires(WireSet.EMPTY);
        if (this.pokeCaret != null && !this.pokeCaret.getBounds(g).contains(loc)) {
            dirty = true;
            this.removeCaret(true);
        }
        if (this.pokeCaret == null) {
            ComponentUserEvent event = new ComponentUserEvent(canvas, x, y);
            Circuit circ = canvas.getCircuit();
            for (Component c : circ.getAllContaining(loc, g)) {
                if (this.pokeCaret != null) break;
                if (c instanceof Wire) {
                    Wire wire = (Wire)c;
                    WireCaret caret = new WireCaret(canvas, wire, x, y, canvas.getProject().getOptions().getAttributeSet());
                    this.setPokedComponent(circ, c, caret);
                    canvas.setHighlightedWires(circ.getWireSet((Wire)c));
                    continue;
                }
                Pokable p = (Pokable)c.getFeature(Pokable.class);
                if (p == null) continue;
                Caret caret = p.getPokeCaret(event);
                this.setPokedComponent(circ, c, caret);
                AttributeSet attrs = c.getAttributeSet();
                if (attrs == null || attrs.getAttributes().isEmpty()) continue;
                Project proj = canvas.getProject();
                proj.getFrame().viewComponentAttributes(circ, c);
            }
        }
        if (this.pokeCaret != null) {
            dirty = true;
            this.pokeCaret.mousePressed(e);
        }
        if (dirty) {
            canvas.getProject().repaintCanvas();
        }
    }

    @Override
    public void mouseReleased(Canvas canvas, Graphics g, MouseEvent e) {
        this.oldPosition = null;
        if (this.pokeCaret != null) {
            this.pokeCaret.mouseReleased(e);
            canvas.getProject().repaintCanvas();
        }
    }

    @Override
    public void paintIcon(ComponentDrawContext c, int x, int y) {
        Graphics2D g2 = (Graphics2D)c.getGraphics().create();
        g2.translate(x, y);
        g2.setStroke(new BasicStroke(AppPreferences.getScaled(1)));
        GeneralPath p = new GeneralPath();
        p.moveTo(PokeTool.scale(6.0), PokeTool.scale(15.0));
        p.quadTo(PokeTool.scale(5.0), PokeTool.scale(10.0), PokeTool.scale(1.0), PokeTool.scale(7.0));
        p.quadTo(PokeTool.scale(2.5), PokeTool.scale(4.0), PokeTool.scale(4.0), PokeTool.scale(7.0));
        p.quadTo(PokeTool.scale(6.0), PokeTool.scale(6.0), PokeTool.scale(6.0), PokeTool.scale(10.0));
        p.lineTo(PokeTool.scale(6.0), PokeTool.scale(1.0));
        p.quadTo(PokeTool.scale(7.0), PokeTool.scale(-1.0), PokeTool.scale(8.0), PokeTool.scale(1.0));
        p.lineTo(PokeTool.scale(8.0), PokeTool.scale(8.0));
        p.quadTo(PokeTool.scale(9.0), PokeTool.scale(2.0), PokeTool.scale(10.0), PokeTool.scale(8.0));
        p.quadTo(PokeTool.scale(11.0), PokeTool.scale(2.0), PokeTool.scale(12.0), PokeTool.scale(8.0));
        p.lineTo(PokeTool.scale(12.0), PokeTool.scale(9.0));
        p.quadTo(PokeTool.scale(13.0), PokeTool.scale(4.0), PokeTool.scale(14.0), PokeTool.scale(9.0));
        p.quadTo(PokeTool.scale(12.0), PokeTool.scale(11.0), PokeTool.scale(13.0), PokeTool.scale(15.0));
        g2.setColor(new Color(240, 184, 160));
        g2.fill(p);
        g2.setColor(Color.BLACK);
        g2.draw(p);
        g2.dispose();
    }

    private static double scale(double s) {
        return AppPreferences.getScaled(s);
    }

    private void removeCaret(boolean normal) {
        Caret caret = this.pokeCaret;
        if (caret != null) {
            Circuit circ = this.pokedCircuit;
            if (normal) {
                caret.stopEditing();
            } else {
                caret.cancelEditing();
            }
            circ.removeCircuitListener(this.listener);
            this.pokedCircuit = null;
            this.pokedComponent = null;
            this.pokeCaret = null;
        }
    }

    private void setPokedComponent(Circuit circ, Component comp, Caret caret) {
        this.removeCaret(true);
        this.pokedCircuit = circ;
        this.pokedComponent = comp;
        this.pokeCaret = caret;
        if (caret != null) {
            circ.addCircuitListener(this.listener);
        }
    }

    public boolean isScrollable() {
        return this.pokeCaret != null && !(this.pokeCaret instanceof WireCaret);
    }

    private class Listener
    implements CircuitListener {
        private Listener() {
        }

        @Override
        public void circuitChanged(CircuitEvent event) {
            Circuit circ = PokeTool.this.pokedCircuit;
            if (!(event.getCircuit() != circ || circ == null || event.getAction() != 2 && event.getAction() != 5 || circ.contains(PokeTool.this.pokedComponent))) {
                PokeTool.this.removeCaret(false);
            }
        }
    }

    private static class WireCaret
    extends AbstractCaret {
        final Canvas canvas;
        final Wire wire;
        final int x;
        final int y;

        WireCaret(Canvas canvas, Wire wire, int x, int y, AttributeSet opts) {
            this.canvas = canvas;
            this.wire = wire;
            this.x = x;
            this.y = y;
        }

        @Override
        public void draw(Graphics g) {
            int dxx2;
            Value v = this.canvas.getCircuitState().getValue(this.wire.getEnd0());
            RadixOption radix1 = RadixOption.decode(AppPreferences.POKE_WIRE_RADIX1.get());
            RadixOption radix2 = RadixOption.decode(AppPreferences.POKE_WIRE_RADIX2.get());
            if (radix1 == null) {
                radix1 = RadixOption.RADIX_2;
            }
            Object vStr = radix1.toString(v);
            if (radix2 != null && v.getWidth() > 1) {
                vStr = (String)vStr + " / " + radix2.toString(v);
            }
            if (v.getWidth() == 32 || v.getWidth() == 64) {
                vStr = (String)vStr + " / " + RadixOption.RADIX_FLOAT.toString(v);
            }
            FontMetrics fm = g.getFontMetrics();
            g.setColor(caretColor);
            int margin = 2;
            int width = fm.stringWidth((String)vStr) + 2 * margin;
            int pad = 0;
            if (width < 45) {
                pad = (45 - width) / 2;
                width = 45;
            }
            int h = fm.getAscent() + fm.getDescent() + 2 * margin;
            Rectangle rect = this.canvas.getViewableRect();
            int dx = Math.max(0, width - (rect.x + rect.width - this.x));
            int dxx1 = dx > width / 2 ? -30 : 15;
            int n = dxx2 = dx > width / 2 ? -15 : 30;
            if (this.y - 15 - h <= rect.y) {
                int xx = this.x - dx;
                int yy = this.y + 15 + h;
                int[] xp = new int[]{xx, xx, this.x + dxx1, this.x, this.x + dxx2, xx + width, this.x + width};
                int[] yp = new int[]{yy, yy - h, yy - h, this.y, yy - h, yy - h, yy};
                g.fillPolygon(xp, yp, xp.length);
                g.setColor(Color.BLACK);
                g.drawPolygon(xp, yp, xp.length);
                g.drawString((String)vStr, xx + margin + pad, yy - margin - fm.getDescent());
            } else {
                int xx = this.x - dx;
                int yy = this.y - 15;
                int[] xp = new int[]{xx, xx, xx + width, xx + width, this.x + dxx2, this.x, this.x + dxx1};
                int[] yp = new int[]{yy, yy - h, yy - h, yy, yy, this.y, yy};
                g.fillPolygon(xp, yp, xp.length);
                g.setColor(Color.BLACK);
                g.drawPolygon(xp, yp, xp.length);
                g.drawString((String)vStr, xx + margin + pad, yy - margin - fm.getDescent());
            }
        }
    }
}

