/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.tools;

import com.cburch.logisim.LogisimVersion;
import com.cburch.logisim.circuit.Circuit;
import com.cburch.logisim.circuit.ReplacementMap;
import com.cburch.logisim.circuit.Wire;
import com.cburch.logisim.comp.Component;
import com.cburch.logisim.comp.ComponentDrawContext;
import com.cburch.logisim.comp.ComponentFactory;
import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Location;
import com.cburch.logisim.gui.icons.SelectIcon;
import com.cburch.logisim.gui.main.Canvas;
import com.cburch.logisim.gui.main.Selection;
import com.cburch.logisim.gui.main.SelectionActions;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.prefs.AppPreferences;
import com.cburch.logisim.proj.Action;
import com.cburch.logisim.proj.Project;
import com.cburch.logisim.std.gates.GateKeyboardModifier;
import com.cburch.logisim.tools.SetAttributeAction;
import com.cburch.logisim.tools.Strings;
import com.cburch.logisim.tools.Tool;
import com.cburch.logisim.tools.key.KeyConfigurationEvent;
import com.cburch.logisim.tools.key.KeyConfigurationResult;
import com.cburch.logisim.tools.key.KeyConfigurator;
import com.cburch.logisim.tools.move.MoveGesture;
import com.cburch.logisim.tools.move.MoveRequestListener;
import com.cburch.logisim.tools.move.MoveResult;
import com.cburch.logisim.util.AutoLabel;
import com.cburch.logisim.util.GraphicsUtil;
import com.cburch.logisim.util.StringGetter;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;

public class SelectTool
extends Tool {
    public static final String _ID = "Select Tool";
    private static final Cursor selectCursor = Cursor.getPredefinedCursor(0);
    private static final Cursor rectSelectCursor = Cursor.getPredefinedCursor(1);
    private static final Cursor moveCursor = Cursor.getPredefinedCursor(13);
    private static final int IDLE = 0;
    private static final int MOVING = 1;
    private static final int RECT_SELECT = 2;
    private static final Color COLOR_UNMATCHED = new Color(192, 0, 0);
    private static final Color COLOR_COMPUTING = new Color(96, 192, 96);
    private static final Color COLOR_RECT_SELECT = new Color(0, 64, 128, 255);
    private static final Color BACKGROUND_RECT_SELECT = new Color(192, 192, 255, 192);
    private static final SelectIcon ICON = new SelectIcon();
    private Location start = null;
    private int state = 0;
    private int curDx;
    private int curDy;
    private boolean drawConnections;
    private MoveGesture moveGesture;
    private HashMap<Component, KeyConfigurator> keyHandlers = null;
    private final HashSet<Selection> selectionsAdded;
    private final AutoLabel autoLabeler = new AutoLabel();
    private final Listener selListener;

    public SelectTool() {
        this.selectionsAdded = new HashSet();
        this.selListener = new Listener();
    }

    private static void clearCanvasMessage(Canvas canvas, int dx, int dy) {
        StringGetter getter = canvas.getErrorMessage();
        if (getter instanceof ComputingMessage) {
            ComputingMessage msg = (ComputingMessage)getter;
            if (msg.dx == dx && msg.dy == dy) {
                canvas.setErrorMessage(null);
                canvas.repaint();
            }
        }
    }

    private void computeDxDy(Project proj, MouseEvent e, Graphics g) {
        int dy;
        int dx;
        Bounds bds = proj.getSelection().getBounds(g);
        if (bds == Bounds.EMPTY_BOUNDS) {
            dx = e.getX() - this.start.getX();
            dy = e.getY() - this.start.getY();
        } else {
            dx = Math.max(e.getX() - this.start.getX(), -bds.getX());
            dy = Math.max(e.getY() - this.start.getY(), -bds.getY());
        }
        Selection sel = proj.getSelection();
        if (sel.shouldSnap()) {
            dx = Canvas.snapXToGrid(dx);
            dy = Canvas.snapYToGrid(dy);
        }
        this.curDx = dx;
        this.curDy = dy;
    }

    @Override
    public void deselect(Canvas canvas) {
        this.moveGesture = null;
    }

    @Override
    public void draw(Canvas canvas, ComponentDrawContext context) {
        Project proj = canvas.getProject();
        int dx = this.curDx;
        int dy = this.curDy;
        if (this.state == 1) {
            MoveResult result;
            proj.getSelection().drawGhostsShifted(context, dx, dy);
            MoveGesture gesture = this.moveGesture;
            if (gesture != null && this.drawConnections && (dx != 0 || dy != 0) && (result = gesture.findResult(dx, dy)) != null) {
                Collection<Wire> wiresToAdd = result.getWiresToAdd();
                Graphics g = context.getGraphics();
                GraphicsUtil.switchToWidth(g, 3);
                g.setColor(Color.GRAY);
                for (Wire w : wiresToAdd) {
                    Location loc0 = w.getEnd0();
                    Location loc1 = w.getEnd1();
                    g.drawLine(loc0.getX(), loc0.getY(), loc1.getX(), loc1.getY());
                }
                GraphicsUtil.switchToWidth(g, 1);
                g.setColor(COLOR_UNMATCHED);
                for (Location conn : result.getUnconnectedLocations()) {
                    int connX = conn.getX();
                    int connY = conn.getY();
                    g.fillOval(connX - 3, connY - 3, 6, 6);
                    g.fillOval(connX + dx - 3, connY + dy - 3, 6, 6);
                }
            }
        } else if (this.state == 2) {
            int bot;
            int top;
            int right;
            int left = this.start.getX();
            if (left > (right = left + dx)) {
                int i = left;
                left = right;
                right = i;
            }
            if ((top = this.start.getY()) > (bot = top + dy)) {
                int i = top;
                top = bot;
                bot = i;
            }
            Graphics gBase = context.getGraphics();
            int w = right - left - 1;
            int h = bot - top - 1;
            if (w > 2 && h > 2) {
                gBase.setColor(BACKGROUND_RECT_SELECT);
                gBase.fillRect(left + 1, top + 1, w - 1, h - 1);
            }
            Circuit circ = canvas.getCircuit();
            Bounds bds = Bounds.create(left, top, right - left, bot - top);
            for (Component c : circ.getAllWithin(bds)) {
                Location cloc = c.getLocation();
                Graphics gDup = gBase.create();
                context.setGraphics(gDup);
                c.getFactory().drawGhost(context, COLOR_RECT_SELECT, cloc.getX(), cloc.getY(), c.getAttributeSet());
                gDup.dispose();
            }
            gBase.setColor(COLOR_RECT_SELECT);
            GraphicsUtil.switchToWidth(gBase, 2);
            if (w < 0) {
                w = 0;
            }
            if (h < 0) {
                h = 0;
            }
            gBase.drawRect(left, top, w, h);
        }
    }

    public boolean equals(Object other) {
        return other instanceof SelectTool;
    }

    @Override
    public AttributeSet getAttributeSet(Canvas canvas) {
        return canvas.getSelection().getAttributeSet();
    }

    @Override
    public Cursor getCursor() {
        return this.state == 0 ? selectCursor : (this.state == 2 ? rectSelectCursor : moveCursor);
    }

    @Override
    public String getDescription() {
        return Strings.S.get("selectToolDesc");
    }

    @Override
    public String getDisplayName() {
        return Strings.S.get("selectTool");
    }

    @Override
    public Set<Component> getHiddenComponents(Canvas canvas) {
        if (this.state == 1) {
            MoveResult result;
            int dx = this.curDx;
            int dy = this.curDy;
            if (dx == 0 && dy == 0) {
                return null;
            }
            Set<Component> sel = canvas.getSelection().getComponents();
            MoveGesture gesture = this.moveGesture;
            if (gesture != null && this.drawConnections && (result = gesture.findResult(dx, dy)) != null) {
                HashSet<Component> ret = new HashSet<Component>(sel);
                ret.addAll(result.getReplacementMap().getRemovals());
                return ret;
            }
            return sel;
        }
        return null;
    }

    private void handleMoveDrag(Canvas canvas, int dx, int dy, int modsEx) {
        boolean connect;
        this.drawConnections = connect = this.shouldConnect(modsEx);
        if (connect) {
            boolean queued;
            MoveGesture gesture = this.moveGesture;
            if (gesture == null) {
                this.moveGesture = gesture = new MoveGesture(new MoveRequestHandler(canvas), canvas.getCircuit(), canvas.getSelection().getAnchoredComponents());
            }
            if ((dx != 0 || dy != 0) && (queued = gesture.enqueueRequest(dx, dy))) {
                canvas.setErrorMessage(new ComputingMessage(dx, dy), COLOR_COMPUTING);
                if (gesture.findResult(dx, dy) != null) {
                    SelectTool.clearCanvasMessage(canvas, dx, dy);
                }
            }
        }
        canvas.repaint();
    }

    public int hashCode() {
        return SelectTool.class.hashCode();
    }

    @Override
    public boolean isAllDefaultValues(AttributeSet attrs, LogisimVersion ver) {
        return true;
    }

    @Override
    public void keyPressed(Canvas canvas, KeyEvent e) {
        if (this.state == 1 && e.getKeyCode() == 16) {
            this.handleMoveDrag(canvas, this.curDx, this.curDy, e.getModifiersEx());
        } else {
            SetAttributeAction act;
            SortedSet<Component> comps = AutoLabel.sort(canvas.getProject().getSelection().getComponents());
            int keybEvent = e.getKeyCode();
            boolean keyTaken = false;
            for (Component comp : comps) {
                act = new SetAttributeAction(canvas.getCircuit(), Strings.S.getter("changeComponentAttributesAction"));
                keyTaken |= GateKeyboardModifier.tookKeyboardStrokes(keybEvent, comp, comp.getAttributeSet(), canvas, act, true);
                if (act.isEmpty()) continue;
                canvas.getProject().doAction(act);
            }
            if (!keyTaken) {
                for (Component comp : comps) {
                    act = new SetAttributeAction(canvas.getCircuit(), Strings.S.getter("changeComponentAttributesAction"));
                    keyTaken |= this.autoLabeler.labelKeyboardHandler(keybEvent, comp.getAttributeSet(), comp.getFactory().getDisplayName(), comp, comp.getFactory(), canvas.getCircuit(), act, true);
                    if (act.isEmpty()) continue;
                    canvas.getProject().doAction(act);
                }
            }
            if (!keyTaken) {
                switch (keybEvent) {
                    case 8: 
                    case 127: {
                        if (canvas.getSelection().isEmpty()) break;
                        Action act2 = SelectionActions.clear(canvas.getSelection());
                        canvas.getProject().doAction(act2);
                        e.consume();
                        break;
                    }
                    default: {
                        this.processKeyEvent(canvas, e, 0);
                    }
                }
            }
        }
    }

    @Override
    public void keyReleased(Canvas canvas, KeyEvent e) {
        if (this.state == 1 && e.getKeyCode() == 16) {
            this.handleMoveDrag(canvas, this.curDx, this.curDy, e.getModifiersEx());
        } else {
            this.processKeyEvent(canvas, e, 1);
        }
    }

    @Override
    public void keyTyped(Canvas canvas, KeyEvent e) {
        this.processKeyEvent(canvas, e, 2);
    }

    @Override
    public void mouseDragged(Canvas canvas, Graphics g, MouseEvent e) {
        if (this.state == 1) {
            Project proj = canvas.getProject();
            this.computeDxDy(proj, e, g);
            this.handleMoveDrag(canvas, this.curDx, this.curDy, e.getModifiersEx());
        } else if (this.state == 2) {
            Project proj = canvas.getProject();
            this.curDx = e.getX() - this.start.getX();
            this.curDy = e.getY() - this.start.getY();
            proj.repaintCanvas();
        }
    }

    @Override
    public void mousePressed(Canvas canvas, Graphics g, MouseEvent e) {
        Action act;
        Circuit circuit;
        Collection<Component> clicked;
        canvas.requestFocusInWindow();
        Project proj = canvas.getProject();
        Selection sel = proj.getSelection();
        this.start = Location.create(e.getX(), e.getY(), false);
        this.curDx = 0;
        this.curDy = 0;
        this.moveGesture = null;
        Collection<Component> inSel = sel.getComponentsContaining(this.start, g);
        if (!inSel.isEmpty()) {
            if ((e.getModifiersEx() & 0x40) == 0) {
                this.setState(proj, 1);
                proj.repaintCanvas();
                return;
            }
            Action act2 = SelectionActions.drop(sel, inSel);
            if (act2 != null) {
                proj.doAction(act2);
            }
        }
        if (!(clicked = (circuit = canvas.getCircuit()).getAllContaining(this.start, g)).isEmpty()) {
            Object act3;
            if ((e.getModifiersEx() & 0x40) == 0 && sel.getComponentsContaining(this.start).isEmpty() && (act3 = SelectionActions.dropAll(sel)) != null) {
                proj.doAction((Action)act3);
            }
            for (Component comp : clicked) {
                if (inSel.contains(comp)) continue;
                sel.add(comp);
            }
            this.setState(proj, 1);
            proj.repaintCanvas();
            return;
        }
        if ((e.getModifiersEx() & 0x40) == 0 && (act = SelectionActions.dropAll(sel)) != null) {
            proj.doAction(act);
        }
        this.setState(proj, 2);
        proj.repaintCanvas();
    }

    @Override
    public void mouseReleased(Canvas canvas, Graphics g, MouseEvent e) {
        Set<Component> comps;
        Action act;
        Project proj = canvas.getProject();
        if (this.state == 1) {
            this.setState(proj, 0);
            this.computeDxDy(proj, e, g);
            int dx = this.curDx;
            int dy = this.curDy;
            if (dx != 0 || dy != 0) {
                if (!proj.getLogisimFile().contains(canvas.getCircuit())) {
                    canvas.setErrorMessage(Strings.S.getter("cannotModifyError"));
                } else if (proj.getSelection().hasConflictWhenMoved(dx, dy)) {
                    canvas.setErrorMessage(Strings.S.getter("exclusiveError"));
                } else {
                    ReplacementMap repl;
                    boolean connect = this.shouldConnect(e.getModifiersEx());
                    this.drawConnections = false;
                    if (connect) {
                        MoveGesture gesture = this.moveGesture;
                        if (gesture == null) {
                            gesture = new MoveGesture(new MoveRequestHandler(canvas), canvas.getCircuit(), canvas.getSelection().getAnchoredComponents());
                        }
                        canvas.setErrorMessage(new ComputingMessage(dx, dy), COLOR_COMPUTING);
                        MoveResult result = gesture.forceRequest(dx, dy);
                        SelectTool.clearCanvasMessage(canvas, dx, dy);
                        repl = result.getReplacementMap();
                    } else {
                        repl = null;
                    }
                    Selection sel = proj.getSelection();
                    proj.doAction(SelectionActions.translate(sel, dx, dy, repl));
                }
            }
            this.moveGesture = null;
            proj.repaintCanvas();
        } else if (this.state == 2) {
            Bounds bds = Bounds.create(this.start).add(this.start.getX() + this.curDx, this.start.getY() + this.curDy);
            Circuit circuit = canvas.getCircuit();
            Selection sel = proj.getSelection();
            Collection<Component> inSel = sel.getComponentsWithin(bds, g);
            for (Component comp : circuit.getAllWithin(bds, g)) {
                if (inSel.contains(comp)) continue;
                sel.add(comp);
            }
            act = SelectionActions.drop(sel, inSel);
            if (act != null) {
                proj.doAction(act);
            }
            this.setState(proj, 0);
            proj.repaintCanvas();
        }
        if (e.getClickCount() >= 2 && (comps = canvas.getProject().getSelection().getComponents()).size() == 1) {
            for (Component comp : comps) {
                if (!comp.getAttributeSet().containsAttribute(StdAttr.LABEL)) continue;
                String OldLabel = comp.getAttributeSet().getValue(StdAttr.LABEL);
                act = new SetAttributeAction(canvas.getCircuit(), Strings.S.getter("changeComponentAttributesAction"));
                this.autoLabeler.askAndSetLabel(comp.getFactory().getDisplayName(), OldLabel, canvas.getCircuit(), comp, comp.getFactory(), comp.getAttributeSet(), (SetAttributeAction)act, true);
                if (((SetAttributeAction)act).isEmpty()) continue;
                canvas.getProject().doAction(act);
            }
        }
    }

    @Override
    public void paintIcon(ComponentDrawContext c, int x, int y) {
        ICON.paintIcon(null, c.getGraphics(), x, y);
    }

    private void processKeyEvent(Canvas canvas, KeyEvent e, int type) {
        Object handler;
        HashMap<Component, KeyConfigurator> handlers = this.keyHandlers;
        if (handlers == null) {
            handlers = new HashMap();
            Selection sel = canvas.getSelection();
            for (Component component : sel.getComponents()) {
                AttributeSet attrs;
                ComponentFactory factory = component.getFactory();
                handler = factory.getFeature(KeyConfigurator.class, attrs = component.getAttributeSet());
                if (handler == null) continue;
                KeyConfigurator base = (KeyConfigurator)handler;
                handlers.put(component, base.clone());
            }
            this.keyHandlers = handlers;
        }
        if (!handlers.isEmpty()) {
            boolean consume = false;
            ArrayList<KeyConfigurationResult> results = new ArrayList<KeyConfigurationResult>();
            for (Map.Entry<Component, KeyConfigurator> entry : handlers.entrySet()) {
                Component comp = entry.getKey();
                handler = entry.getValue();
                KeyConfigurationEvent event = new KeyConfigurationEvent(type, comp.getAttributeSet(), e, comp);
                KeyConfigurationResult result = handler.keyEventReceived(event);
                consume |= event.isConsumed();
                if (result == null) continue;
                results.add(result);
            }
            if (consume) {
                e.consume();
            }
            if (!results.isEmpty()) {
                SetAttributeAction setAttributeAction = new SetAttributeAction(canvas.getCircuit(), Strings.S.getter("changeComponentAttributesAction"));
                for (KeyConfigurationResult result : results) {
                    Component comp = (Component)result.getEvent().getData();
                    Map<Attribute<?>, Object> newValues = result.getAttributeValues();
                    for (Map.Entry<Attribute<?>, Object> entry : newValues.entrySet()) {
                        setAttributeAction.set(comp, entry.getKey(), entry.getValue());
                    }
                }
                if (!setAttributeAction.isEmpty()) {
                    canvas.getProject().doAction(setAttributeAction);
                }
            }
        }
    }

    @Override
    public void select(Canvas canvas) {
        Selection sel = canvas.getSelection();
        if (!this.selectionsAdded.contains(sel)) {
            sel.addListener(this.selListener);
        }
    }

    private void setState(Project proj, int newState) {
        if (this.state != newState) {
            this.state = newState;
            proj.getFrame().getCanvas().setCursor(this.getCursor());
        }
    }

    private boolean shouldConnect(int modsEx) {
        boolean shiftReleased = (modsEx & 0x40) == 0;
        boolean defaultValue = AppPreferences.MOVE_KEEP_CONNECT.getBoolean();
        return shiftReleased ? defaultValue : !defaultValue;
    }

    private class Listener
    implements Selection.Listener {
        private Listener() {
        }

        @Override
        public void selectionChanged(Selection.Event event) {
            SelectTool.this.keyHandlers = null;
        }
    }

    private static class ComputingMessage
    implements StringGetter {
        private final int dx;
        private final int dy;

        public ComputingMessage(int dx, int dy) {
            this.dx = dx;
            this.dy = dy;
        }

        @Override
        public String toString() {
            return Strings.S.get("moveWorkingMsg");
        }
    }

    private static class MoveRequestHandler
    implements MoveRequestListener {
        private final Canvas canvas;

        MoveRequestHandler(Canvas canvas) {
            this.canvas = canvas;
        }

        @Override
        public void requestSatisfied(MoveGesture gesture, int dx, int dy) {
            SelectTool.clearCanvasMessage(this.canvas, dx, dy);
        }
    }
}

