/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.tools;

import com.cburch.logisim.circuit.CircuitMutation;
import com.cburch.logisim.circuit.Wire;
import com.cburch.logisim.comp.Component;
import com.cburch.logisim.comp.ComponentDrawContext;
import com.cburch.logisim.data.Location;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.gui.main.Canvas;
import com.cburch.logisim.prefs.AppPreferences;
import com.cburch.logisim.proj.Action;
import com.cburch.logisim.tools.Strings;
import com.cburch.logisim.tools.Tool;
import com.cburch.logisim.tools.WireRepair;
import com.cburch.logisim.tools.WireRepairData;
import com.cburch.logisim.util.GraphicsUtil;
import com.cburch.logisim.util.StringGetter;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;

public class WiringTool
extends Tool {
    public static final String _ID = "Wiring Tool";
    private static final Cursor cursor = Cursor.getPredefinedCursor(1);
    private static final int HORIZONTAL = 1;
    private static final int VERTICAL = 2;
    private boolean exists = false;
    private boolean inCanvas = false;
    private Location start = Location.create(0, 0, true);
    private Location cur = Location.create(0, 0, true);
    private boolean hasDragged = false;
    private boolean startShortening = false;
    private Wire shortening = null;
    private Action lastAction = null;
    private int direction = 0;

    public WiringTool() {
        super.select(null);
    }

    private Wire checkForRepairs(Canvas canvas, Wire w, Location end) {
        if (w.getLength() <= 10) {
            return w;
        }
        if (!canvas.getCircuit().getNonWires(end).isEmpty()) {
            return w;
        }
        int delta = end.equals(w.getEnd0()) ? 10 : -10;
        Location cand = w.isVertical() ? Location.create(end.getX(), end.getY() + delta, true) : Location.create(end.getX() + delta, end.getY(), true);
        for (Component component : canvas.getCircuit().getNonWires(cand)) {
            WireRepair repair;
            if (!component.getBounds().contains(end, 2) || (repair = (WireRepair)component.getFeature(WireRepair.class)) == null || !repair.shouldRepairWire(new WireRepairData(w, cand))) continue;
            w = Wire.create(w.getOtherEnd(end), cand);
            canvas.repaint(end.getX() - 13, end.getY() - 13, 26, 26);
            return w;
        }
        return w;
    }

    private boolean computeMove(int newX, int newY) {
        if (this.cur.getX() == newX && this.cur.getY() == newY) {
            return false;
        }
        Location start = this.start;
        if (this.direction == 0) {
            if (newX != start.getX()) {
                this.direction = 1;
            } else if (newY != start.getY()) {
                this.direction = 2;
            }
        } else if (this.direction == 1 && newX == start.getX()) {
            this.direction = newY == start.getY() ? 0 : 2;
        } else if (this.direction == 2 && newY == start.getY()) {
            this.direction = newX == start.getX() ? 0 : 1;
        }
        return true;
    }

    @Override
    public void draw(Canvas canvas, ComponentDrawContext context) {
        Graphics g = context.getGraphics();
        if (this.exists) {
            Location e0 = this.start;
            Location e1 = this.cur;
            Wire shortenBefore = this.willShorten(this.start, this.cur);
            if (shortenBefore != null) {
                Wire shorten = this.getShortenResult(shortenBefore, this.start, this.cur);
                if (shorten == null) {
                    return;
                }
                e0 = shorten.getEnd0();
                e1 = shorten.getEnd1();
            }
            int x0 = e0.getX();
            int y0 = e0.getY();
            int x1 = e1.getX();
            int y1 = e1.getY();
            g.setColor(Color.BLACK);
            GraphicsUtil.switchToWidth(g, 3);
            if (this.direction == 1) {
                if (x0 != x1) {
                    g.drawLine(x0, y0, x1, y0);
                }
                if (y0 != y1) {
                    g.drawLine(x1, y0, x1, y1);
                }
            } else if (this.direction == 2) {
                if (y0 != y1) {
                    g.drawLine(x0, y0, x0, y1);
                }
                if (x0 != x1) {
                    g.drawLine(x0, y1, x1, y1);
                }
            }
        } else if (AppPreferences.ADD_SHOW_GHOSTS.getBoolean() && this.inCanvas) {
            g.setColor(Color.GRAY);
            g.fillOval(this.cur.getX() - 2, this.cur.getY() - 2, 5, 5);
        }
    }

    public boolean equals(Object other) {
        return other instanceof WiringTool;
    }

    @Override
    public Cursor getCursor() {
        return cursor;
    }

    @Override
    public String getDescription() {
        return Strings.S.get("wiringToolDesc");
    }

    @Override
    public String getDisplayName() {
        return Strings.S.get("wiringTool");
    }

    @Override
    public Set<Component> getHiddenComponents(Canvas canvas) {
        Wire shorten = this.willShorten(this.start, this.cur);
        return shorten != null ? Collections.singleton(shorten) : null;
    }

    private Wire getShortenResult(Wire shorten, Location drag0, Location drag1) {
        Location e1;
        Location e0;
        if (shorten == null) {
            return null;
        }
        if (shorten.endsAt(drag0)) {
            e0 = drag1;
            e1 = shorten.getOtherEnd(drag0);
        } else if (shorten.endsAt(drag1)) {
            e0 = drag0;
            e1 = shorten.getOtherEnd(drag1);
        } else {
            return null;
        }
        return e0.equals(e1) ? null : Wire.create(e0, e1);
    }

    public int hashCode() {
        return WiringTool.class.hashCode();
    }

    @Override
    public void keyPressed(Canvas canvas, KeyEvent event) {
        if (event.getKeyCode() == 8 && this.lastAction != null && canvas.getProject().getLastAction() == this.lastAction) {
            canvas.getProject().undoAction();
            this.lastAction = null;
        }
    }

    @Override
    public void mouseDragged(Canvas canvas, Graphics g, MouseEvent e) {
        if (this.exists) {
            Canvas.snapToGrid(e);
            int curX = e.getX();
            int curY = e.getY();
            if (!this.computeMove(curX, curY)) {
                return;
            }
            this.hasDragged = true;
            Rectangle rect = new Rectangle();
            rect.add(this.start.getX(), this.start.getY());
            rect.add(this.cur.getX(), this.cur.getY());
            rect.add(curX, curY);
            rect.grow(3, 3);
            this.cur = Location.create(curX, curY, true);
            super.mouseDragged(canvas, g, e);
            Wire shorten = null;
            if (this.startShortening) {
                for (Wire w : canvas.getCircuit().getWires(this.start)) {
                    if (!w.contains(this.cur)) continue;
                    shorten = w;
                    break;
                }
            }
            if (shorten == null) {
                for (Wire w : canvas.getCircuit().getWires(this.cur)) {
                    if (!w.contains(this.start)) continue;
                    shorten = w;
                    break;
                }
            }
            this.shortening = shorten;
            canvas.repaint(rect);
        }
    }

    @Override
    public void mouseEntered(Canvas canvas, Graphics g, MouseEvent e) {
        this.inCanvas = true;
        canvas.getProject().repaintCanvas();
    }

    @Override
    public void mouseExited(Canvas canvas, Graphics g, MouseEvent e) {
        this.inCanvas = false;
        canvas.getProject().repaintCanvas();
    }

    @Override
    public void mouseMoved(Canvas canvas, Graphics g, MouseEvent e) {
        if (this.exists) {
            this.mouseDragged(canvas, g, e);
        } else {
            Canvas.snapToGrid(e);
            this.inCanvas = true;
            int curX = e.getX();
            int curY = e.getY();
            if (this.cur.getX() != curX || this.cur.getY() != curY) {
                this.cur = Location.create(curX, curY, true);
            }
            canvas.getProject().repaintCanvas();
        }
    }

    @Override
    public void mousePressed(Canvas canvas, Graphics g, MouseEvent e) {
        if (!canvas.getProject().getLogisimFile().contains(canvas.getCircuit())) {
            this.exists = false;
            canvas.setErrorMessage(Strings.S.getter("cannotModifyError"));
            return;
        }
        Canvas.snapToGrid(e);
        this.cur = this.start = Location.create(e.getX(), e.getY(), true);
        this.exists = true;
        this.hasDragged = false;
        this.startShortening = !canvas.getCircuit().getWires(this.start).isEmpty();
        this.shortening = null;
        super.mousePressed(canvas, g, e);
        canvas.getProject().repaintCanvas();
    }

    @Override
    public void mouseReleased(Canvas canvas, Graphics g, MouseEvent e) {
        if (!this.exists) {
            return;
        }
        Canvas.snapToGrid(e);
        int curX = e.getX();
        int curY = e.getY();
        if (this.computeMove(curX, curY)) {
            this.cur = Location.create(curX, curY, true);
        }
        if (this.hasDragged) {
            this.exists = false;
            super.mouseReleased(canvas, g, e);
            ArrayList<Wire> wires = new ArrayList<Wire>(2);
            if (this.cur.getY() == this.start.getY() || this.cur.getX() == this.start.getX()) {
                Wire wire = Wire.create(this.cur, this.start);
                wire = this.checkForRepairs(canvas, wire, wire.getEnd0());
                wire = this.checkForRepairs(canvas, wire, wire.getEnd1());
                if (this.performShortening(canvas, this.start, this.cur)) {
                    return;
                }
                if (wire.getLength() > 0) {
                    wires.add(wire);
                }
            } else {
                Location m = this.direction == 1 ? Location.create(this.cur.getX(), this.start.getY(), true) : Location.create(this.start.getX(), this.cur.getY(), true);
                Wire wire0 = Wire.create(this.start, m);
                Wire wire1 = Wire.create(m, this.cur);
                wire0 = this.checkForRepairs(canvas, wire0, this.start);
                wire1 = this.checkForRepairs(canvas, wire1, this.cur);
                if (wire0.getLength() > 0) {
                    wires.add(wire0);
                }
                if (wire1.getLength() > 0) {
                    wires.add(wire1);
                }
            }
            if (!wires.isEmpty()) {
                CircuitMutation mutation = new CircuitMutation(canvas.getCircuit());
                mutation.addAll(wires);
                StringGetter desc = wires.size() == 1 ? Strings.S.getter("addWireAction") : Strings.S.getter("addWiresAction");
                Action act = mutation.toAction(desc);
                canvas.getProject().doAction(act);
                this.lastAction = act;
            }
        }
    }

    @Override
    public void paintIcon(ComponentDrawContext c, int x, int y) {
        Graphics2D g2 = (Graphics2D)c.getGraphics().create();
        g2.translate(x, y);
        int[] points = new int[]{3, 13, 8, 13, 8, 3, 13, 3};
        g2.setStroke(new BasicStroke(AppPreferences.getScaled(2)));
        g2.setColor(Color.BLACK);
        for (int i = 0; i < points.length - 2; i += 2) {
            g2.drawLine(AppPreferences.getScaled(points[i]), AppPreferences.getScaled(points[i + 1]), AppPreferences.getScaled(points[i + 2]), AppPreferences.getScaled(points[i + 3]));
        }
        g2.setColor(Value.trueColor);
        int wh = AppPreferences.getScaled(5);
        g2.fillOval(AppPreferences.getScaled(1), AppPreferences.getScaled(11), wh, wh);
        g2.setColor(Value.unknownColor);
        g2.fillOval(AppPreferences.getScaled(11), AppPreferences.getScaled(1), wh, wh);
        g2.dispose();
    }

    private boolean performShortening(Canvas canvas, Location drag0, Location drag1) {
        StringGetter actName;
        Wire shorten = this.willShorten(drag0, drag1);
        if (shorten == null) {
            return false;
        }
        CircuitMutation xn = new CircuitMutation(canvas.getCircuit());
        Wire result = this.getShortenResult(shorten, drag0, drag1);
        if (result == null) {
            xn.remove(shorten);
            actName = Strings.S.getter("removeComponentAction", shorten.getFactory().getDisplayGetter());
        } else {
            xn.replace(shorten, result);
            actName = Strings.S.getter("shortenWireAction");
        }
        canvas.getProject().doAction(xn.toAction(actName));
        return true;
    }

    private void reset() {
        this.exists = false;
        this.inCanvas = false;
        this.start = Location.create(0, 0, true);
        this.cur = Location.create(0, 0, true);
        this.startShortening = false;
        this.shortening = null;
        this.direction = 0;
    }

    void resetClick() {
        this.exists = false;
    }

    @Override
    public void select(Canvas canvas) {
        super.select(canvas);
        this.lastAction = null;
        this.reset();
    }

    private Wire willShorten(Location drag0, Location drag1) {
        Wire shorten = this.shortening;
        if (shorten == null) {
            return null;
        }
        if (shorten.endsAt(drag0) || shorten.endsAt(drag1)) {
            return shorten;
        }
        return null;
    }
}

