/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.tools.move;

import com.cburch.logisim.circuit.Wire;
import com.cburch.logisim.comp.Component;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Location;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;

public final class AvoidanceMap {
    private final HashMap<Location, String> avoidanceMap;

    private AvoidanceMap(HashMap<Location, String> map) {
        this.avoidanceMap = map;
    }

    static AvoidanceMap create(Collection<Component> elements, int dx, int dy) {
        AvoidanceMap ret = new AvoidanceMap(new HashMap<Location, String>());
        ret.markAll(elements, dx, dy);
        return ret;
    }

    public AvoidanceMap cloneMap() {
        return new AvoidanceMap(new HashMap<Location, String>(this.avoidanceMap));
    }

    public Object get(Location loc) {
        return this.avoidanceMap.get(loc);
    }

    public void markAll(Collection<Component> elements, int dx, int dy) {
        for (Component element : elements) {
            if (element instanceof Wire) {
                Wire wire = (Wire)element;
                this.markWire(wire, dx, dy);
                continue;
            }
            this.markComponent(element, dx, dy);
        }
    }

    public void markComponent(Component comp, int dx, int dy) {
        HashMap<Location, String> avoid = this.avoidanceMap;
        boolean translated = dx != 0 || dy != 0;
        Bounds bds = comp.getBounds();
        int x0 = bds.getX() + dx;
        int y0 = bds.getY() + dy;
        int x1 = x0 + bds.getWidth();
        int y1 = y0 + bds.getHeight();
        x0 += 9 - (x0 + 9) % 10;
        y0 += 9 - (y0 + 9) % 10;
        for (int x = x0; x <= x1; x += 10) {
            for (int y = y0; y <= y1; y += 10) {
                Location baseLoc;
                Location loc = Location.create(x, y, false);
                String prev = avoid.put(loc, "neither");
                if ("neither".equals(prev)) continue;
                Location location = baseLoc = translated ? loc.translate(-dx, -dy) : loc;
                if (comp.contains(baseLoc)) continue;
                if (prev == null) {
                    avoid.remove(loc);
                    continue;
                }
                avoid.put(loc, prev);
            }
        }
    }

    public void markWire(Wire w, int dx, int dy) {
        HashMap<Location, String> avoid = this.avoidanceMap;
        boolean translated = dx != 0 || dy != 0;
        Location loc0 = w.getEnd0();
        Location loc1 = w.getEnd1();
        if (translated) {
            loc0 = loc0.translate(dx, dy);
            loc1 = loc1.translate(dx, dy);
        }
        avoid.put(loc0, "neither");
        avoid.put(loc1, "neither");
        int x0 = loc0.getX();
        int y0 = loc0.getY();
        int x1 = loc1.getX();
        int y1 = loc1.getY();
        if (x0 == x1) {
            for (Location loc : Wire.create(loc0, loc1)) {
                String prev = avoid.put(loc, "horz");
                if (!"neither".equals(prev) && !"vert".equals(prev)) continue;
                avoid.put(loc, "neither");
            }
        } else if (y0 == y1) {
            for (Location loc : Wire.create(loc0, loc1)) {
                String prev = avoid.put(loc, "vert");
                if (!"neither".equals(prev) && !"horz".equals(prev)) continue;
                avoid.put(loc, "neither");
            }
        } else {
            throw new RuntimeException("Diagonal wires are not supported.");
        }
    }

    public void print(PrintStream stream) {
        ArrayList<Location> list = new ArrayList<Location>(this.avoidanceMap.keySet());
        Collections.sort(list);
        for (Location location : list) {
            stream.println(location + ": " + this.avoidanceMap.get(location));
        }
    }

    public void unmarkLocation(Location loc) {
        this.avoidanceMap.remove(loc);
    }

    public void unmarkWire(Wire w, Location deletedEnd, Set<Location> unmarkable) {
        Location loc0 = w.getEnd0();
        Location loc1 = w.getEnd1();
        if (unmarkable == null || unmarkable.contains(deletedEnd)) {
            this.avoidanceMap.remove(deletedEnd);
        }
        int x0 = loc0.getX();
        int y0 = loc0.getY();
        int x1 = loc1.getX();
        int y1 = loc1.getY();
        if (x0 == x1) {
            for (Location loc : w) {
                String prev;
                if (unmarkable != null && !unmarkable.contains(deletedEnd) || !"horz".equals(prev = this.avoidanceMap.remove(loc))) continue;
                this.avoidanceMap.put(loc, "vert");
            }
        } else if (y0 == y1) {
            for (Location loc : w) {
                String prev;
                if (unmarkable != null && !unmarkable.contains(deletedEnd) || "vert".equals(prev = this.avoidanceMap.remove(loc))) continue;
                this.avoidanceMap.put(loc, "horz");
            }
        } else {
            throw new RuntimeException("Diagonal wires are not supported.");
        }
    }
}

