/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.util;

import com.cburch.logisim.circuit.Circuit;
import com.cburch.logisim.comp.Component;
import com.cburch.logisim.comp.ComponentFactory;
import com.cburch.logisim.comp.PositionComparator;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.fpga.designrulecheck.CorrectLabel;
import com.cburch.logisim.gui.generic.OptionPane;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.std.wiring.Tunnel;
import com.cburch.logisim.tools.SetAttributeAction;
import com.cburch.logisim.util.StringUtil;
import com.cburch.logisim.util.Strings;
import com.cburch.logisim.util.SyntaxChecker;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class AutoLabel {
    public static final Integer[] USED_KEY_STROKES = new Integer[]{76, 84, 86, 72, 65};
    public static final Set<Integer> KEY_STROKES = new HashSet<Integer>(Arrays.asList(USED_KEY_STROKES));
    private final HashMap<Circuit, String> labelBase = new HashMap();
    private final HashMap<Circuit, Integer> currentIndex = new HashMap();
    private final HashMap<Circuit, Boolean> useLabelBaseOnly = new HashMap();
    private final HashMap<Circuit, Boolean> useUnderscore = new HashMap();
    private final HashMap<Circuit, Boolean> active = new HashMap();
    private final HashMap<Circuit, String> currentLabel = new HashMap();

    public AutoLabel() {
        this("", null, false);
    }

    public AutoLabel(String label, Circuit circ) {
        this(label, circ, true);
    }

    public AutoLabel(String label, Circuit circ, boolean useFirstLabel) {
        this.update(circ, label, useFirstLabel, null);
        this.activate(circ);
    }

    public boolean hasNext(Circuit circ) {
        if (circ == null || !this.active.containsKey(circ)) {
            return false;
        }
        return this.active.get(circ);
    }

    public String getCurrent(Circuit circ, ComponentFactory me) {
        if (circ == null || !this.currentLabel.containsKey(circ) || this.currentLabel.get(circ).isEmpty()) {
            return "";
        }
        if (Circuit.isCorrectLabel(circ.getName(), this.currentLabel.get(circ), circ.getNonWires(), null, me, false)) {
            return this.currentLabel.get(circ);
        }
        if (this.hasNext(circ)) {
            return this.getNext(circ, me);
        }
        this.setLabel("", circ, me);
        return "";
    }

    public boolean correctMatrixBaseLabel(Circuit circ, ComponentFactory me, String common, int maxX, int maxY) {
        if (StringUtil.isNullOrEmpty(common) || maxX < 0 || maxY < 0) {
            return true;
        }
        if (!SyntaxChecker.isVariableNameAcceptable(common, true)) {
            return false;
        }
        for (int x = 0; x < maxX; ++x) {
            for (int y = 0; y < maxY; ++y) {
                if (!this.getMatrixLabel(circ, me, common, x, y).isEmpty()) continue;
                return false;
            }
        }
        return true;
    }

    public String getMatrixLabel(Circuit circ, ComponentFactory me, String common, int x, int y) {
        if (StringUtil.isNullOrEmpty(common) || x < 0 || y < 0) {
            return "";
        }
        if (circ == null || !this.currentLabel.containsKey(circ) || this.currentLabel.get(circ).isEmpty()) {
            return "";
        }
        String label = common.concat("_X" + x + "_Y" + y);
        if (Circuit.isCorrectLabel(circ.getName(), label, circ.getNonWires(), null, me, false) && SyntaxChecker.isVariableNameAcceptable(label, false)) {
            return label;
        }
        return "";
    }

    public String getNext(Circuit circ, ComponentFactory me) {
        if (circ == null) {
            return "";
        }
        if (this.useLabelBaseOnly.get(circ).booleanValue()) {
            this.useLabelBaseOnly.put(circ, false);
            return this.labelBase.get(circ);
        }
        if (me instanceof Tunnel) {
            return this.labelBase.get(circ);
        }
        String newLabel = "";
        Integer curIdx = this.currentIndex.get(circ);
        String baseLabel = this.labelBase.get(circ);
        boolean undescore = this.useUnderscore.get(circ);
        do {
            Integer n = curIdx;
            curIdx = curIdx + 1;
            newLabel = baseLabel;
            if (undescore) {
                newLabel = newLabel.concat("_");
            }
            newLabel = newLabel.concat(Integer.toString(curIdx));
        } while (!Circuit.isCorrectLabel(circ.getName(), newLabel, circ.getNonWires(), null, me, false));
        this.currentIndex.put(circ, curIdx);
        this.currentLabel.put(circ, newLabel);
        return newLabel;
    }

    public boolean isActive(Circuit circ) {
        if (circ != null && this.active.containsKey(circ)) {
            return this.active.get(circ);
        }
        return false;
    }

    public void setLabel(String label, Circuit circ, ComponentFactory me) {
        if (circ != null) {
            this.update(circ, label, true, me);
        }
    }

    public void activate(Circuit circ) {
        if (circ != null && this.labelBase.containsKey(circ) && this.currentIndex.containsKey(circ) && this.useLabelBaseOnly.containsKey(circ) && this.useUnderscore.containsKey(circ)) {
            this.active.put(circ, !this.labelBase.get(circ).isEmpty());
        }
    }

    public void stop(Circuit circ) {
        if (circ != null) {
            this.setLabel("", circ, null);
            this.active.put(circ, false);
        }
    }

    public static boolean labelEndsWithNumber(String label) {
        return CorrectLabel.NUMBERS.contains(label.substring(label.length() - 1));
    }

    private int getLabelBaseEndIndex(String label) {
        int index;
        for (index = label.length(); index > 1 && CorrectLabel.NUMBERS.contains(label.substring(index - 1, index)); --index) {
        }
        return index - 1;
    }

    private void update(Circuit circ, String label, boolean useFirstLabel, ComponentFactory me) {
        if (circ == null) {
            return;
        }
        if (label.isEmpty() || !SyntaxChecker.isVariableNameAcceptable(label, false)) {
            this.labelBase.put(circ, "");
            this.currentIndex.put(circ, 0);
            this.useLabelBaseOnly.put(circ, false);
            this.currentLabel.put(circ, "");
            return;
        }
        this.useLabelBaseOnly.put(circ, useFirstLabel);
        if (AutoLabel.labelEndsWithNumber(label)) {
            int index = this.getLabelBaseEndIndex(label);
            this.currentIndex.put(circ, Integer.valueOf(label.substring(index + 1)));
            this.labelBase.put(circ, label.substring(0, index + 1));
            this.useUnderscore.put(circ, false);
            this.useLabelBaseOnly.put(circ, false);
        } else {
            this.labelBase.put(circ, label);
            this.currentIndex.put(circ, 0);
            this.useUnderscore.put(circ, !label.endsWith("_"));
        }
        if (useFirstLabel) {
            this.currentLabel.put(circ, label);
        } else {
            this.currentLabel.put(circ, this.getNext(circ, me));
        }
    }

    public static SortedSet<Component> sort(Set<Component> comps) {
        TreeSet<Component> sorted = new TreeSet<Component>(new PositionComparator());
        sorted.addAll(comps);
        return sorted;
    }

    public String askAndSetLabel(String componentName, String oldLabel, Circuit circ, Component comp, ComponentFactory compFactory, AttributeSet attrs, SetAttributeAction act, boolean createAction) {
        boolean correct = false;
        String newLabel = oldLabel;
        while (!correct) {
            newLabel = (String)OptionPane.showInputDialog(null, Strings.S.get("editLabelQuestion") + " " + componentName, Strings.S.get("editLabelDialog"), 3, null, null, oldLabel);
            if (newLabel != null) {
                if (!Circuit.isCorrectLabel(circ.getName(), newLabel, circ.getNonWires(), attrs, compFactory, true) || !SyntaxChecker.isVariableNameAcceptable(newLabel, true) || CorrectLabel.isKeyword(newLabel, true)) continue;
                if (createAction) {
                    act.set(comp, StdAttr.LABEL, newLabel);
                } else {
                    this.setLabel(newLabel, circ, compFactory);
                }
                correct = true;
                continue;
            }
            correct = true;
            newLabel = oldLabel;
        }
        return newLabel;
    }

    public boolean labelKeyboardHandler(int keyCode, AttributeSet attrs, String componentName, Component comp, ComponentFactory compFactory, Circuit circ, SetAttributeAction act, boolean createAction) {
        switch (keyCode) {
            case 76: {
                String oldLabel;
                String newLabel;
                if (attrs.containsAttribute(StdAttr.LABEL) && !(newLabel = this.askAndSetLabel(componentName, oldLabel = attrs.getValue(StdAttr.LABEL), circ, comp, compFactory, attrs, act, createAction)).equals(oldLabel)) {
                    if (!newLabel.isEmpty() && AutoLabel.labelEndsWithNumber(newLabel)) {
                        this.activate(circ);
                    } else {
                        this.active.put(circ, false);
                    }
                }
                return true;
            }
            case 84: {
                if (attrs.containsAttribute(StdAttr.LABEL_VISIBILITY)) {
                    if (createAction) {
                        act.set(comp, StdAttr.LABEL_VISIBILITY, attrs.getValue(StdAttr.LABEL_VISIBILITY) == false);
                    } else {
                        attrs.setValue(StdAttr.LABEL_VISIBILITY, attrs.getValue(StdAttr.LABEL_VISIBILITY) == false);
                    }
                }
                return true;
            }
            case 86: {
                if (attrs.containsAttribute(StdAttr.LABEL_VISIBILITY) && !attrs.getValue(StdAttr.LABEL_VISIBILITY).booleanValue()) {
                    if (createAction) {
                        act.set(comp, StdAttr.LABEL_VISIBILITY, true);
                    } else {
                        attrs.setValue(StdAttr.LABEL_VISIBILITY, true);
                    }
                }
                return true;
            }
            case 72: {
                if (attrs.containsAttribute(StdAttr.LABEL_VISIBILITY) && attrs.getValue(StdAttr.LABEL_VISIBILITY).booleanValue()) {
                    if (createAction) {
                        act.set(comp, StdAttr.LABEL_VISIBILITY, false);
                    } else {
                        attrs.setValue(StdAttr.LABEL_VISIBILITY, false);
                    }
                }
                return true;
            }
            case 65: {
                this.stop(circ);
                return true;
            }
        }
        return false;
    }
}

