/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.util;

import com.cburch.logisim.util.LocaleListener;
import com.cburch.logisim.util.LocaleSelector;
import com.cburch.logisim.util.StringGetter;
import com.cburch.logisim.util.Strings;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.UIManager;

public class LocaleManager {
    private static final String SETTINGS_NAME = "settings";
    private static final ArrayList<LocaleManager> managers = new ArrayList();
    public static final SimpleDateFormat PARSER_SDF = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
    private static final ArrayList<LocaleListener> listeners = new ArrayList();
    private static final HashMap<Character, String> repl = null;
    private static Locale curLocale = null;
    private final String dirName;
    private final String fileStart;
    private ResourceBundle settings = null;
    private ResourceBundle locale = null;

    public LocaleManager(String dirName, String fileStart) {
        this.dirName = dirName;
        this.fileStart = fileStart;
        this.loadDefault();
        managers.add(this);
    }

    public static void addLocaleListener(LocaleListener l) {
        listeners.add(l);
    }

    private static void fireLocaleChanged() {
        for (LocaleListener l : listeners) {
            l.localeChanged();
        }
    }

    public static Locale getLocale() {
        if (curLocale == null) {
            curLocale = Locale.getDefault();
        }
        return curLocale;
    }

    public static void removeLocaleListener(LocaleListener l) {
        listeners.remove(l);
    }

    private static String replaceAccents(String src, HashMap<Character, String> repl) {
        char ci;
        int i;
        int n = src.length();
        for (i = 0; i < n && (ci = src.charAt(i)) >= ' ' && ci < '\u007f'; ++i) {
        }
        if (i == n) {
            return src;
        }
        char[] cs = src.toCharArray();
        StringBuilder ret = new StringBuilder(src.substring(0, i));
        for (int j = i; j < cs.length; ++j) {
            char cj = cs[j];
            if (cj < ' ' || cj >= '\u007f') {
                String out = repl.get(Character.valueOf(cj));
                if (out != null) {
                    ret.append(out);
                    continue;
                }
                ret.append(cj);
                continue;
            }
            ret.append(cj);
        }
        return ret.toString();
    }

    private static void updateButtonText() {
        UIManager.put("FileChooser.openDialogTitleText", Strings.S.get("LMopenDialogTitleText"));
        UIManager.put("FileChooser.saveDialogTitleText", Strings.S.get("LMsaveDialogTitleText"));
        UIManager.put("FileChooser.lookInLabelText", Strings.S.get("LMlookInLabelText"));
        UIManager.put("FileChooser.saveInLabelText", Strings.S.get("LMsaveInLabelText"));
        UIManager.put("FileChooser.upFolderToolTipText", Strings.S.get("LMupFolderToolTipText"));
        UIManager.put("FileChooser.homeFolderToolTipText", Strings.S.get("LMhomeFolderToolTipText"));
        UIManager.put("FileChooser.newFolderToolTipText", Strings.S.get("LMnewFolderToolTipText"));
        UIManager.put("FileChooser.listViewButtonToolTipText", Strings.S.get("LMlistViewButtonToolTipText"));
        UIManager.put("FileChooser.detailsViewButtonToolTipText", Strings.S.get("LMdetailsViewButtonToolTipText"));
        UIManager.put("FileChooser.fileNameHeaderText", Strings.S.get("LMfileNameHeaderText"));
        UIManager.put("FileChooser.fileSizeHeaderText", Strings.S.get("LMfileSizeHeaderText"));
        UIManager.put("FileChooser.fileTypeHeaderText", Strings.S.get("LMfileTypeHeaderText"));
        UIManager.put("FileChooser.fileDateHeaderText", Strings.S.get("LMfileDateHeaderText"));
        UIManager.put("FileChooser.fileAttrHeaderText", Strings.S.get("LMfileAttrHeaderText"));
        UIManager.put("FileChooser.fileNameLabelText", Strings.S.get("LMfileNameLabelText"));
        UIManager.put("FileChooser.filesOfTypeLabelText", Strings.S.get("LMfilesOfTypeLabelText"));
        UIManager.put("FileChooser.openButtonText", Strings.S.get("LMopenButtonText"));
        UIManager.put("FileChooser.openButtonToolTipText", Strings.S.get("LMopenButtonToolTipText"));
        UIManager.put("FileChooser.saveButtonText", Strings.S.get("LMsaveButtonText"));
        UIManager.put("FileChooser.saveButtonToolTipText", Strings.S.get("LMsaveButtonToolTipText"));
        UIManager.put("FileChooser.directoryOpenButtonText", Strings.S.get("LMdirectoryOpenButtonText"));
        UIManager.put("FileChooser.directoryOpenButtonToolTipText", Strings.S.get("LMdirectoryOpenButtonToolTipText"));
        UIManager.put("FileChooser.cancelButtonText", Strings.S.get("LMcancelButtonText"));
        UIManager.put("FileChooser.cancelButtonToolTipText", Strings.S.get("LMcancelButtonToolTipText"));
        UIManager.put("FileChooser.newFolderErrorText", Strings.S.get("LMnewFolderErrorText"));
        UIManager.put("FileChooser.acceptAllFileFilterText", Strings.S.get("LMacceptAllFileFilterText"));
        UIManager.put("OptionPane.okButtonText", Strings.S.get("LMokButtonText"));
        UIManager.put("OptionPane.yesButtonText", Strings.S.get("LMyesButtonText"));
        UIManager.put("OptionPane.noButtonText", Strings.S.get("LMnoButtonText"));
        UIManager.put("OptionPane.cancelButtonText", Strings.S.get("LMcancelButtonText"));
        UIManager.put("ProgressMonitor.progressText", Strings.S.get("LMprogressText"));
    }

    public static void setLocale(Locale loc) {
        Locale cur = LocaleManager.getLocale();
        if (!loc.equals(cur)) {
            Locale[] opts = Strings.S.getLocaleOptions();
            Locale select = null;
            Locale backup = null;
            String locLang = loc.getLanguage();
            for (Locale opt : opts) {
                if (select == null && opt.equals(loc)) {
                    select = opt;
                }
                if (backup != null || !opt.getLanguage().equals(locLang)) continue;
                backup = opt;
            }
            if (select == null) {
                select = Objects.requireNonNullElseGet(backup, () -> Locale.ENGLISH);
            }
            curLocale = select;
            Locale.setDefault(select);
            for (LocaleManager man : managers) {
                man.loadDefault();
            }
            LocaleManager.updateButtonText();
            LocaleManager.fireLocaleChanged();
        }
    }

    public JComponent createLocaleSelector() {
        Locale[] locales = this.getLocaleOptions();
        if (locales == null || locales.length == 0) {
            Locale cur = LocaleManager.getLocale();
            if (cur == null) {
                cur = Locale.ENGLISH;
            }
            locales = new Locale[]{cur};
        }
        return new JScrollPane(new LocaleSelector(locales));
    }

    public String get(String key) {
        String ret;
        try {
            ret = this.locale.getString(key);
        }
        catch (MissingResourceException e) {
            ret = key;
        }
        HashMap<Character, String> repl = LocaleManager.repl;
        if (repl != null) {
            ret = LocaleManager.replaceAccents(ret, repl);
        }
        return ret;
    }

    public String get(String key, Object ... args) {
        return String.format(this.get(key), args);
    }

    public String fmt(String key, Object ... args) {
        return String.format(this.get(key), args);
    }

    public Locale[] getLocaleOptions() {
        String locs = null;
        try {
            if (this.settings != null) {
                locs = this.settings.getString("locales");
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        if (locs == null) {
            return new Locale[0];
        }
        ArrayList<Locale> retl = new ArrayList<Locale>();
        StringTokenizer toks = new StringTokenizer(locs);
        while (toks.hasMoreTokens()) {
            String country;
            String language;
            String f = toks.nextToken();
            if (f.length() >= 2) {
                language = f.substring(0, 2);
                country = f.length() >= 5 ? f.substring(3, 5) : null;
            } else {
                language = null;
                country = null;
            }
            if (language == null) continue;
            Locale loc = new Locale.Builder().setLanguage(language).setRegion(country).build();
            retl.add(loc);
        }
        return retl.toArray(new Locale[0]);
    }

    public StringGetter getter(String key) {
        return new LocaleGetter(this, key);
    }

    public StringGetter getter(String key, String arg) {
        return new LocaleFormatterWithString(this, key, arg);
    }

    public StringGetter getter(String key, StringGetter arg) {
        return new LocaleFormatterWithGetter(this, key, arg);
    }

    public StringGetter fixedString(String value) {
        return new FixedString(value);
    }

    private void loadDefault() {
        if (this.settings == null) {
            try {
                this.settings = ResourceBundle.getBundle(this.dirName + "/settings");
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        try {
            this.loadLocale(Locale.getDefault());
            if (this.locale != null) {
                return;
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        try {
            this.loadLocale(Locale.ENGLISH);
            if (this.locale != null) {
                return;
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        Locale[] choices = this.getLocaleOptions();
        if (choices != null && choices.length > 0) {
            this.loadLocale(choices[0]);
        }
        if (this.locale != null) {
            return;
        }
        throw new RuntimeException("No locale bundles are available");
    }

    private void loadLocale(Locale loc) {
        String bundleName = this.dirName + "/strings/" + this.fileStart + "/" + this.fileStart;
        this.locale = ResourceBundle.getBundle(bundleName, loc);
    }

    private static class LocaleGetter
    implements StringGetter {
        final LocaleManager source;
        final String key;

        LocaleGetter(LocaleManager source, String key) {
            this.source = source;
            this.key = key;
        }

        @Override
        public String toString() {
            return this.source.get(this.key);
        }
    }

    private static class LocaleFormatterWithString
    extends LocaleGetter {
        final String arg;

        LocaleFormatterWithString(LocaleManager source, String key, String arg) {
            super(source, key);
            this.arg = arg;
        }

        @Override
        public String toString() {
            return this.source.fmt(this.key, this.arg);
        }
    }

    private static class LocaleFormatterWithGetter
    extends LocaleGetter {
        final StringGetter arg;

        LocaleFormatterWithGetter(LocaleManager source, String key, StringGetter arg) {
            super(source, key);
            this.arg = arg;
        }

        @Override
        public String toString() {
            return this.source.fmt(this.key, this.arg.toString());
        }
    }

    private static class FixedString
    implements StringGetter {
        final String value;

        FixedString(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }
    }
}

