/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.util;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.concurrent.ConcurrentLinkedQueue;

public class PropertyChangeWeakSupport {
    private static final String ALL_PROPERTIES = "ALL PROPERTIES";
    private final Object source;
    private final ConcurrentLinkedQueue<ListenerData> listeners;

    public PropertyChangeWeakSupport(Object source) {
        this.source = source;
        this.listeners = new ConcurrentLinkedQueue();
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.addPropertyChangeListener(ALL_PROPERTIES, listener);
    }

    public void addPropertyChangeListener(String property, PropertyChangeListener listener) {
        this.listeners.add(new ListenerData(property, listener));
    }

    public <T> void firePropertyChange(String property, T oldValue, T newValue) {
        PropertyChangeEvent e = null;
        Iterator<ListenerData> it = this.listeners.iterator();
        while (it.hasNext()) {
            ListenerData data = it.next();
            PropertyChangeListener singleListener = (PropertyChangeListener)data.listener.get();
            if (singleListener == null) {
                it.remove();
                continue;
            }
            if (!data.property.equals(ALL_PROPERTIES) && !data.property.equals(property)) continue;
            if (e == null) {
                e = new PropertyChangeEvent(this.source, property, oldValue, newValue);
            }
            singleListener.propertyChange(e);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.removePropertyChangeListener(ALL_PROPERTIES, listener);
    }

    public void removePropertyChangeListener(String property, PropertyChangeListener listener) {
        Iterator<ListenerData> it = this.listeners.iterator();
        while (it.hasNext()) {
            ListenerData data = it.next();
            PropertyChangeListener singleListener = (PropertyChangeListener)data.listener.get();
            if (singleListener == null) {
                it.remove();
                continue;
            }
            if (!data.property.equals(property) || singleListener != listener) continue;
            it.remove();
        }
    }

    private static class ListenerData {
        final String property;
        final WeakReference<PropertyChangeListener> listener;

        ListenerData(String property, PropertyChangeListener listener) {
            this.property = property;
            this.listener = new WeakReference<PropertyChangeListener>(listener);
        }
    }
}

