/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.util;

import com.cburch.logisim.fpga.designrulecheck.CorrectLabel;
import com.cburch.logisim.gui.generic.OptionPane;
import com.cburch.logisim.util.StringUtil;
import com.cburch.logisim.util.Strings;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class SyntaxChecker {
    private static final Pattern variablePattern = Pattern.compile("^([a-zA-Z]+\\w*)");
    private static final Pattern forbiddenPattern = Pattern.compile("__");
    private static Matcher forbiddenMatcher;
    private static Matcher variableMatcher;

    private SyntaxChecker() {
        throw new IllegalStateException("Utility class. No instantiation allowed.");
    }

    public static String getErrorMessage(String val) {
        if (StringUtil.isNullOrEmpty(val)) {
            return null;
        }
        variableMatcher = variablePattern.matcher(val);
        forbiddenMatcher = forbiddenPattern.matcher(val);
        String hdl = CorrectLabel.hdlCorrectLabel(val);
        String message = "";
        if (!variableMatcher.matches()) {
            message = message.concat(Strings.S.get("variableInvalidCharacters"));
        }
        if (forbiddenMatcher.find()) {
            message = message.concat(Strings.S.get("variableDoubleUnderscore"));
        }
        if (hdl != null) {
            message = message.concat(hdl.equals("VHDL") ? Strings.S.get("variableVHDLKeyword") : Strings.S.get("variableVerilogKeyword"));
        }
        if (val.endsWith("_")) {
            message = message.concat(Strings.S.get("variableEndsWithUndescore"));
        }
        return message.length() == 0 ? null : message;
    }

    public static boolean isVariableNameAcceptable(String val, Boolean showDialog) {
        String message = SyntaxChecker.getErrorMessage(val);
        if (message != null && showDialog.booleanValue()) {
            OptionPane.showMessageDialog(null, message.concat("\n" + Strings.S.get("variableNameNotAcceptable")));
        }
        return message == null;
    }
}

