/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.util;

import com.cburch.logisim.util.LocaleListener;
import com.cburch.logisim.util.LocaleManager;
import com.cburch.logisim.util.MacCompatibility;
import com.cburch.logisim.util.Strings;
import com.cburch.logisim.util.WindowClosable;
import com.cburch.logisim.util.WindowMenuItem;
import com.cburch.logisim.util.WindowMenuItemManager;
import com.cburch.logisim.util.WindowMenuManager;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.ButtonGroup;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;

public class WindowMenu
extends JMenu {
    private static final long serialVersionUID = 1L;
    private final JFrame owner;
    private final MyListener myListener = new MyListener();
    private final JMenuItem minimize = new JMenuItem();
    private final JMenuItem zoom = new JMenuItem();
    private final JMenuItem close = new JMenuItem();
    private final JRadioButtonMenuItem nullItem = new JRadioButtonMenuItem();
    private final ArrayList<WindowMenuItem> persistentItems = new ArrayList();
    private final ArrayList<WindowMenuItem> transientItems = new ArrayList();

    public WindowMenu(JFrame owner) {
        this.owner = owner;
        WindowMenuManager.addMenu(this);
        int menuMask = this.getToolkit().getMenuShortcutKeyMaskEx();
        this.minimize.setAccelerator(KeyStroke.getKeyStroke(77, menuMask));
        this.close.setAccelerator(KeyStroke.getKeyStroke(87, menuMask));
        if (owner == null) {
            this.minimize.setEnabled(false);
            this.zoom.setEnabled(false);
            this.close.setEnabled(false);
        } else {
            this.minimize.addActionListener(this.myListener);
            this.zoom.addActionListener(this.myListener);
            this.close.addActionListener(this.myListener);
        }
        this.computeEnabled();
        this.computeContents();
        LocaleManager.addLocaleListener(this.myListener);
        this.myListener.localeChanged();
    }

    void addMenuItem(Object source, WindowMenuItem item, boolean isPersistent) {
        if (isPersistent) {
            this.persistentItems.add(item);
        } else {
            this.transientItems.add(item);
        }
        item.addActionListener(this.myListener);
        this.computeContents();
    }

    private void computeContents() {
        JRadioButtonMenuItem jRadioButtonMenuItem;
        WindowMenuItemManager currentManager;
        ButtonGroup bgroup = new ButtonGroup();
        bgroup.add(this.nullItem);
        this.removeAll();
        this.add(this.minimize);
        this.add(this.zoom);
        this.add(this.close);
        if (!this.persistentItems.isEmpty()) {
            this.addSeparator();
            for (JRadioButtonMenuItem jRadioButtonMenuItem2 : this.persistentItems) {
                bgroup.add(jRadioButtonMenuItem2);
                this.add(jRadioButtonMenuItem2);
            }
        }
        if (!this.transientItems.isEmpty()) {
            this.addSeparator();
            for (JRadioButtonMenuItem jRadioButtonMenuItem3 : this.transientItems) {
                bgroup.add(jRadioButtonMenuItem3);
                this.add(jRadioButtonMenuItem3);
            }
        }
        if ((currentManager = WindowMenuManager.getCurrentManager()) != null && (jRadioButtonMenuItem = currentManager.getMenuItem(this)) != null) {
            jRadioButtonMenuItem.setSelected(true);
        }
    }

    void computeEnabled() {
        WindowMenuItemManager currentManager = WindowMenuManager.getCurrentManager();
        this.minimize.setEnabled(currentManager != null);
        this.zoom.setEnabled(currentManager != null);
        this.close.setEnabled(currentManager != null);
    }

    void doClose() {
        JFrame jFrame = this.owner;
        if (jFrame instanceof WindowClosable) {
            WindowClosable windowClosable = (WindowClosable)((Object)jFrame);
            windowClosable.requestClose();
        } else if (this.owner != null) {
            int action = this.owner.getDefaultCloseOperation();
            if (action == 3) {
                System.exit(0);
            } else if (action == 1) {
                this.owner.setVisible(false);
            } else if (action == 2) {
                this.owner.dispose();
            }
        }
    }

    void doMinimize() {
        if (this.owner != null) {
            this.owner.setExtendedState(1);
        }
    }

    void doZoom() {
        if (this.owner == null) {
            return;
        }
        this.owner.pack();
        Dimension screenSize = this.owner.getToolkit().getScreenSize();
        Dimension windowSize = this.owner.getPreferredSize();
        Point windowLoc = this.owner.getLocation();
        boolean locChanged = false;
        boolean sizeChanged = false;
        if (windowLoc.x + windowSize.width > screenSize.width) {
            windowLoc.x = Math.max(0, screenSize.width - windowSize.width);
            locChanged = true;
            if (windowLoc.x + windowSize.width > screenSize.width) {
                windowSize.width = screenSize.width - windowLoc.x;
                sizeChanged = true;
            }
        }
        if (windowLoc.y + windowSize.height > screenSize.height) {
            windowLoc.y = Math.max(0, screenSize.height - windowSize.height);
            locChanged = true;
            if (windowLoc.y + windowSize.height > screenSize.height) {
                windowSize.height = screenSize.height - windowLoc.y;
                sizeChanged = true;
            }
        }
        if (locChanged) {
            this.owner.setLocation(windowLoc);
        }
        if (sizeChanged) {
            this.owner.setSize(windowSize);
        }
    }

    void removeMenuItem(Object source, JRadioButtonMenuItem item) {
        if (this.transientItems.remove(item)) {
            item.removeActionListener(this.myListener);
        }
        this.computeContents();
    }

    void setNullItemSelected(boolean value) {
        this.nullItem.setSelected(value);
    }

    private class MyListener
    implements LocaleListener,
    ActionListener {
        private MyListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            WindowMenuItem choice;
            Object src = e.getSource();
            if (src == WindowMenu.this.minimize) {
                WindowMenu.this.doMinimize();
            } else if (src == WindowMenu.this.zoom) {
                WindowMenu.this.doZoom();
            } else if (src == WindowMenu.this.close) {
                WindowMenu.this.doClose();
            } else if (src instanceof WindowMenuItem && (choice = (WindowMenuItem)src).isSelected()) {
                WindowMenuItem item = this.findOwnerItem();
                if (item != null) {
                    item.setSelected(true);
                }
                choice.actionPerformed(e);
            }
        }

        private WindowMenuItem findOwnerItem() {
            for (WindowMenuItem i : WindowMenu.this.persistentItems) {
                if (i.getJFrame() != WindowMenu.this.owner) continue;
                return i;
            }
            for (WindowMenuItem i : WindowMenu.this.transientItems) {
                if (i.getJFrame() != WindowMenu.this.owner) continue;
                return i;
            }
            return null;
        }

        @Override
        public void localeChanged() {
            WindowMenu.this.setText(Strings.S.get("windowMenu"));
            WindowMenu.this.minimize.setText(Strings.S.get("windowMinimizeItem"));
            WindowMenu.this.close.setText(Strings.S.get("windowCloseItem"));
            WindowMenu.this.zoom.setText(MacCompatibility.isQuitAutomaticallyPresent() ? Strings.S.get("windowZoomItemMac") : Strings.S.get("windowZoomItem"));
        }
    }
}

