/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.vhdl.base;

import com.cburch.logisim.circuit.CircuitState;
import com.cburch.logisim.comp.Component;
import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.std.hdl.VhdlEntityComponent;
import com.cburch.logisim.util.StringGetter;
import com.cburch.logisim.vhdl.Strings;
import com.cburch.logisim.vhdl.base.VhdlEntity;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.LinkedList;
import java.util.List;

public class VhdlSimConstants {
    public static final Charset ENCODING = StandardCharsets.UTF_8;
    public static final String VHDL_TEMPLATES_PATH = "/resources/logisim/hdl/";
    public static final String SIM_RESOURCES_PATH = "/resources/logisim/sim/";
    public static final String SIM_PATH = System.getProperty("java.io.tmpdir") + "/logisim/sim/";
    public static final String SIM_SRC_PATH = SIM_PATH + "src/";
    public static final String SIM_COMP_PATH = SIM_PATH + "comp/";
    public static final String SIM_TOP_FILENAME = "top_sim.vhdl";
    public static final String VHDL_COMPONENT_SIM_NAME = "LogisimVhdlSimComp_";
    public static final String VHDL_COMPILE_COMMAND = "vcom -reportprogress 300 -work work ../src/";
    public static final VhdlSimNameAttribute SIM_NAME_ATTR = new VhdlSimNameAttribute("vhdlSimName", Strings.S.getter("vhdlSimName"));

    public static List<Component> getVhdlComponents(CircuitState s, boolean newStyle) {
        LinkedList<Component> vhdlComp = new LinkedList<Component>();
        for (Component comp : s.getCircuit().getNonWires()) {
            if (comp.getFactory().getClass().equals(VhdlEntityComponent.class)) {
                vhdlComp.add(comp);
            }
            if (!comp.getFactory().getClass().equals(VhdlEntity.class) || !newStyle) continue;
            vhdlComp.add(comp);
        }
        for (CircuitState sub : s.getSubStates()) {
            vhdlComp.addAll(VhdlSimConstants.getVhdlComponents(sub, newStyle));
        }
        return vhdlComp;
    }

    public static class VhdlSimNameAttribute
    extends Attribute<String> {
        private VhdlSimNameAttribute(String name, StringGetter disp) {
            super(name, disp);
        }

        @Override
        public String parse(String value) {
            return value;
        }

        @Override
        public boolean isHidden() {
            return true;
        }
    }

    public static enum State {
        DISABLED,
        ENABLED,
        STARTING,
        RUNNING;

    }
}

