/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.vhdl.gui;

import com.cburch.contracts.BaseDocumentListenerContract;
import com.cburch.logisim.gui.generic.OptionPane;
import com.cburch.logisim.proj.Project;
import com.cburch.logisim.util.FileUtil;
import com.cburch.logisim.util.JFileChoosers;
import com.cburch.logisim.util.JInputDialog;
import com.cburch.logisim.util.LocaleListener;
import com.cburch.logisim.util.LocaleManager;
import com.cburch.logisim.vhdl.Strings;
import com.cburch.logisim.vhdl.base.HdlContent;
import com.cburch.logisim.vhdl.base.HdlModel;
import com.cburch.logisim.vhdl.base.HdlModelListener;
import com.cburch.logisim.vhdl.file.HdlFile;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.WeakHashMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import org.fife.ui.rsyntaxtextarea.AbstractTokenMakerFactory;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.TokenMakerFactory;
import org.fife.ui.rtextarea.RTextScrollPane;

public class HdlContentEditor
extends JDialog
implements JInputDialog {
    private static final long serialVersionUID = 1L;
    private static final int ROWS = 40;
    private static final int COLUMNS = 100;
    private static final String EXPORT_DIR = "hdl_export";
    private final FrameListener frameListener = new FrameListener();
    private final ModelListener modelListener = new ModelListener();
    private final EditorListener editorListener = new EditorListener();
    private RSyntaxTextArea editor;
    private HdlModel model;
    private Project project;
    private final JButton open = new JButton();
    private final JButton save = new JButton();
    private final JButton validate = new JButton();
    private final JButton close = new JButton();
    private static final WeakHashMap<HdlContent, HdlContentEditor> windowRegistry = new WeakHashMap();

    public static boolean confirmImport(Component parent) {
        Object[] options = new String[]{Strings.S.get("importOption"), Strings.S.get("cancelOption")};
        return OptionPane.showOptionDialog(parent, Strings.S.get("importMessage"), Strings.S.get("importTitle"), 0, 3, null, options, options[0]) == 0;
    }

    public HdlContentEditor(Dialog parent, Project proj, HdlModel model) {
        super(parent, Strings.S.get("hdlFrameTitle"), true);
        this.configure(proj, model);
        this.setLocationRelativeTo(parent);
    }

    public HdlContentEditor(Frame parent, Project proj, HdlModel model) {
        super(parent, Strings.S.get("hdlFrameTitle"), true);
        this.configure(proj, model);
        this.setLocationRelativeTo(parent);
    }

    private void close() {
        if (this.editor.getText().equals(this.model.getContent())) {
            this.dispose();
            return;
        }
        if (this.model.setContent(this.editor.getText())) {
            this.dispose();
            return;
        }
        Object[] options = new Object[]{Strings.S.get("confirmCloseYes"), Strings.S.get("confirmCloseNo"), Strings.S.get("confirmCloseBackup")};
        int n = OptionPane.showOptionDialog(this, Strings.S.get("confirmCloseMessage"), Strings.S.get("confirmCloseTitle"), 1, 3, null, options, options[0]);
        switch (n) {
            case 0: {
                this.dispose();
                break;
            }
            case 2: {
                this.save.doClick();
                this.dispose();
            }
        }
    }

    private void configure(Project proj, HdlModel model) {
        this.project = proj;
        this.model = model;
        this.model.addHdlModelListener(this.modelListener);
        this.addWindowListener(this.frameListener);
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.add(this.open);
        buttonsPanel.add(this.save);
        buttonsPanel.add(this.validate);
        buttonsPanel.add(this.close);
        this.open.addActionListener(this.frameListener);
        this.save.addActionListener(this.frameListener);
        this.close.addActionListener(this.frameListener);
        this.validate.addActionListener(this.frameListener);
        AbstractTokenMakerFactory atmf = (AbstractTokenMakerFactory)TokenMakerFactory.getDefaultInstance();
        atmf.putMapping("text/vhdl", "com.cburch.logisim.vhdl.syntax.VhdlSyntax");
        this.editor = new RSyntaxTextArea(40, 100);
        this.editor.setSyntaxEditingStyle("text/vhdl");
        this.editor.setCodeFoldingEnabled(true);
        this.editor.setAntiAliasingEnabled(true);
        this.editor.getDocument().addDocumentListener(this.editorListener);
        RTextScrollPane sp = new RTextScrollPane(this.editor);
        sp.setFoldIndicatorEnabled(true);
        this.add((Component)sp, "Center");
        this.add((Component)buttonsPanel, "South");
        LocaleManager.addLocaleListener(this.frameListener);
        this.frameListener.localeChanged();
        this.pack();
        Dimension size = this.getSize();
        Dimension screen = this.getToolkit().getScreenSize();
        if (size.width > screen.width || size.height > screen.height) {
            size.width = Math.min(size.width, screen.width);
            size.height = Math.min(size.height, screen.height);
            this.setSize(size);
        }
    }

    private File getDefaultExportFile(File defaultFile) {
        File projectFile = this.project.getLogisimFile().getLoader().getMainFile();
        if (projectFile == null) {
            if (defaultFile == null) {
                return new File(this.model.getName() + ".vhd");
            }
            return defaultFile;
        }
        try {
            File compFolder = new File(FileUtil.correctPath(projectFile.getParentFile().getCanonicalPath()) + EXPORT_DIR);
            if (!compFolder.exists() || compFolder.exists() && !compFolder.isDirectory()) {
                compFolder.mkdir();
            }
            return new File(FileUtil.correctPath(compFolder.getCanonicalPath()) + this.model.getName() + ".vhd");
        }
        catch (IOException ex) {
            return defaultFile;
        }
    }

    public String getText() {
        return this.editor.getText();
    }

    @Override
    public Object getValue() {
        return this.model;
    }

    public void setText(String content) {
        this.editor.setText(content);
        this.editor.discardAllEdits();
    }

    @Override
    public void setValue(Object value) {
        this.model = (HdlModel)value;
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            this.editor.setText(this.model.getContent());
            this.editor.discardAllEdits();
        }
        super.setVisible(b);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HdlContentEditor getContentEditor(Window source, HdlContent value, Project proj) {
        WeakHashMap<HdlContent, HdlContentEditor> weakHashMap = windowRegistry;
        synchronized (weakHashMap) {
            HdlContentEditor ret = windowRegistry.get(value);
            if (ret == null) {
                ret = source instanceof Frame ? new HdlContentEditor((Frame)source, proj, (HdlModel)value) : new HdlContentEditor((Dialog)source, proj, (HdlModel)value);
                windowRegistry.put(value, ret);
            }
            return ret;
        }
    }

    private class FrameListener
    extends WindowAdapter
    implements ActionListener,
    LocaleListener {
        private FrameListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            Object source = event.getSource();
            if (source == HdlContentEditor.this.open) {
                if (!HdlContentEditor.this.editor.getText().equals(HdlContentEditor.this.model.getContent()) && !HdlContentEditor.confirmImport(HdlContentEditor.this)) {
                    return;
                }
                String vhdl = HdlContentEditor.this.project.getLogisimFile().getLoader().vhdlImportChooser(HdlContentEditor.this);
                if (vhdl != null) {
                    HdlContentEditor.this.setText(vhdl);
                }
            }
            if (source == HdlContentEditor.this.save) {
                JFileChooser chooser = JFileChoosers.createSelected(HdlContentEditor.this.getDefaultExportFile(null));
                chooser.setDialogTitle(Strings.S.get("hdlSaveButton"));
                int choice = chooser.showSaveDialog(HdlContentEditor.this);
                if (choice == 0) {
                    File f = chooser.getSelectedFile();
                    try {
                        HdlFile.save(f, HdlContentEditor.this.getText());
                    }
                    catch (IOException e) {
                        OptionPane.showMessageDialog(HdlContentEditor.this, e.getMessage(), Strings.S.get("hexSaveErrorTitle"), 0);
                    }
                }
            }
            if (source == HdlContentEditor.this.validate) {
                HdlContentEditor.this.model.setContent(HdlContentEditor.this.editor.getText());
            }
            if (source == HdlContentEditor.this.close) {
                HdlContentEditor.this.close();
            }
        }

        @Override
        public void localeChanged() {
            HdlContentEditor.this.setTitle(Strings.S.get("hdlFrameTitle"));
            HdlContentEditor.this.open.setText(Strings.S.get("hdlOpenButton"));
            HdlContentEditor.this.save.setText(Strings.S.get("hdlSaveButton"));
            HdlContentEditor.this.validate.setText(Strings.S.get("validateAndSaveButton"));
            HdlContentEditor.this.close.setText(Strings.S.get("closeButton"));
        }

        @Override
        public void windowClosing(WindowEvent e) {
            HdlContentEditor.this.close();
        }
    }

    private class ModelListener
    implements HdlModelListener {
        private ModelListener() {
        }

        @Override
        public void contentSet(HdlModel source) {
            HdlContentEditor.this.validate.setEnabled(false);
        }
    }

    private class EditorListener
    implements BaseDocumentListenerContract {
        private EditorListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent de) {
            HdlContentEditor.this.validate.setEnabled(!HdlContentEditor.this.editor.getText().equals(HdlContentEditor.this.model.getContent()));
        }

        @Override
        public void removeUpdate(DocumentEvent de) {
            HdlContentEditor.this.validate.setEnabled(!HdlContentEditor.this.editor.getText().equals(HdlContentEditor.this.model.getContent()));
        }
    }
}

