/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.vhdl.sim;

import com.cburch.logisim.circuit.CircuitEvent;
import com.cburch.logisim.circuit.CircuitListener;
import com.cburch.logisim.circuit.CircuitState;
import com.cburch.logisim.comp.Component;
import com.cburch.logisim.comp.ComponentFactory;
import com.cburch.logisim.proj.Project;
import com.cburch.logisim.std.hdl.VhdlEntityComponent;
import com.cburch.logisim.util.SocketClient;
import com.cburch.logisim.vhdl.base.VhdlEntity;
import com.cburch.logisim.vhdl.base.VhdlSimConstants;
import com.cburch.logisim.vhdl.sim.VhdlSimulatorListener;
import com.cburch.logisim.vhdl.sim.VhdlSimulatorTclBinder;
import com.cburch.logisim.vhdl.sim.VhdlSimulatorTclComp;
import com.cburch.logisim.vhdl.sim.VhdlSimulatorVhdlTop;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.List;
import javax.help.UnsupportedOperationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VhdlSimulatorTop
implements CircuitListener {
    private final VhdlSimulatorVhdlTop vhdlTop = new VhdlSimulatorVhdlTop(this);
    private final VhdlSimulatorTclComp tclRun = new VhdlSimulatorTclComp(this);
    private VhdlSimulatorTclBinder tclBinder;
    private final SocketClient socketClient = new SocketClient();
    public static final Logger logger = LoggerFactory.getLogger(VhdlSimulatorTop.class);
    private final Project project;
    private static final ArrayList<VhdlSimulatorListener> listeners = new ArrayList();
    private VhdlSimConstants.State state = VhdlSimConstants.State.DISABLED;

    public VhdlSimulatorTop(Project circuitState) {
        this.project = circuitState;
    }

    public void addVhdlSimStateListener(VhdlSimulatorListener l) {
        listeners.add(l);
    }

    @Override
    public void circuitChanged(CircuitEvent event) {
        if (this.hasVhdlComponent(this.getProject())) {
            this.start();
        } else {
            this.stop();
        }
    }

    public void disable() {
        switch (this.state) {
            case RUNNING: {
                this.stop();
                break;
            }
            case ENABLED: {
                break;
            }
            case DISABLED: {
                return;
            }
            default: {
                throw new UnsupportedOperationException("Cannot disable VHDL simulator from " + this.state + " state");
            }
        }
        this.setState(VhdlSimConstants.State.DISABLED);
        if (this.getProject().getFrame() != null) {
            this.getProject().getFrame().setVhdlSimulatorConsoleStatusInvisible();
            this.getProject().getFrame().getVhdlSimulatorConsole().clear();
        }
    }

    public void enable() {
        if (this.tclBinder == null) {
            this.tclBinder = new VhdlSimulatorTclBinder(this);
        }
        switch (this.state) {
            case RUNNING: {
                this.stop();
                break;
            }
            case ENABLED: {
                return;
            }
            case DISABLED: {
                break;
            }
            default: {
                throw new UnsupportedOperationException("Cannot enable VHDL simulator from " + this.state + " state");
            }
        }
        int i = 0;
        while (this.getProject().getFrame() == null) {
            try {
                Thread.sleep(100L);
                if (i == 10) break;
                ++i;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        if (i != 10) {
            this.getProject().getFrame().setVhdlSimulatorConsoleStatusVisible();
        }
        this.setState(VhdlSimConstants.State.ENABLED);
        this.start();
    }

    public void fireInvalidated() {
    }

    private void fireVhdlSimStateChanged() {
        for (VhdlSimulatorListener l : listeners) {
            l.stateChanged();
        }
    }

    public void generateFiles() {
        this.vhdlTop.fireInvalidated();
        this.tclRun.fireInvalidated();
        new File(VhdlSimConstants.SIM_PATH).mkdirs();
        new File(VhdlSimConstants.SIM_SRC_PATH).mkdirs();
        new File(VhdlSimConstants.SIM_COMP_PATH).mkdirs();
        try {
            Files.copy(this.getClass().getResourceAsStream("/resources/logisim/sim/questasim_binder.tcl"), Paths.get(VhdlSimConstants.SIM_PATH + "questasim_binder.tcl", new String[0]), StandardCopyOption.REPLACE_EXISTING);
            Files.copy(this.getClass().getResourceAsStream("/resources/logisim/sim/run.tcl"), Paths.get(VhdlSimConstants.SIM_PATH + "run.tcl", new String[0]), StandardCopyOption.REPLACE_EXISTING);
            Files.copy(this.getClass().getResourceAsStream("/resources/logisim/sim/modelsim.ini"), Paths.get(VhdlSimConstants.SIM_COMP_PATH + "modelsim.ini", new String[0]), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            logger.error("Cannot copy simulation files: {}", (Object)e.getMessage());
            e.printStackTrace();
        }
        List<Component> vhdlComponents = VhdlSimConstants.getVhdlComponents(this.project.getCircuitState(), true);
        for (int index = 0; index < vhdlComponents.size(); ++index) {
            ComponentFactory fact = vhdlComponents.get(index).getFactory();
            String label = "LogisimVhdlSimComp_" + index;
            if (fact instanceof VhdlEntity) {
                ((VhdlEntity)fact).setSimName(vhdlComponents.get(index).getAttributeSet(), label);
                continue;
            }
            ((VhdlEntityComponent)fact).setSimName(vhdlComponents.get(index).getAttributeSet(), label);
        }
        this.vhdlTop.generate(vhdlComponents);
        this.tclRun.generate(vhdlComponents);
        for (Component comp : vhdlComponents) {
            ComponentFactory fact = comp.getFactory();
            if (fact instanceof VhdlEntity) {
                ((VhdlEntity)fact).saveFile(comp.getAttributeSet());
                continue;
            }
            ((VhdlEntityComponent)fact).saveFile(comp.getAttributeSet());
        }
    }

    public Project getProject() {
        return this.project;
    }

    public SocketClient getSocketClient() {
        return this.socketClient;
    }

    public VhdlSimConstants.State getState() {
        return this.state;
    }

    private boolean hasVhdlComponent(CircuitState s) {
        for (Component comp : s.getCircuit().getNonWires()) {
            if (comp.getFactory().getClass().equals(VhdlEntity.class)) {
                return true;
            }
            if (!comp.getFactory().getClass().equals(VhdlEntityComponent.class)) continue;
            return true;
        }
        for (CircuitState sub : s.getSubStates()) {
            if (!this.hasVhdlComponent(sub)) continue;
            return true;
        }
        return false;
    }

    private boolean hasVhdlComponent(Project p) {
        return this.hasVhdlComponent(p.getCircuitState());
    }

    public boolean isEnabled() {
        return this.state != VhdlSimConstants.State.DISABLED;
    }

    public boolean isRunning() {
        return this.state == VhdlSimConstants.State.RUNNING;
    }

    public String receive() {
        if (!this.isRunning()) {
            throw new UnsupportedOperationException();
        }
        return this.socketClient.receive();
    }

    public void removeVhdlSimStateListener(VhdlSimulatorListener l) {
        listeners.remove(l);
    }

    public void reset() {
        if (this.isEnabled()) {
            this.socketClient.send("restart");
        }
    }

    public void restart() {
        switch (this.state) {
            case ENABLED: 
            case DISABLED: 
            case STARTING: {
                this.start();
                return;
            }
            case RUNNING: {
                this.stop();
                this.start();
                break;
            }
            default: {
                throw new UnsupportedOperationException("Cannot restart VHDL simulator from " + this.state + " state");
            }
        }
    }

    public void send(String message) {
        if (!this.isRunning()) {
            throw new UnsupportedOperationException();
        }
        this.socketClient.send(message);
    }

    public void setEnabled(Boolean enable) {
        if (enable.booleanValue()) {
            this.enable();
        } else {
            this.disable();
        }
    }

    public void setState(VhdlSimConstants.State newState) {
        this.state = newState;
        this.fireVhdlSimStateChanged();
    }

    public void start() {
        if (!this.hasVhdlComponent(this.getProject())) {
            return;
        }
        switch (this.state) {
            case RUNNING: 
            case DISABLED: 
            case STARTING: {
                return;
            }
            case ENABLED: {
                this.setState(VhdlSimConstants.State.STARTING);
                this.generateFiles();
                this.tclBinder.start();
                break;
            }
            default: {
                throw new UnsupportedOperationException("Cannot start VHDL simulator from " + this.state + " state");
            }
        }
    }

    public void stop() {
        switch (this.state) {
            case ENABLED: 
            case DISABLED: {
                return;
            }
            case RUNNING: {
                break;
            }
            case STARTING: {
                break;
            }
            default: {
                throw new UnsupportedOperationException("Cannot stop VHDL simulator from " + this.state + " state");
            }
        }
        this.tclBinder.stop();
        this.socketClient.stop();
        this.setState(VhdlSimConstants.State.ENABLED);
    }

    public void tclStartCallback() {
        this.socketClient.start();
        this.setState(VhdlSimConstants.State.RUNNING);
    }
}

