/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.de;

import java.util.Calendar;
import java.util.Locale;
import org.languagetool.tools.StringTools;

class DateFilterHelper {
    DateFilterHelper() {
    }

    protected Calendar getCalendar() {
        return Calendar.getInstance(Locale.GERMANY);
    }

    protected int getDayOfWeek(String dayStr) {
        String day = StringTools.trimSpecialCharacters((String)dayStr).toLowerCase();
        if (day.startsWith("sonnabend")) {
            return 7;
        }
        if (day.startsWith("so")) {
            return 1;
        }
        if (day.startsWith("mo")) {
            return 2;
        }
        if (day.startsWith("di")) {
            return 3;
        }
        if (day.startsWith("mi")) {
            return 4;
        }
        if (day.startsWith("do")) {
            return 5;
        }
        if (day.startsWith("fr")) {
            return 6;
        }
        if (day.startsWith("sa")) {
            return 7;
        }
        throw new RuntimeException("Could not find day of week for '" + dayStr + "'");
    }

    protected String getDayOfWeek(Calendar date) {
        return date.getDisplayName(7, 2, Locale.GERMAN);
    }

    protected int getMonth(String monthStr) {
        String mon = StringTools.trimSpecialCharacters((String)monthStr).toLowerCase();
        if (mon.startsWith("j\u00e4n")) {
            return 1;
        }
        if (mon.startsWith("jan")) {
            return 1;
        }
        if (mon.startsWith("feb")) {
            return 2;
        }
        if (mon.startsWith("m\u00e4r")) {
            return 3;
        }
        if (mon.startsWith("apr")) {
            return 4;
        }
        if (mon.startsWith("mai")) {
            return 5;
        }
        if (mon.startsWith("jun")) {
            return 6;
        }
        if (mon.startsWith("jul")) {
            return 7;
        }
        if (mon.startsWith("aug")) {
            return 8;
        }
        if (mon.startsWith("sep")) {
            return 9;
        }
        if (mon.startsWith("okt")) {
            return 10;
        }
        if (mon.startsWith("nov")) {
            return 11;
        }
        if (mon.startsWith("dez")) {
            return 12;
        }
        throw new RuntimeException("Could not find month '" + monthStr + "'");
    }
}

